/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class DungeonStatTracker {
    public int totalObjectives;
    public int layers;
    public int chests;
    public int spawners;
    public int rooms;
    public int traps;
    public LayerStatTracker[] stats;

    public DungeonStatTracker(int layers) {
        this.layers = layers;
        this.stats = new LayerStatTracker[layers];
    }

    public LayerStatTracker getLayerTracker(int layer) {
        return this.stats[layer];
    }

    public void build() {
        for (LayerStatTracker tracker : this.stats) {
            this.totalObjectives += tracker.totalObjectives;
            this.chests += tracker.chests;
            this.spawners += tracker.spawners;
            this.rooms += tracker.rooms;
            this.traps += tracker.traps;
            tracker.objectives.addAll(Lists.newArrayList((Object[])new String[]{"  Objectives: " + tracker.totalObjectives, "  Chests: " + tracker.chests, "  Spawners: " + tracker.spawners, "  Rooms: " + tracker.rooms, "  Traps: " + tracker.traps}));
        }
    }

    public ArrayList<String> getObjectives() {
        ArrayList objectives = Lists.newArrayList();
        int layer = 1;
        for (LayerStatTracker tracker : this.stats) {
            objectives.add("----  Layer " + layer++ + "  ----");
            objectives.addAll(tracker.objectives);
            objectives.add("\n");
        }
        return objectives;
    }

    public static class LayerStatTracker {
        public int totalObjectives;
        public int chests;
        public int spawners;
        public int rooms;
        public int traps;
        public List<String> objectives = Lists.newArrayList();
    }
}

