/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.dungeon.treasure.function.EnchantedBook;
import xiroc.dungeoncrawl.dungeon.treasure.function.MaterialBlocks;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomItem;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomPotion;
import xiroc.dungeoncrawl.dungeon.treasure.function.Shield;
import xiroc.dungeoncrawl.dungeon.treasure.function.SuspiciousStew;

public class Treasure {
    public static final HashMap<Type, ResourceLocation> SPECIAL_LOOT_TABLES = new HashMap();

    public static void init() {
        SPECIAL_LOOT_TABLES.put(Type.SUPPLY, Loot.SUPPLY_CHEST);
        SPECIAL_LOOT_TABLES.put(Type.KITCHEN, Loot.KITCHEN_CHEST);
        SPECIAL_LOOT_TABLES.put(Type.TREASURE, Loot.TREASURE_ROOM);
        SPECIAL_LOOT_TABLES.put(Type.LIBRARY, Loot.LIBRARY);
        SPECIAL_LOOT_TABLES.put(Type.TREASURE, Loot.TREASURE_ROOM);
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new RandomItem.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new RandomPotion.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new EnchantedBook.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new MaterialBlocks.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new Shield.Serializer());
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new SuspiciousStew.Serializer());
    }

    public static enum Type {
        DEFAULT,
        KITCHEN,
        SMELTERY,
        MINECART,
        SECRET_ROOM,
        LIBRARY,
        BUILDERS_ROOM,
        TREASURE,
        SUPPLY;

        public static final HashMap<Integer, Type> INT_TO_TYPE_MAP;
        public static final HashMap<Type, Integer> TYPE_TO_INT_MAP;

        public static Type fromInt(int typeID) {
            return INT_TO_TYPE_MAP.getOrDefault(typeID, DEFAULT);
        }

        public static int toInt(Type type) {
            return TYPE_TO_INT_MAP.get((Object)type);
        }

        static {
            INT_TO_TYPE_MAP = new HashMap();
            INT_TO_TYPE_MAP.put(0, DEFAULT);
            INT_TO_TYPE_MAP.put(1, KITCHEN);
            INT_TO_TYPE_MAP.put(2, SMELTERY);
            INT_TO_TYPE_MAP.put(3, MINECART);
            INT_TO_TYPE_MAP.put(4, SECRET_ROOM);
            INT_TO_TYPE_MAP.put(5, LIBRARY);
            INT_TO_TYPE_MAP.put(6, BUILDERS_ROOM);
            INT_TO_TYPE_MAP.put(7, TREASURE);
            INT_TO_TYPE_MAP.put(8, SUPPLY);
            TYPE_TO_INT_MAP = new HashMap();
            INT_TO_TYPE_MAP.forEach((key, value) -> TYPE_TO_INT_MAP.put((Type)((Object)value), (Integer)key));
        }
    }
}

