/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.dungeon.treasure.EnchantedBook;
import xiroc.dungeoncrawl.dungeon.treasure.TreasureEntry;
import xiroc.dungeoncrawl.theme.ThemeItems;

public class TreasureItems {
    public static final ItemStack LAUDANUM;
    public static final ItemStack ANIMUS;
    public static final ItemStack NECTAR;
    public static final ItemStack LUMA;
    public static final ItemStack VELOCITAS;
    public static final ItemStack POTION_HEALING;
    public static final ItemStack POTION_HEALING_II;
    public static final ItemStack POTION_REGENERATION;
    public static final ItemStack POTION_REGENERATION_LONG;
    public static final ItemStack POTION_REGENERATION_II;
    public static final ItemStack SPLASH_POISON;
    public static final ItemStack SPLASH_POISON_LONG;
    public static final ItemStack SPLASH_HARMING;
    public static final ItemStack SPLASH_HARMING_II;
    public static ItemStack[] SPECIAL_POTIONS;
    public static final TreasureEntry RANDOM_SPECIAL_ITEM;
    public static final TreasureEntry ENCHANTED_BOOK;
    public static final TreasureEntry MATERIAL_BLOCKS;

    public static CompoundNBT createDisplayTag(String name, String ... loreEntries) {
        CompoundNBT display = new CompoundNBT();
        display.func_218657_a("Name", (INBT)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(name))));
        ListNBT lore = new ListNBT();
        for (String line : loreEntries) {
            lore.add((Object)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(line))));
        }
        if (lore.size() > 0) {
            display.func_218657_a("Lore", (INBT)lore);
        }
        return display;
    }

    public static CompoundNBT createPotionTag(String potionName) {
        CompoundNBT potion = new CompoundNBT();
        potion.func_74778_a("Potion", potionName);
        return potion;
    }

    public static CompoundNBT createEnchantmentTag(String enchantment, int level) {
        CompoundNBT enchantmentTag = new CompoundNBT();
        enchantmentTag.func_74778_a("id", enchantment);
        enchantmentTag.func_74768_a("lvl", level);
        return enchantmentTag;
    }

    public static ItemStack createItemWithNbt(Item item, CompoundNBT nbt) {
        ItemStack stack = new ItemStack((IItemProvider)item);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack getRandomSpecialPotion(Random rand, int stage) {
        int bound = stage == 0 ? 1 : SPECIAL_POTIONS.length;
        return SPECIAL_POTIONS[rand.nextInt(bound)].func_77946_l();
    }

    static {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT customPotionEffects = new ListNBT();
        CompoundNBT nausea = new CompoundNBT();
        nausea.func_74768_a("Id", 9);
        nausea.func_74768_a("Duration", 100);
        CompoundNBT blindness = new CompoundNBT();
        blindness.func_74768_a("Id", 15);
        blindness.func_74768_a("Duration", 100);
        CompoundNBT weakness = new CompoundNBT();
        weakness.func_74768_a("Id", 18);
        weakness.func_74768_a("Duration", 100);
        CompoundNBT miningFatique = new CompoundNBT();
        miningFatique.func_74768_a("Id", 4);
        miningFatique.func_74768_a("Duration", 100);
        CompoundNBT regeneration = new CompoundNBT();
        regeneration.func_74768_a("Id", 10);
        regeneration.func_74768_a("Amplifier", 1);
        regeneration.func_74768_a("Duration", 160);
        customPotionEffects.add((Object)regeneration);
        customPotionEffects.add((Object)blindness);
        customPotionEffects.add((Object)weakness);
        customPotionEffects.add((Object)miningFatique);
        customPotionEffects.add((Object)nausea);
        nbt.func_218657_a("CustomPotionEffects", (INBT)customPotionEffects);
        nbt.func_74768_a("CustomPotionColor", 7014144);
        nbt.func_74768_a("HideFlags", 32);
        CompoundNBT display = new CompoundNBT();
        ListNBT lore = new ListNBT();
        lore.add((Object)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent("A medicinal tincture."))));
        display.func_218657_a("Lore", (INBT)lore);
        display.func_218657_a("Name", (INBT)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent("Laudanum"))));
        nbt.func_218657_a("display", (INBT)display);
        LAUDANUM = new ItemStack((IItemProvider)Items.field_151068_bn);
        LAUDANUM.func_77982_d(nbt);
        nbt = new CompoundNBT();
        customPotionEffects = new ListNBT();
        CompoundNBT wither = new CompoundNBT();
        wither.func_74768_a("Id", 20);
        wither.func_74768_a("Duration", 40);
        blindness = new CompoundNBT();
        blindness.func_74768_a("Id", 15);
        blindness.func_74768_a("Duration", 40);
        CompoundNBT strength = new CompoundNBT();
        strength.func_74768_a("Id", 5);
        strength.func_74768_a("Duration", 800);
        customPotionEffects.add((Object)strength);
        customPotionEffects.add((Object)blindness);
        customPotionEffects.add((Object)wither);
        nbt.func_218657_a("CustomPotionEffects", (INBT)customPotionEffects);
        nbt.func_74768_a("CustomPotionColor", 13050390);
        nbt.func_74768_a("HideFlags", 32);
        CompoundNBT display2 = new CompoundNBT();
        ListNBT lore2 = new ListNBT();
        lore2.add((Object)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent("An unstable mixture."))));
        display2.func_218657_a("Lore", (INBT)lore2);
        display2.func_218657_a("Name", (INBT)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent("Animus"))));
        nbt.func_218657_a("display", (INBT)display2);
        ANIMUS = new ItemStack((IItemProvider)Items.field_151068_bn);
        ANIMUS.func_77982_d(nbt);
        nbt = new CompoundNBT();
        customPotionEffects = new ListNBT();
        CompoundNBT resistance = new CompoundNBT();
        resistance.func_74768_a("Id", 11);
        resistance.func_74768_a("Duration", 400);
        blindness = new CompoundNBT();
        blindness.func_74768_a("Id", 15);
        blindness.func_74768_a("Duration", 100);
        CompoundNBT absorption = new CompoundNBT();
        absorption.func_74768_a("Id", 22);
        absorption.func_74768_a("Amplifier", 14);
        absorption.func_74768_a("Duration", 400);
        customPotionEffects.add((Object)absorption);
        customPotionEffects.add((Object)resistance);
        customPotionEffects.add((Object)blindness);
        nbt.func_218657_a("CustomPotionEffects", (INBT)customPotionEffects);
        nbt.func_74768_a("CustomPotionColor", 15446551);
        nbt.func_74768_a("HideFlags", 32);
        display2 = new CompoundNBT();
        lore2 = new ListNBT();
        lore2.add((Object)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent("A floral extract."))));
        display2.func_218657_a("Lore", (INBT)lore2);
        display2.func_218657_a("Name", (INBT)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent("Nectar"))));
        nbt.func_218657_a("display", (INBT)display2);
        NECTAR = new ItemStack((IItemProvider)Items.field_151068_bn);
        NECTAR.func_77982_d(nbt);
        nbt = new CompoundNBT();
        customPotionEffects = new ListNBT();
        CompoundNBT speed = new CompoundNBT();
        speed.func_74768_a("Id", 1);
        speed.func_74768_a("Amplifier", 1);
        speed.func_74768_a("Duration", 400);
        blindness = new CompoundNBT();
        blindness.func_74768_a("Id", 15);
        blindness.func_74768_a("Duration", 40);
        CompoundNBT haste = new CompoundNBT();
        haste.func_74768_a("Id", 3);
        haste.func_74768_a("Duration", 400);
        customPotionEffects.add((Object)speed);
        customPotionEffects.add((Object)haste);
        customPotionEffects.add((Object)blindness);
        nbt.func_218657_a("CustomPotionEffects", (INBT)customPotionEffects);
        nbt.func_74768_a("CustomPotionColor", 65327);
        nbt.func_74768_a("HideFlags", 32);
        display2 = new CompoundNBT();
        lore2 = new ListNBT();
        lore2.add((Object)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent("An energetic beverage."))));
        display2.func_218657_a("Lore", (INBT)lore2);
        display2.func_218657_a("Name", (INBT)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent("Velocitas"))));
        nbt.func_218657_a("display", (INBT)display2);
        VELOCITAS = new ItemStack((IItemProvider)Items.field_151068_bn);
        VELOCITAS.func_77982_d(nbt);
        nbt = new CompoundNBT();
        customPotionEffects = new ListNBT();
        CompoundNBT glowing = new CompoundNBT();
        glowing.func_74768_a("Id", 24);
        glowing.func_74768_a("Duration", 12000);
        customPotionEffects.add((Object)glowing);
        nbt.func_218657_a("CustomPotionEffects", (INBT)customPotionEffects);
        nbt.func_74768_a("CustomPotionColor", 0xFAFA00);
        nbt.func_74768_a("HideFlags", 32);
        CompoundNBT display3 = new CompoundNBT();
        ListNBT lore3 = new ListNBT();
        lore3.add((Object)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent("A glowstone extract."))));
        display3.func_218657_a("Lore", (INBT)lore3);
        display3.func_218657_a("Name", (INBT)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent("Luma"))));
        nbt.func_218657_a("display", (INBT)display3);
        LUMA = new ItemStack((IItemProvider)Items.field_151068_bn);
        LUMA.func_77982_d(nbt);
        RANDOM_SPECIAL_ITEM = new TreasureEntry("minecraft:air", 1);
        POTION_HEALING = TreasureItems.createItemWithNbt(Items.field_151068_bn, TreasureItems.createPotionTag("minecraft:healing"));
        POTION_HEALING_II = TreasureItems.createItemWithNbt(Items.field_151068_bn, TreasureItems.createPotionTag("minecraft:strong_healing"));
        POTION_REGENERATION = TreasureItems.createItemWithNbt(Items.field_151068_bn, TreasureItems.createPotionTag("minecraft:regeneration"));
        POTION_REGENERATION_LONG = TreasureItems.createItemWithNbt(Items.field_151068_bn, TreasureItems.createPotionTag("minecraft:long_regeneration"));
        POTION_REGENERATION_II = TreasureItems.createItemWithNbt(Items.field_151068_bn, TreasureItems.createPotionTag("minecraft:strong_regeneration"));
        SPLASH_POISON = TreasureItems.createItemWithNbt(Items.field_151068_bn, TreasureItems.createPotionTag("minecraft:poison"));
        SPLASH_POISON_LONG = TreasureItems.createItemWithNbt(Items.field_151068_bn, TreasureItems.createPotionTag("minecraft:long_poison"));
        SPLASH_HARMING = TreasureItems.createItemWithNbt(Items.field_151068_bn, TreasureItems.createPotionTag("minecraft:harming"));
        SPLASH_HARMING_II = TreasureItems.createItemWithNbt(Items.field_151068_bn, TreasureItems.createPotionTag("minecraft:strong_harming"));
        SPECIAL_POTIONS = new ItemStack[]{LAUDANUM, ANIMUS, NECTAR, LUMA, VELOCITAS};
        ENCHANTED_BOOK = new TreasureEntry("minecraft:book", 1).withProcessor((world, rand, theme, lootLevel) -> {
            ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
            Enchantment enchantment = EnchantedBook.getRandomEnchantment(rand, lootLevel);
            RandomEquipment.enchantItem(book, rand, enchantment, RandomEquipment.getStageMultiplier(lootLevel));
            return book;
        });
        MATERIAL_BLOCKS = new TreasureEntry("minecraft:air", 1).withProcessor((world, rand, theme, lootlevel) -> new ItemStack((IItemProvider)ForgeRegistries.BLOCKS.getValue(ThemeItems.getMaterial(theme)), rand.nextInt(5 + lootlevel * 4)));
    }
}

