/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.treasure.TreasureEntry;

public class TreasureLootTable {
    private static boolean BUILT = false;
    public static final List<TreasureLootTable> LOOT_TABLES = Lists.newArrayList();
    public String name;
    public RandomValueRange rolls;
    public float minRolls;
    public float maxRolls;
    public VanillaImport[] vanillaImports;
    public ArrayList<TreasureEntry> entries;
    public Integer totalWeight;

    public TreasureLootTable(String name, RandomValueRange rolls, TreasureEntry ... entries) {
        this.name = name;
        if (rolls != null) {
            this.minRolls = rolls.func_186509_a();
            this.maxRolls = rolls.func_186512_b();
        }
        this.entries = new ArrayList();
        for (TreasureEntry entry : entries) {
            this.entries.add(entry);
        }
        this.vanillaImports = new VanillaImport[0];
    }

    public TreasureLootTable(String name, RandomValueRange rolls, TreasureLootTable entries) {
        this.name = name;
        if (rolls != null) {
            this.minRolls = rolls.func_186509_a();
            this.maxRolls = rolls.func_186512_b();
        }
        this.entries = new ArrayList();
        for (TreasureEntry entry : entries.entries) {
            this.entries.add(entry);
        }
        this.vanillaImports = new VanillaImport[0];
    }

    public void build(LootTableManager manager) {
        if (this.vanillaImports != null) {
            for (VanillaImport importRessource : this.vanillaImports) {
                DungeonCrawl.LOGGER.debug("Importing {} into {}", (Object)importRessource.location, (Object)this.name);
                importRessource.build(manager);
                this.entries.add(new TreasureEntry.VanillaLootTable(importRessource));
            }
        }
        this.totalWeight = 0;
        for (TreasureEntry entry : this.entries) {
            entry.readResourceLocation();
            this.totalWeight = this.totalWeight + entry.weight;
        }
        this.rolls = new RandomValueRange(this.minRolls, this.maxRolls);
    }

    private List<ItemStack> roll(ServerWorld world, Random rand, int theme, int lootLevel) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.rolls.func_186511_a(rand); ++i) {
            list.add(this.getItemStack(world, rand, theme, lootLevel));
        }
        return list;
    }

    public ItemStack getItemStack(ServerWorld world, Random rand, int theme, int lootLevel) {
        int item = rand.nextInt(this.totalWeight);
        int k = 0;
        for (TreasureEntry entry : this.entries) {
            if (k + entry.weight > item) {
                return entry.generate(world, rand, theme, lootLevel);
            }
            k += entry.weight;
        }
        DungeonCrawl.LOGGER.error("Could not find an item with weight {} in {}. Maximum weight is {}.", (Object)item, (Object)this.name, (Object)this.totalWeight);
        return ItemStack.field_190927_a;
    }

    public void fillInventory(IInventory inventory, ServerWorld world, Random rand, int theme, int lootLevel) {
        List<ItemStack> list = this.roll(world, rand, theme, lootLevel);
        List<Integer> slots = this.getEmptySlotsRandomized(inventory, rand);
        this.shuffleItems(list, slots.size(), rand);
        for (ItemStack itemStack : list) {
            if (slots.isEmpty()) {
                DungeonCrawl.LOGGER.warn("Tried to over-fill a container");
                return;
            }
            if (itemStack.func_190926_b()) {
                inventory.func_70299_a(slots.remove(slots.size() - 1).intValue(), ItemStack.field_190927_a);
                continue;
            }
            inventory.func_70299_a(slots.remove(slots.size() - 1).intValue(), itemStack);
        }
    }

    private void shuffleItems(List<ItemStack> stacks, int p_186463_2_, Random rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.func_190926_b()) {
                iterator.remove();
                continue;
            }
            if (itemstack.func_190916_E() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (p_186463_2_ - stacks.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)list.remove(MathHelper.func_76136_a((Random)rand, (int)0, (int)(list.size() - 1)));
            int i = MathHelper.func_76136_a((Random)rand, (int)1, (int)(itemstack2.func_190916_E() / 2));
            ItemStack itemstack1 = itemstack2.func_77979_a(i);
            if (itemstack2.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, rand);
    }

    private List<Integer> getEmptySlotsRandomized(IInventory inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    public void setVanillaImports(VanillaImport ... vanillaImports) {
        this.vanillaImports = vanillaImports;
    }

    public static void buildAll(LootTableManager manager) {
        if (BUILT) {
            return;
        }
        DungeonCrawl.LOGGER.info("Building loot tables");
        BUILT = true;
        for (TreasureLootTable lootTable : LOOT_TABLES) {
            DungeonCrawl.LOGGER.debug("Building {}", (Object)lootTable.name);
            lootTable.build(manager);
        }
    }

    public static class VanillaImport {
        String location;
        int weight;
        LootTable table;

        public VanillaImport(String location) {
            this(location, 1);
        }

        public VanillaImport(String location, int weight) {
            this.location = location;
            this.weight = weight;
        }

        public void build(LootTableManager manager) {
            this.table = manager.func_186521_a(new ResourceLocation(this.location));
        }

        public ItemStack generate(LootContext lootContext) {
            List stacks = this.table.func_216113_a(lootContext);
            if (stacks.isEmpty()) {
                return ItemStack.field_190927_a;
            }
            return (ItemStack)stacks.get(lootContext.func_216032_b().nextInt(stacks.size()));
        }
    }
}

