/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;

public class Dungeon
extends StructureFeature<NoneFeatureConfiguration> {
    public static Set<Biome.BiomeCategory> biomeCategories = ImmutableSet.builder().add((Object)Biome.BiomeCategory.DESERT).add((Object)Biome.BiomeCategory.EXTREME_HILLS).add((Object)Biome.BiomeCategory.FOREST).add((Object)Biome.BiomeCategory.ICY).add((Object)Biome.BiomeCategory.JUNGLE).add((Object)Biome.BiomeCategory.MESA).add((Object)Biome.BiomeCategory.PLAINS).add((Object)Biome.BiomeCategory.SAVANNA).add((Object)Biome.BiomeCategory.SWAMP).add((Object)Biome.BiomeCategory.TAIGA).build();
    public static ImmutableSet<String> whitelistedDimensions = ImmutableSet.of((Object)"minecraft:overworld");
    public static ImmutableSet<String> whitelistedBiomes = ImmutableSet.of();
    public static ImmutableSet<String> blacklistedBiomes = ImmutableSet.of();
    public static final String NAME = "dungeoncrawl:dungeon";
    public static final int SIZE = 15;

    public Dungeon() {
        super(NoneFeatureConfiguration.f_67815_, Dungeon::pieceGeneratorSupplier);
    }

    private static Optional<PieceGenerator<NoneFeatureConfiguration>> pieceGeneratorSupplier(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context) {
        int[] outerCornerHeights;
        int averageOuterGroundHeight;
        int centerX = context.f_197355_().m_151382_(7);
        int centerZ = context.f_197355_().m_151391_(7);
        int centerHeight = context.f_197352_().m_142647_(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        if (!context.f_197358_().test(context.f_197352_().m_7158_(QuartPos.m_175400_((int)centerX), QuartPos.m_175400_((int)centerHeight), QuartPos.m_175400_((int)centerZ)))) {
            DungeonCrawl.LOGGER.debug("Found invalid biome {}", (Object)context.f_197352_().m_7158_(QuartPos.m_175400_((int)centerX), QuartPos.m_175400_((int)centerHeight), QuartPos.m_175400_((int)centerZ)).getRegistryName());
            return Optional.empty();
        }
        int[] innerCornerHeights = context.m_197375_(centerX - 5, 10, centerZ - 5, 10);
        int averageInnerGroundHeight = (centerHeight + innerCornerHeights[0] + innerCornerHeights[1] + innerCornerHeights[2] + innerCornerHeights[3]) / 5;
        int averageGroundHeight = Math.min(averageInnerGroundHeight, averageOuterGroundHeight = ((outerCornerHeights = context.m_197375_(centerX - 20, 20, centerZ - 20, 20))[0] + outerCornerHeights[1] + outerCornerHeights[3] + outerCornerHeights[3]) / 4);
        if (averageGroundHeight < 45) {
            return Optional.empty();
        }
        return Optional.of((structurePiecesBuilder, generatorContext) -> {
            DungeonBuilder builder = new DungeonBuilder(context.f_197360_(), generatorContext.f_192703_(), averageGroundHeight - 16, new BlockPos(centerX, centerHeight, centerZ), generatorContext.f_192705_(), (Random)generatorContext.f_192708_());
            builder.build().forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
        });
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    protected boolean m_5910_() {
        return false;
    }

    public String m_67098_() {
        return NAME;
    }
}

