/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public record ScatteredDecoration(BlockStateProvider blockStateProvider, float chance) implements DungeonDecoration
{
    @Override
    public void decorate(DungeonModel model, LevelAccessor world, BlockPos pos, int width, int height, int length, BoundingBox worldGenBounds, BoundingBox structureBounds, DungeonPiece piece, int stage, boolean worldGen) {
        boolean ew = piece.f_73379_ == Rotation.NONE || piece.f_73379_ == Rotation.CLOCKWISE_180;
        int maxX = ew ? width : length;
        int maxZ = ew ? length : width;
        for (int x = 1; x < maxX - 1; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 1; z < maxZ - 1; ++z) {
                    boolean _up;
                    BlockPos currentPos = new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                    if (!worldGenBounds.m_71051_((Vec3i)currentPos) || !structureBounds.m_71051_((Vec3i)currentPos) || DungeonBuilder.isBlockProtected(world, currentPos) || !world.m_46859_(currentPos) || !(DungeonBlocks.RANDOM.nextFloat() < this.chance)) continue;
                    BlockPos north = new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z - 1);
                    BlockPos east = new BlockPos(north.m_123341_() + 1, north.m_123342_(), pos.m_123343_() + z);
                    BlockPos south = new BlockPos(north.m_123341_(), north.m_123342_(), east.m_123343_() + 1);
                    BlockPos west = new BlockPos(north.m_123341_() - 1, north.m_123342_(), east.m_123343_());
                    BlockPos up = new BlockPos(north.m_123341_(), north.m_123342_() + 1, east.m_123343_());
                    boolean _north = worldGenBounds.m_71051_((Vec3i)north) && structureBounds.m_71051_((Vec3i)north) && world.m_8055_(north).m_60815_();
                    boolean _east = worldGenBounds.m_71051_((Vec3i)east) && structureBounds.m_71051_((Vec3i)east) && world.m_8055_(east).m_60815_();
                    boolean _south = worldGenBounds.m_71051_((Vec3i)south) && structureBounds.m_71051_((Vec3i)south) && world.m_8055_(south).m_60815_();
                    boolean _west = worldGenBounds.m_71051_((Vec3i)west) && structureBounds.m_71051_((Vec3i)west) && world.m_8055_(west).m_60815_();
                    boolean bl = _up = worldGenBounds.m_71051_((Vec3i)up) && structureBounds.m_71051_((Vec3i)up) && world.m_8055_(up).m_60815_();
                    if (!_north && !_east && !_south && !_west && !_up) continue;
                    world.m_7731_(currentPos, this.blockStateProvider.get(world, currentPos), 2);
                }
            }
        }
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "scattered");
        object.addProperty("chance", (Number)Float.valueOf(this.chance));
        object.add("block", (JsonElement)this.blockStateProvider.serialize());
        return object;
    }
}

