/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public record VineDecoration(float chance) implements DungeonDecoration
{
    @Override
    public void decorate(DungeonModel model, LevelAccessor world, BlockPos pos, int width, int height, int length, BoundingBox worldGenBounds, BoundingBox structureBounds, DungeonPiece piece, int stage, boolean worldGen) {
        boolean ew = piece.f_73379_ == Rotation.NONE || piece.f_73379_ == Rotation.CLOCKWISE_180;
        int maxX = ew ? width : length;
        int maxZ = ew ? length : width;
        for (int x = 0; x < maxX; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < maxZ; ++z) {
                    boolean _up;
                    BlockPos currentPos = new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                    if (!worldGenBounds.m_71051_((Vec3i)currentPos) || !structureBounds.m_71051_((Vec3i)currentPos) || DungeonBuilder.isBlockProtected(world, currentPos) || !world.m_46859_(currentPos)) continue;
                    BlockPos north = new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z - 1);
                    BlockPos east = new BlockPos(north.m_123341_() + 1, north.m_123342_(), pos.m_123343_() + z);
                    BlockPos south = new BlockPos(north.m_123341_(), north.m_123342_(), east.m_123343_() + 1);
                    BlockPos west = new BlockPos(north.m_123341_() - 1, north.m_123342_(), east.m_123343_());
                    BlockPos up = new BlockPos(north.m_123341_(), north.m_123342_() + 1, east.m_123343_());
                    boolean _north = worldGenBounds.m_71051_((Vec3i)north) && structureBounds.m_71051_((Vec3i)north) && world.m_8055_(north).m_60796_((BlockGetter)world, north) && !world.m_46859_(north);
                    boolean _east = worldGenBounds.m_71051_((Vec3i)east) && structureBounds.m_71051_((Vec3i)east) && world.m_8055_(east).m_60796_((BlockGetter)world, east) && !world.m_46859_(east);
                    boolean _south = worldGenBounds.m_71051_((Vec3i)south) && structureBounds.m_71051_((Vec3i)south) && world.m_8055_(south).m_60796_((BlockGetter)world, south) && !world.m_46859_(south);
                    boolean _west = worldGenBounds.m_71051_((Vec3i)west) && structureBounds.m_71051_((Vec3i)west) && world.m_8055_(west).m_60796_((BlockGetter)world, east) && !world.m_46859_(west);
                    boolean bl = _up = worldGenBounds.m_71051_((Vec3i)up) && structureBounds.m_71051_((Vec3i)up) && world.m_8055_(up).m_60796_((BlockGetter)world, up) && !world.m_46859_(up);
                    if (!_north && !_east && !_south && !_west && !_up || !(DungeonBlocks.RANDOM.nextFloat() < this.chance)) continue;
                    BlockPos p = new BlockPos(north.m_123341_(), north.m_123342_(), east.m_123343_());
                    world.m_7731_(p, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(_north))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(_east))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(_south))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(_west))).m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(_up)), 2);
                }
            }
        }
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "vines");
        object.addProperty("chance", (Number)Float.valueOf(this.chance));
        return object;
    }
}

