/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.Tuple;
import xiroc.dungeoncrawl.dungeon.treasure.RandomItems;
import xiroc.dungeoncrawl.dungeon.treasure.TreasureItem;
import xiroc.dungeoncrawl.util.IRandom;

public class WeightedRandomTreasureItem
implements IRandom<TreasureItem> {
    private final WeightedEntry[] entries;

    private WeightedRandomTreasureItem(Tuple<String, Integer>[] entries) {
        int weight = 0;
        for (Tuple<String, Integer> entry : entries) {
            weight += ((Integer)entry.m_14419_()).intValue();
        }
        this.entries = new WeightedEntry[entries.length];
        this.assign(entries, weight);
    }

    private void assign(Tuple<String, Integer>[] entries, int totalWeight) {
        float f = 0.0f;
        int i = 0;
        for (Tuple<String, Integer> entry : entries) {
            float weight = (float)((Integer)entry.m_14419_()).intValue() / (float)totalWeight;
            this.entries[i] = new WeightedEntry(RandomItems.createEnchantedSpecialItem((String)entry.m_14418_()), Float.valueOf(weight + f));
            f += weight;
            ++i;
        }
    }

    @Override
    public TreasureItem roll(Random rand) {
        float f = rand.nextFloat();
        for (WeightedEntry entry : this.entries) {
            if (!(((Float)entry.m_14419_()).floatValue() >= f)) continue;
            return (TreasureItem)entry.m_14418_();
        }
        return null;
    }

    public static WeightedRandomTreasureItem fromJson(JsonArray array) {
        Builder builder = new Builder();
        array.forEach(element -> {
            JsonObject object = element.getAsJsonObject();
            int weight = object.has("weight") ? object.get("weight").getAsInt() : 1;
            builder.add(object.get("item").getAsString(), weight);
        });
        return builder.build();
    }

    private static class WeightedEntry
    extends Tuple<TreasureItem, Float> {
        public WeightedEntry(TreasureItem aIn, Float bIn) {
            super((Object)aIn, (Object)bIn);
        }
    }

    public static class Builder {
        private final ArrayList<Entry> list = new ArrayList();

        public Builder add(String item, int weight) {
            this.list.add(new Entry(item, weight));
            return this;
        }

        public WeightedRandomTreasureItem build() {
            return new WeightedRandomTreasureItem(this.list.toArray(new Entry[0]));
        }

        private static class Entry
        extends Tuple<String, Integer> {
            public Entry(String aIn, Integer bIn) {
                super((Object)aIn, (Object)bIn);
            }
        }
    }
}

