/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonFeatures;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.DungeonLayerType;
import xiroc.dungeoncrawl.dungeon.DungeonPieces;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModel;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelRegistry;
import xiroc.dungeoncrawl.dungeon.segment.RandomDungeonSegmentModel;
import xiroc.dungeoncrawl.util.Position2D;

public class DungeonBuilder {
    public Random rand;
    public Position2D start;
    public DungeonLayer[] layers;
    public BlockPos startPos;

    public DungeonBuilder(IWorld world, ChunkPos pos, Random rand) {
        this.rand = rand;
        this.start = new Position2D(rand.nextInt(16), rand.nextInt(16));
        this.startPos = new BlockPos(pos.field_77276_a * 16, world.func_72863_F().func_201711_g().func_205470_d() - 16, pos.field_77275_b * 16);
        this.layers = new DungeonLayer[this.startPos.func_177956_o() / 16];
        DungeonCrawl.LOGGER.info("DungeonBuilder starts at (" + this.startPos.func_177958_n() + " / " + this.startPos.func_177956_o() + " / " + this.startPos.func_177952_p() + "), " + this.layers.length + " layers");
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new DungeonLayer(DungeonLayerType.NORMAL);
            this.layers[i].buildMap(rand, i == 0 ? this.start : this.layers[i - 1].end, false);
        }
    }

    public DungeonBuilder(ChunkGenerator<?> world, ChunkPos pos, Random rand) {
        this.rand = rand;
        this.start = new Position2D(rand.nextInt(16), rand.nextInt(16));
        this.startPos = new BlockPos(pos.field_77276_a * 16, world.func_205470_d() - 16, pos.field_77275_b * 16);
        this.layers = new DungeonLayer[this.startPos.func_177956_o() / 16];
        DungeonCrawl.LOGGER.info("DungeonBuilder starts at (" + this.startPos.func_177958_n() + " / " + this.startPos.func_177956_o() + " / " + this.startPos.func_177952_p() + "), " + this.layers.length + " layers");
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new DungeonLayer(DungeonLayerType.NORMAL);
            this.layers[i].buildMap(rand, i == 0 ? this.start : this.layers[i - 1].end, i == this.layers.length - 1);
        }
    }

    public List<DungeonPieces.DungeonPiece> build() {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.layers.length; ++i) {
            this.buildLayer(this.layers[i], i, this.startPos);
            DungeonPieces.DungeonPiece stairs = i == 0 ? new DungeonPieces.EntranceBuilder(null, DungeonPieces.DEFAULT_NBT) : new DungeonPieces.Stairs(null, DungeonPieces.DEFAULT_NBT);
            stairs.setRealPosition(this.startPos.func_177958_n() + this.layers[i].start.x * 8, this.startPos.func_177956_o() + 8 - i * 16, this.startPos.func_177952_p() + this.layers[i].start.z * 8);
            stairs.stage = 0;
            list.add(stairs);
        }
        this.postProcessDungeon(list, this.rand);
        return list;
    }

    public void buildLayer(DungeonLayer layer, int lyr, BlockPos startPos) {
        int stage = lyr > 2 ? 2 : lyr;
        for (int x = 0; x < layer.width; ++x) {
            for (int z = 0; z < layer.length; ++z) {
                if (layer.segments[x][z] == null) continue;
                layer.segments[x][z].setRealPosition(startPos.func_177958_n() + x * 8, startPos.func_177956_o() - lyr * 16, startPos.func_177952_p() + z * 8);
                layer.segments[x][z].stage = stage;
            }
        }
    }

    public void postProcessDungeon(List<DungeonPieces.DungeonPiece> list, Random rand) {
        int lyrs = this.layers.length;
        for (int i = 0; i < this.layers.length; ++i) {
            int z;
            int x;
            int stage = i > 2 ? 2 : i;
            DungeonLayer layer = this.layers[i];
            for (x = 0; x < layer.width; ++x) {
                for (z = 0; z < layer.length; ++z) {
                    if (layer.segments[x][z] == null || layer.segments[x][z].getType() != 0) continue;
                    if ((i >= lyrs - 1 || this.layers[i + 1].segments[x][z] == null) && rand.nextDouble() < 0.02) {
                        DungeonPieces.Hole hole = new DungeonPieces.Hole(null, DungeonPieces.DEFAULT_NBT);
                        hole.sides = layer.segments[x][z].sides;
                        hole.connectedSides = layer.segments[x][z].connectedSides;
                        hole.setRealPosition(this.startPos.func_177958_n() + x * 8, this.startPos.func_177956_o() - i * 16, this.startPos.func_177952_p() + z * 8);
                        hole.stage = stage;
                        hole.lava = stage == 2;
                        layer.segments[x][z] = hole;
                        continue;
                    }
                    DungeonFeatures.processCorridor(layer, x, z, rand, i, stage, this.startPos);
                }
            }
            for (x = 0; x < layer.width; ++x) {
                for (z = 0; z < layer.length; ++z) {
                    if (layer.segments[x][z] == null) continue;
                    if (i == lyrs - 1) {
                        layer.segments[x][z].theme = 1;
                    }
                    list.add(layer.segments[x][z]);
                }
            }
        }
    }

    public static DungeonSegmentModel getModel(DungeonPieces.DungeonPiece piece, Random rand) {
        boolean north = piece.sides[0];
        boolean east = piece.sides[1];
        boolean south = piece.sides[2];
        boolean west = piece.sides[3];
        switch (piece.getType()) {
            case 0: {
                switch (piece.connectedSides) {
                    case 2: {
                        switch (((DungeonPieces.Corridor)piece).specialType) {
                            case 1: {
                                return DungeonSegmentModelRegistry.CORRIDOR_FIRE;
                            }
                            case 2: {
                                return DungeonSegmentModelRegistry.CORRIDOR_GRASS;
                            }
                        }
                        if (north && south || east && west) {
                            return RandomDungeonSegmentModel.CORRIDOR_STRAIGHT.roll(rand);
                        }
                        return RandomDungeonSegmentModel.CORRIDOR_TURN.roll(rand);
                    }
                    case 3: {
                        return RandomDungeonSegmentModel.CORRIDOR_OPEN.roll(rand);
                    }
                    case 4: {
                        return RandomDungeonSegmentModel.CORRIDOR_ALL_OPEN.roll(rand);
                    }
                }
                return null;
            }
            case 1: {
                return DungeonSegmentModelRegistry.STAIRS_BOTTOM;
            }
            case 2: {
                return DungeonSegmentModelRegistry.STAIRS;
            }
            case 3: {
                return DungeonSegmentModelRegistry.STAIRS_TOP;
            }
            case 5: {
                return DungeonSegmentModelRegistry.ROOM;
            }
        }
        return null;
    }
}

