/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.RandomValueRange;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.treasure.TreasureEntry;

public class TreasureLootTable {
    public String name;
    public RandomValueRange rolls;
    public float minRolls;
    public float maxRolls;
    public ArrayList<TreasureEntry> entries;
    public Integer totalWeight;

    public TreasureLootTable(String name, RandomValueRange rolls, TreasureEntry ... entries) {
        this.name = name;
        if (rolls != null) {
            this.minRolls = rolls.func_186509_a();
            this.maxRolls = rolls.func_186512_b();
        }
        this.entries = new ArrayList();
        for (TreasureEntry entry : entries) {
            this.entries.add(entry);
        }
    }

    public void build() {
        this.totalWeight = 0;
        for (TreasureEntry entry : this.entries) {
            entry.readResourceLocation();
            this.totalWeight = this.totalWeight + entry.weight;
        }
        this.rolls = new RandomValueRange(this.minRolls, this.maxRolls);
    }

    private List<ItemStack> roll(Random rand, int theme, int lootLevel) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.rolls.func_186511_a(rand); ++i) {
            list.add(this.getItemStack(rand, theme, lootLevel));
        }
        return list;
    }

    public ItemStack getItemStack(Random rand, int theme, int lootLevel) {
        int item = rand.nextInt(this.totalWeight);
        int k = 0;
        for (TreasureEntry entry : this.entries) {
            if (k + entry.weight > item) {
                return entry.generate(rand, theme, lootLevel);
            }
            k += entry.weight;
        }
        DungeonCrawl.LOGGER.error("Could not find an item with weight {} in {}. Maximum weight is {}.", (Object)item, (Object)this.name, (Object)this.totalWeight);
        return ItemStack.field_190927_a;
    }

    public void fillInventory(IInventory inventory, Random rand, int theme, int lootLevel) {
        List<ItemStack> list = this.roll(rand, theme, lootLevel);
        List<Integer> slots = this.getEmptySlotsRandomized(inventory, rand);
        this.shuffleItems(list, slots.size(), rand);
        for (ItemStack itemStack : list) {
            if (slots.isEmpty()) {
                DungeonCrawl.LOGGER.warn("Tried to over-fill a container");
                return;
            }
            if (itemStack.func_190926_b()) {
                inventory.func_70299_a(slots.remove(slots.size() - 1).intValue(), ItemStack.field_190927_a);
                continue;
            }
            inventory.func_70299_a(slots.remove(slots.size() - 1).intValue(), itemStack);
        }
    }

    private void shuffleItems(List<ItemStack> stacks, int p_186463_2_, Random rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.func_190926_b()) {
                iterator.remove();
                continue;
            }
            if (itemstack.func_190916_E() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (p_186463_2_ - stacks.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)list.remove(MathHelper.func_76136_a((Random)rand, (int)0, (int)(list.size() - 1)));
            int i = MathHelper.func_76136_a((Random)rand, (int)1, (int)(itemstack2.func_190916_E() / 2));
            ItemStack itemstack1 = itemstack2.func_77979_a(i);
            if (itemstack2.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, rand);
    }

    private List<Integer> getEmptySlotsRandomized(IInventory inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }
}

