/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import java.util.HashMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.util.IBlockStateProvider;

public class Theme {
    public static HashMap<String, Integer> BIOME_TO_THEME_MAP;
    public static HashMap<Integer, Theme> ID_TO_THEME_MAP;
    public static final Theme TEST;
    public static final Theme DEFAULT;
    public static final Theme NETHER;
    public static final Theme SWAMP;
    public static final Theme OCEAN;
    public static final Theme FROZEN_OCEAN;
    public static final Theme JUNGLE;
    public static final Theme BIRCH_FOREST;
    public static final Theme SAVANNA;
    public static final Theme OAK_FOREST;
    public static final Theme DARK_OAK_FOREST;
    public static final Theme TAIGA;
    public static final Theme DESERT;
    public static final Theme BADLANDS;
    public static final Theme ICE;
    public static final BuildTheme BUILD_STONE;
    public static final BuildTheme BUILD_BRICKS;
    public final IBlockStateProvider ceiling;
    public final IBlockStateProvider wall;
    public final IBlockStateProvider wallLog;
    public final IBlockStateProvider floor;
    public final IBlockStateProvider stairs;
    public final IBlockStateProvider ceilingStairs;
    public final IBlockStateProvider floorStairs;
    public final IBlockStateProvider trapDoorDecoration;
    public final IBlockStateProvider torchDark;
    public final IBlockStateProvider door;
    public final IBlockStateProvider material;
    public final IBlockStateProvider column;

    public Theme(IBlockStateProvider ceiling, IBlockStateProvider wall, IBlockStateProvider floor, IBlockStateProvider stairs, IBlockStateProvider ceilingStairs, IBlockStateProvider floorStairs, IBlockStateProvider wallLog, IBlockStateProvider trapDoorDecoration, IBlockStateProvider torchDark, IBlockStateProvider door, IBlockStateProvider material, IBlockStateProvider column) {
        this.ceiling = ceiling;
        this.wall = wall;
        this.wallLog = wallLog;
        this.floor = floor;
        this.stairs = stairs;
        this.ceilingStairs = ceilingStairs;
        this.floorStairs = floorStairs;
        this.trapDoorDecoration = trapDoorDecoration;
        this.torchDark = torchDark;
        this.door = door;
        this.material = material;
        this.column = column;
    }

    public Theme(BlockState ceiling, BlockState wall, BlockState floor, BlockState stairs, BlockState ceilingStairs, BlockState floorStairs, BlockState wallLog, BlockState trapDoorDecoration, BlockState torchDark, BlockState door, BlockState material, BlockState column) {
        this.ceiling = () -> ceiling;
        this.wall = () -> wall;
        this.wallLog = () -> wallLog;
        this.floor = () -> floor;
        this.stairs = () -> stairs;
        this.ceilingStairs = () -> ceilingStairs;
        this.floorStairs = () -> floorStairs;
        this.trapDoorDecoration = () -> trapDoorDecoration;
        this.torchDark = () -> torchDark;
        this.door = () -> door;
        this.material = () -> material;
        this.column = () -> column;
    }

    public static Theme get(int theme) {
        return ID_TO_THEME_MAP.getOrDefault(theme, DEFAULT);
    }

    static {
        TEST = new Theme(() -> BlockRegistry.STONE_BRICKS, () -> BlockRegistry.STONE_BRICKS, () -> BlockRegistry.GRAVEL, () -> Blocks.field_150476_ad.func_176223_P(), () -> BlockRegistry.STAIRS_STONE_BRICKS, () -> Blocks.field_150476_ad.func_176223_P(), () -> BlockRegistry.OAK_LOG, () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196662_n.func_176223_P(), null);
        DEFAULT = new Theme(() -> BlockRegistry.STONE_BRICKS, BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150476_ad.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150476_ad.func_176223_P(), () -> BlockRegistry.OAK_LOG, () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196662_n.func_176223_P(), null);
        NETHER = new Theme(() -> BlockRegistry.STONE_BRICKS, BlockRegistry.NETHERRACK_NETHERBRICK, BlockRegistry.NETHERRACK_NETHERBRICK_SOULSAND, BlockRegistry.NETHER_BRICK_STAIRS, BlockRegistry.NETHER_BRICK_STAIRS, BlockRegistry.NETHER_BRICK_STAIRS, () -> Blocks.field_196770_fj.func_176223_P(), () -> Blocks.field_180400_cw.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_150454_av.func_176223_P(), () -> Blocks.field_150424_aL.func_176223_P(), () -> Blocks.field_196653_dH.func_176223_P());
        SWAMP = new Theme(() -> BlockRegistry.STONE_BRICKS, BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150476_ad.func_176223_P(), () -> Blocks.field_150476_ad.func_176223_P(), () -> Blocks.field_150476_ad.func_176223_P(), () -> Blocks.field_196617_K.func_176223_P(), () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196662_n.func_176223_P(), null);
        FROZEN_OCEAN = OCEAN = new Theme(Blocks.field_180397_cI.func_176223_P(), Blocks.field_196779_gQ.func_176223_P(), Blocks.field_196781_gR.func_176223_P(), Blocks.field_203212_hg.func_176223_P(), Blocks.field_203211_hf.func_176223_P(), Blocks.field_203211_hf.func_176223_P(), Blocks.field_196781_gR.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), Blocks.field_180411_ar.func_176223_P(), Blocks.field_180397_cI.func_176223_P(), Blocks.field_196781_gR.func_176223_P());
        JUNGLE = new Theme(() -> Blocks.field_196696_di.func_176223_P(), BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150481_bH.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150481_bH.func_176223_P(), () -> Blocks.field_196620_N.func_176223_P(), () -> Blocks.field_196644_cZ.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180411_ar.func_176223_P(), () -> Blocks.field_196668_q.func_176223_P(), () -> Blocks.field_196620_N.func_176223_P());
        BIRCH_FOREST = new Theme(() -> Blocks.field_196696_di.func_176223_P(), BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150487_bG.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150487_bG.func_176223_P(), () -> Blocks.field_196619_M.func_176223_P(), () -> Blocks.field_196641_cY.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180412_aq.func_176223_P(), () -> Blocks.field_196666_p.func_176223_P(), null);
        SAVANNA = new Theme(() -> Blocks.field_196696_di.func_176223_P(), BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150400_ck.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150400_ck.func_176223_P(), () -> Blocks.field_196621_O.func_176223_P(), () -> Blocks.field_196682_da.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180410_as.func_176223_P(), () -> Blocks.field_196670_r.func_176223_P(), null);
        OAK_FOREST = new Theme(() -> Blocks.field_196696_di.func_176223_P(), BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150476_ad.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150476_ad.func_176223_P(), () -> Blocks.field_196617_K.func_176223_P(), () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196662_n.func_176223_P(), null);
        DARK_OAK_FOREST = new Theme(() -> Blocks.field_196696_di.func_176223_P(), BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150401_cl.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150401_cl.func_176223_P(), () -> Blocks.field_196623_P.func_176223_P(), () -> Blocks.field_196684_db.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180409_at.func_176223_P(), () -> Blocks.field_196672_s.func_176223_P(), null);
        TAIGA = new Theme(() -> Blocks.field_196696_di.func_176223_P(), BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150485_bF.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150485_bF.func_176223_P(), () -> Blocks.field_196618_L.func_176223_P(), () -> Blocks.field_196638_cX.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180414_ap.func_176223_P(), () -> Blocks.field_196664_o.func_176223_P(), null);
        DESERT = new Theme(BlockRegistry.SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.SANDSTONE_DEFAULT_SMOOTH_SAND, BlockRegistry.STAIRS_SANDSTONE_DEFAULT_SMOOTH, BlockRegistry.STAIRS_SANDSTONE_DEFAULT_SMOOTH, BlockRegistry.STAIRS_SANDSTONE_DEFAULT_SMOOTH, () -> Blocks.field_196583_aj.func_176223_P(), () -> Blocks.field_201941_jj.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), BlockRegistry.SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.SANDSTONE_DEFAULT_CHSELED_SMOOTH);
        BADLANDS = new Theme(BlockRegistry.RED_SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.RED_SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.RED_SANDSTONE_DEFAULT_SMOOTH_RED_SAND, BlockRegistry.STAIRS_RED_SANDSTONE_DEFAULT_SMOOTH, BlockRegistry.STAIRS_RED_SANDSTONE_DEFAULT_SMOOTH, BlockRegistry.STAIRS_RED_SANDSTONE_DEFAULT_SMOOTH, () -> Blocks.field_196798_hA.func_176223_P(), () -> Blocks.field_201941_jj.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), BlockRegistry.RED_SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.RED_SANDSTONE_DEFAULT_CHSELED_SMOOTH);
        ICE = new Theme(BlockRegistry.ICE_DEFAULT_PACKED, BlockRegistry.ICE_DEFAULT_PACKED, () -> Blocks.field_150432_aD.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, BlockRegistry.ICE_DEFAULT_PACKED, BlockRegistry.ICE_DEFAULT_PACKED, () -> Blocks.field_150403_cj.func_176223_P(), () -> Blocks.field_201941_jj.func_176223_P(), () -> Blocks.field_201941_jj.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), BlockRegistry.ICE_DEFAULT_PACKED, BlockRegistry.ICE_DEFAULT_PACKED);
        BUILD_STONE = new BuildTheme(BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, BlockRegistry.STAIRS_STONE_COBBLESTONE);
        BUILD_BRICKS = new BuildTheme(() -> Blocks.field_222459_lw.func_176223_P(), () -> Blocks.field_222459_lw.func_176223_P(), () -> Blocks.field_196584_bK.func_176223_P(), () -> Blocks.field_150389_bf.func_176223_P());
        BIOME_TO_THEME_MAP = new HashMap();
        BIOME_TO_THEME_MAP.put("minecraft:swamp", 2);
        BIOME_TO_THEME_MAP.put("minecraft:swamp_hills", 2);
        BIOME_TO_THEME_MAP.put("minecraft:ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:deep_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:cold_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:deep_cold_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:lukewarm_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:deep_lukewarm_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:warm_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:deep_warm_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:frozen_ocean", 4);
        BIOME_TO_THEME_MAP.put("mineraft:deep_frozen_ocean", 4);
        BIOME_TO_THEME_MAP.put("minecraft:jungle", 5);
        BIOME_TO_THEME_MAP.put("minecraft:jungle_edge", 5);
        BIOME_TO_THEME_MAP.put("minecraft:jungle_hills", 5);
        BIOME_TO_THEME_MAP.put("minecraft:modified_jungle", 5);
        BIOME_TO_THEME_MAP.put("minecraft:modified_jungle_edge", 5);
        BIOME_TO_THEME_MAP.put("minecraft:bamboo_jungle", 5);
        BIOME_TO_THEME_MAP.put("minecraft:bamboo_jungle_hills", 5);
        BIOME_TO_THEME_MAP.put("minecraft:birch_forest", 6);
        BIOME_TO_THEME_MAP.put("minecraft:birch_forest_hills", 6);
        BIOME_TO_THEME_MAP.put("minecraft:tall_birch_forest", 6);
        BIOME_TO_THEME_MAP.put("minecraft:tall_birch_hills", 6);
        BIOME_TO_THEME_MAP.put("minecraft:flower_forest", 6);
        BIOME_TO_THEME_MAP.put("minecraft:savanna", 7);
        BIOME_TO_THEME_MAP.put("minecraft:savanna_plateau", 7);
        BIOME_TO_THEME_MAP.put("minecraft:shattered_savanna", 7);
        BIOME_TO_THEME_MAP.put("minecraft:shattered_savanna_plateau", 7);
        BIOME_TO_THEME_MAP.put("minecraft:dark_forest", 9);
        BIOME_TO_THEME_MAP.put("minecraft:dark_forest_hills", 9);
        BIOME_TO_THEME_MAP.put("minecraft:taiga", 10);
        BIOME_TO_THEME_MAP.put("minecraft:snowy_tundra", 10);
        BIOME_TO_THEME_MAP.put("minecraft:taiga_hills", 10);
        BIOME_TO_THEME_MAP.put("minecraft:snowy_taiga", 10);
        BIOME_TO_THEME_MAP.put("minecraft:snowy_taga_hills", 10);
        BIOME_TO_THEME_MAP.put("minecraft:giant_tree_taiga", 10);
        BIOME_TO_THEME_MAP.put("minecraft:giant_tree_taiga_hills", 10);
        BIOME_TO_THEME_MAP.put("minecraft:taiga_mountains", 10);
        BIOME_TO_THEME_MAP.put("minecraft:snowy_taiga_mountains", 10);
        BIOME_TO_THEME_MAP.put("minecraft:giant_spruce_taiga", 10);
        BIOME_TO_THEME_MAP.put("minecraft:giant_spruce_taiga_hills", 10);
        BIOME_TO_THEME_MAP.put("minecraft:desert", 16);
        BIOME_TO_THEME_MAP.put("minecraft:desert_hills", 16);
        BIOME_TO_THEME_MAP.put("minecraft:desert_lakes", 16);
        BIOME_TO_THEME_MAP.put("minecraft:badlands", 17);
        BIOME_TO_THEME_MAP.put("minecraft:wooded_badlands_plateau", 17);
        BIOME_TO_THEME_MAP.put("minecraft:badlands_plateau", 17);
        BIOME_TO_THEME_MAP.put("minecraft:eroded_badlands", 17);
        BIOME_TO_THEME_MAP.put("minecraft:modified_wooded_badlands_plateau", 17);
        BIOME_TO_THEME_MAP.put("minecraft:modified_badlands_plateau", 17);
        BIOME_TO_THEME_MAP.put("minecraft:ice_spikes", 32);
        ID_TO_THEME_MAP = new HashMap();
        ID_TO_THEME_MAP.put(-1, TEST);
        ID_TO_THEME_MAP.put(0, DEFAULT);
        ID_TO_THEME_MAP.put(1, NETHER);
        ID_TO_THEME_MAP.put(2, SWAMP);
        ID_TO_THEME_MAP.put(3, OCEAN);
        ID_TO_THEME_MAP.put(4, OCEAN);
        ID_TO_THEME_MAP.put(5, JUNGLE);
        ID_TO_THEME_MAP.put(6, BIRCH_FOREST);
        ID_TO_THEME_MAP.put(7, SAVANNA);
        ID_TO_THEME_MAP.put(8, OAK_FOREST);
        ID_TO_THEME_MAP.put(9, DARK_OAK_FOREST);
        ID_TO_THEME_MAP.put(10, TAIGA);
        ID_TO_THEME_MAP.put(16, DESERT);
        ID_TO_THEME_MAP.put(17, BADLANDS);
        ID_TO_THEME_MAP.put(32, ICE);
    }

    public static class BuildTheme {
        public IBlockStateProvider ceiling;
        public IBlockStateProvider wall;
        public IBlockStateProvider floor;
        public IBlockStateProvider ceilingStairs;

        public BuildTheme(IBlockStateProvider ceiling, IBlockStateProvider wall, IBlockStateProvider floor, IBlockStateProvider ceilingStairs) {
            this.ceiling = ceiling;
            this.wall = wall;
            this.floor = floor;
            this.ceilingStairs = ceilingStairs;
        }
    }

    public static class BiomeTheme {
        public IBlockStateProvider wallLog;
        public IBlockStateProvider stairs;
        public IBlockStateProvider floorStairs;
        public IBlockStateProvider trapDoorDecoration;
        public IBlockStateProvider torchDark;
        public IBlockStateProvider door;
        public IBlockStateProvider material;
        public IBlockStateProvider column;

        public BiomeTheme(IBlockStateProvider wallLog, IBlockStateProvider stairs, IBlockStateProvider floorStairs, IBlockStateProvider trapDoor, IBlockStateProvider torchDark, IBlockStateProvider door, IBlockStateProvider material, IBlockStateProvider column) {
            this.wallLog = wallLog;
            this.stairs = stairs;
            this.floorStairs = floorStairs;
            this.trapDoorDecoration = trapDoor;
            this.torchDark = torchDark;
            this.door = door;
            this.material = material;
            this.column = column;
        }
    }
}

