/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModel;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlock;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlockType;

public class DungeonSegmentModelReader {
    public static void readModelToFile(World world, BlockPos pos, int width, int height, int length) {
        DungeonSegmentModelBlock[][][] model = new DungeonSegmentModelBlock[width][height][length];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    BlockState state = world.func_180495_p(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z));
                    model[x][y][z] = state.func_177230_c() == Blocks.field_150350_a ? null : new DungeonSegmentModelBlock(DungeonSegmentModelBlockType.get(state.func_177230_c())).set(state);
                }
            }
        }
        DungeonSegmentModelReader.writeModelToFile(new DungeonSegmentModel(model), new File(((ServerWorld)world).func_217485_w().func_75765_b(), "model_" + System.currentTimeMillis() + ".json"));
    }

    public static void writeModelToFile(DungeonSegmentModel model, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            DungeonCrawl.GSON.toJson((Object)model, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DungeonSegmentModel readModelFromFile(File file) {
        DungeonCrawl.LOGGER.info("Loading model from file " + file.getAbsolutePath());
        try {
            FileReader reader = new FileReader(file);
            return (DungeonSegmentModel)DungeonCrawl.GSON.fromJson((Reader)reader, DungeonSegmentModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DungeonSegmentModel readModelFromInputStream(InputStream input) {
        try {
            InputStreamReader reader = new InputStreamReader(input);
            return (DungeonSegmentModel)DungeonCrawl.GSON.fromJson((Reader)reader, DungeonSegmentModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

