/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl;

import com.google.gson.JsonParser;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.util.ResourceReloadHandler;
import xiroc.dungeoncrawl.util.tools.Tools;

@Mod(value="dungeoncrawl")
public class DungeonCrawl {
    public static final String MOD_ID = "dungeoncrawl";
    public static final String NAME = "Dungeon Crawl";
    public static final String VERSION = "2.3.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"Dungeon Crawl");
    public static final JsonParser JSON_PARSER = new JsonParser();

    public DungeonCrawl() {
        LOGGER.info("Here we go! Launching Dungeon Crawl {}...", (Object)VERSION);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addGenericListener(StructureFeature.class, this::onRegisterStructures);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(this::onAddReloadListener);
        forgeEventBus.addListener(this::onWorldLoad);
        forgeEventBus.addListener(EventPriority.HIGH, this::onBiomeLoad);
        Treasure.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup");
        Config.load(FMLPaths.CONFIGDIR.get().resolve("dungeon_crawl.toml"));
        if ((Integer)Config.SPACING.get() <= (Integer)Config.SEPARATION.get()) {
            throw new IllegalArgumentException("Invalid spacing/separation setting in the config.");
        }
        StructurePieceTypes.register();
        if (((Boolean)Config.ENABLE_TOOLS.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)new Tools());
        }
    }

    private void onRegisterStructures(RegistryEvent.Register<StructureFeature<?>> event) {
        Dungeon.register();
    }

    private void onBiomeLoad(BiomeLoadingEvent event) {
        if (Dungeon.ALLOWED_CATEGORIES.contains(event.getCategory())) {
            LOGGER.debug("Generation Biome: {}", (Object)event.getName());
            event.getGeneration().m_47849_(Dungeon.CONFIGURED_DUNGEON);
        }
    }

    private void onWorldLoad(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)levelAccessor;
            if (serverWorld.m_7726_().m_8481_() instanceof FlatLevelSource && serverWorld.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            HashMap<StructureFeature<NoneFeatureConfiguration>, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature<NoneFeatureConfiguration>, StructureFeatureConfiguration>(serverWorld.m_7726_().f_8328_.m_62205_().m_64590_());
            tempMap.putIfAbsent(Dungeon.DUNGEON, (StructureFeatureConfiguration)StructureSettings.f_64580_.get(Dungeon.DUNGEON));
            serverWorld.m_7726_().f_8328_.m_62205_().f_64582_ = tempMap;
        } else {
            LOGGER.info("Skipping world {}", event.getWorld().getClass());
        }
    }

    private void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ResourceReloadHandler());
    }

    public static ResourceLocation locate(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation key(ResourceLocation resourceLocation, String baseDirectory, String fileEnding) {
        String path = resourceLocation.m_135815_();
        return new ResourceLocation(resourceLocation.m_135827_(), path.substring(baseDirectory.length() + 1, path.length() - fileEnding.length()));
    }
}

