/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final String GENERAL = "general";
    public static final String DUNGEON = "dungeon";
    public static final String WORLD_GENERATION = "world generation";
    public static final String DUNGEON_PLACEMENT = "dungeon placement";
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    public static final ForgeConfigSpec.IntValue SPAWNER_ENTITIES;
    public static final ForgeConfigSpec.IntValue SPAWNER_RANGE;
    public static final ForgeConfigSpec.IntValue SPACING;
    public static final ForgeConfigSpec.IntValue SEPARATION;
    public static final ForgeConfigSpec.BooleanValue CUSTOM_SPAWNERS;
    public static final ForgeConfigSpec.BooleanValue NO_NETHER_STUFF;
    public static final ForgeConfigSpec.BooleanValue ENABLE_TOOLS;
    public static final ForgeConfigSpec.BooleanValue SOLID;
    public static final ForgeConfigSpec.BooleanValue NATURAL_DESPAWN;
    public static final ForgeConfigSpec.BooleanValue EXTENDED_DEBUG;
    public static final ForgeConfigSpec.BooleanValue TICK_FALLING_BLOCKS;
    public static final ForgeConfigSpec.BooleanValue OVERWRITE_ENTITY_LOOT_TABLES;
    public static final ForgeConfigSpec.BooleanValue SECRET_ROOMS;

    public static void load(Path path) {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        config.load();
        CONFIG.setConfig((CommentedConfig)config);
    }

    static {
        BUILDER.comment("General Settings").push(GENERAL);
        ENABLE_TOOLS = BUILDER.comment("Enables the dungeon crawl developer tools.").define("enable_tools", false);
        EXTENDED_DEBUG = BUILDER.comment("Enables extended debug logging to help detecting potential errors. This is enabled by default.").define("extended_debug", true);
        BUILDER.pop();
        BUILDER.comment("World Generation Settings").push(WORLD_GENERATION);
        SOLID = BUILDER.comment("Makes the entire dungeon solid, preventing caves, ravines, etc... from interfering with the dungeon.").define("solid", false);
        TICK_FALLING_BLOCKS = BUILDER.comment("Whether falling blocks like sand or gravel should drop down after being placed during dungeon generation.").define("tick_falling_blocks", true);
        BUILDER.pop();
        BUILDER.comment("Dungeon Placement Settings").push(DUNGEON_PLACEMENT);
        SPACING = BUILDER.comment("The average distance between the dungeons in chunks. This has to be higher than the separation!").defineInRange("spacing", 24, 8, 8192);
        SEPARATION = BUILDER.comment("The minimum distance between the dungeons in chunks. This has to be lower than the spacing!").defineInRange("separation", 12, 8, 8192);
        BUILDER.pop();
        BUILDER.comment("Dungeon Settings").push(DUNGEON);
        SECRET_ROOMS = BUILDER.comment("Whether the dungeons should have secret rooms or not.").define("secret_rooms", true);
        OVERWRITE_ENTITY_LOOT_TABLES = BUILDER.comment("Whether loot tables of certain spawner entities should be overwritten. If this enabled, wither skeletons from dungeon spawners will never drop skulls. Changing this will not affect already generated dungeons.").define("overwrite_entity_loot_tables", true);
        NO_NETHER_STUFF = BUILDER.comment("When enabled, the hell stage will be built with blocks from the overworld, not from the nether.").define("no_nether_stuff", false);
        SPAWNER_RANGE = BUILDER.comment("The activation range for the spawners in the dungeons").defineInRange("spawner_activation_range", 12, 1, 64);
        SPAWNER_ENTITIES = BUILDER.comment("The number of different entities per spawner. Increasing the number increases the diversity of the monster equipment.").defineInRange("spawner_entities", 6, 1, 128);
        CUSTOM_SPAWNERS = BUILDER.comment("Whether custom mob spawners with equipment, etc.. should be used.").define("custom_spawners", true);
        NATURAL_DESPAWN = BUILDER.comment("Whether mobs from spawners should despawn naturally or not.").define("natural_despawn", true);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

