/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.generator.layer;

import java.util.List;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Rotation;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.Tile;
import xiroc.dungeoncrawl.dungeon.generator.layer.LayerGeneratorSettings;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonCorridor;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonNodeRoom;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonSideRoom;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.Position2D;

public abstract class LayerGenerator {
    public LayerGeneratorSettings settings;

    public static void createNodeRoom(Position2D center, DungeonLayer dungeonLayer) {
        LayerGenerator.placeNodeRoom(new DungeonNodeRoom(), center, dungeonLayer);
    }

    public static void placeNodeRoom(DungeonNodeRoom nodeRoom, Position2D center, DungeonLayer dungeonLayer) {
        nodeRoom.setGridPosition(center.x, center.z);
        Tile placeHolder = new Tile(nodeRoom).addFlag(Tile.Flag.PLACEHOLDER);
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 && z == 0 || !Position2D.isValid(center.x + x, center.z + z, dungeonLayer.width, dungeonLayer.length)) continue;
                dungeonLayer.grid[center.x + x][center.z + z] = placeHolder;
            }
        }
        dungeonLayer.grid[center.x][center.z] = new Tile(nodeRoom);
    }

    public static DungeonCorridor createCorridor(DungeonLayer dungeonLayer, int x, int z, Direction from, Direction to) {
        DungeonCorridor corridor = new DungeonCorridor();
        corridor.setGridPosition(x, z);
        corridor.openSide(from);
        corridor.openSide(to);
        corridor.setRotation(Orientation.getRotationFromFacing(from));
        dungeonLayer.grid[corridor.gridPosition.x][corridor.gridPosition.z] = new Tile(corridor);
        return corridor;
    }

    public static void tryCreateSecretRoom(DungeonLayer dungeonLayer, List<DungeonCorridor> corridors, int maxAttempts, Random random) {
        if (!corridors.isEmpty()) {
            DungeonCorridor corridor;
            for (int i = 0; !(i >= maxAttempts || (corridor = corridors.get(random.nextInt(corridors.size()))).isStraight() && corridor.connectedSides == 2 && dungeonLayer.placeSecretRoom(corridor, corridor.gridPosition, random)); ++i) {
                corridors.remove((Object)corridor);
            }
        }
    }

    public static void createStarterRoom(DungeonLayer dungeonLayer, Random rand, int layer) {
        Tuple<Position2D, Rotation> sideRoomData = dungeonLayer.findStarterRoomData(dungeonLayer.start, rand);
        if (sideRoomData != null) {
            DungeonSideRoom room = new DungeonSideRoom();
            Direction dir = ((Rotation)sideRoomData.m_14419_()).m_55954_(Direction.WEST);
            room.openSide(dir);
            room.setGridPosition(((Position2D)sideRoomData.m_14418_()).x, ((Position2D)sideRoomData.m_14418_()).z);
            room.setRotation((Rotation)sideRoomData.m_14419_());
            room.model = DungeonModels.KEY_TO_MODEL.get(DungeonModels.STARTER_ROOM);
            room.stage = layer;
            dungeonLayer.map.markPositionAsOccupied((Position2D)sideRoomData.m_14418_());
            dungeonLayer.grid[((Position2D)sideRoomData.m_14418_()).x][((Position2D)sideRoomData.m_14418_()).z] = new Tile(room).addFlag(Tile.Flag.FIXED_MODEL);
            Position2D connectedSegment = ((Position2D)sideRoomData.m_14418_()).shift(dir, 1);
            if (dungeonLayer.grid[connectedSegment.x][connectedSegment.z] != null) {
                dungeonLayer.grid[connectedSegment.x][connectedSegment.z].piece.openSide(dir.m_122424_());
                dungeonLayer.rotatePiece(dungeonLayer.grid[connectedSegment.x][connectedSegment.z], rand);
            }
        }
    }

    public void initializeLayer(LayerGeneratorSettings settings, DungeonBuilder dungeonBuilder, Random rand, int layer, boolean isLastLayer) {
        this.settings = settings;
    }

    public abstract void generateLayer(DungeonBuilder var1, DungeonLayer var2, int var3, Random var4, Position2D var5);

    public void enableSecretRoom() {
    }
}

