/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelFeature;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.MultipartModelData;
import xiroc.dungeoncrawl.util.JSONUtils;

public class DungeonModel {
    public static final DungeonModel EMPTY = new DungeonModel(DungeonCrawl.locate("empty"), (ImmutableList<DungeonModelBlock>)ImmutableList.of(), 0, 0, 0);
    private final ResourceLocation key;
    public final int width;
    public final int height;
    public final int length;
    public final ImmutableList<DungeonModelBlock> blocks;
    @Nullable
    private Integer id;
    @Nullable
    private List<MultipartModelData> multipartData;
    private int entranceType;
    private Vec3i offset;
    private Vec3i rotatedOffset;
    @Nullable
    private DungeonModelFeature[] features;
    @Nullable
    private ResourceLocation lootTable;
    private boolean hasId = false;
    private boolean hasFeatures = false;
    private boolean hasMultipart = false;
    private boolean variation = false;

    public DungeonModel(ResourceLocation key, ImmutableList<DungeonModelBlock> blocks, int width, int height, int length) {
        this.key = key;
        this.blocks = blocks;
        this.width = width;
        this.height = height;
        this.length = length;
        this.offset = DungeonModels.NO_OFFSET;
        this.rotatedOffset = DungeonModels.NO_OFFSET;
    }

    public List<DungeonModelBlock> getBlocks() {
        return this.blocks;
    }

    public void loadMetadata(JsonObject object, ResourceLocation file) throws JsonParseException {
        List<MultipartModelData> multipartData;
        if (object.has("id")) {
            this.id = object.get("id").getAsInt();
            this.hasId = true;
        }
        if (object.has("offset")) {
            JsonObject offset = object.getAsJsonObject("offset");
            this.offset = JSONUtils.getOffset(offset);
            this.rotatedOffset = offset.has("rotate") && offset.get("rotate").getAsBoolean() ? new Vec3i(this.offset.m_123343_(), this.offset.m_123342_(), this.offset.m_123341_()) : this.offset;
        }
        if (object.has("entrance_type") && object.get("entrance_type").getAsString().equals("secondary")) {
            this.entranceType = 1;
        }
        if (object.has("features")) {
            JsonArray array = object.getAsJsonArray("features");
            this.features = new DungeonModelFeature[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                this.features[i] = DungeonModelFeature.fromJson(array.get(i).getAsJsonObject(), file);
            }
            this.hasFeatures = true;
        }
        if (object.has("variation")) {
            this.variation = object.get("variation").getAsBoolean();
        }
        if (object.has("loot")) {
            this.lootTable = new ResourceLocation(object.get("loot").getAsString());
        }
        if (object.has("multipart") && (multipartData = DungeonModel.parseMultipartData(object.getAsJsonObject("multipart"), file)) != null) {
            this.multipartData = multipartData;
            this.hasMultipart = true;
        }
    }

    @Nullable
    public static List<MultipartModelData> parseMultipartData(JsonObject multipartData, ResourceLocation file) {
        if (multipartData.size() > 0) {
            ArrayList<MultipartModelData> list = new ArrayList<MultipartModelData>();
            multipartData.entrySet().forEach(entry -> {
                MultipartModelData multipartModelData = MultipartModelData.fromJson((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject(), file);
                if (multipartModelData != null) {
                    list.add(multipartModelData);
                }
            });
            return list;
        }
        return null;
    }

    public DungeonModel setId(int id) {
        DungeonModels.ID_TO_MODEL.put(id, this);
        this.id = id;
        return this;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public int getEntranceType() {
        return this.entranceType;
    }

    public boolean hasLootTable() {
        return this.lootTable != null;
    }

    @Nullable
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public BoundingBox createBoundingBox(int x, int y, int z, Rotation rotation) {
        switch (rotation) {
            case NONE: 
            case CLOCKWISE_180: {
                return new BoundingBox(x, y, z, x + this.width - 1, y + this.height - 1, z + this.length - 1);
            }
            case CLOCKWISE_90: 
            case COUNTERCLOCKWISE_90: {
                return new BoundingBox(x, y, z, x + this.length - 1, y + this.height - 1, z + this.width - 1);
            }
        }
        DungeonCrawl.LOGGER.warn("Unknown piece rotation: {}", (Object)rotation);
        return new BoundingBox(x, y, z, x + this.width - 1, y + this.height - 1, z + this.length - 1);
    }

    public BoundingBox createBoundingBoxWithOffset(int x, int y, int z, Rotation rotation) {
        Vec3i offset = this.getOffset(rotation);
        return this.createBoundingBox(x + offset.m_123341_(), y + offset.m_123342_(), z + offset.m_123343_(), rotation);
    }

    public BoundingBox createBoundingBox(BlockPos origin, Rotation rotation) {
        switch (rotation) {
            case NONE: 
            case CLOCKWISE_180: {
                return new BoundingBox(origin.m_123341_(), origin.m_123342_(), origin.m_123343_(), origin.m_123341_() + this.width - 1, origin.m_123342_() + this.height - 1, origin.m_123343_() + this.length - 1);
            }
            case CLOCKWISE_90: 
            case COUNTERCLOCKWISE_90: {
                return new BoundingBox(origin.m_123341_(), origin.m_123342_(), origin.m_123343_(), origin.m_123341_() + this.length - 1, origin.m_123342_() + this.height - 1, origin.m_123343_() + this.width - 1);
            }
        }
        DungeonCrawl.LOGGER.warn("Unknown piece rotation: {}", (Object)rotation);
        return new BoundingBox(origin.m_123341_(), origin.m_123342_(), origin.m_123343_(), origin.m_123341_() + this.width - 1, origin.m_123342_() + this.height - 1, origin.m_123343_() + this.length - 1);
    }

    public Vec3i getOffset(Rotation rotation) {
        if ((rotation.ordinal() & 1) == 1) {
            return this.rotatedOffset;
        }
        return this.offset;
    }

    public boolean hasId() {
        return this.hasId;
    }

    public boolean hasFeatures() {
        return this.hasFeatures;
    }

    public boolean hasMultipart() {
        return this.hasMultipart;
    }

    public boolean isVariationEnabled() {
        return this.variation;
    }

    @Nullable
    public DungeonModelFeature[] getFeatures() {
        return this.features;
    }

    @Nullable
    public List<MultipartModelData> getMultipartData() {
        return this.multipartData;
    }

    @Nullable
    public Integer getId() {
        return this.id;
    }

    public String toString() {
        return "{key=" + this.key + "}";
    }
}

