/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableMap;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;
import xiroc.dungeoncrawl.dungeon.model.PlacementBehaviour;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockStateProvider;

public enum DungeonModelBlockType {
    AIR((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> DungeonBlocks.CAVE_AIR),
    SOLID(DungeonModelBlockType.tFactory(Theme::getSolid), PlacementBehaviour.SOLID),
    SOLID_STAIRS(DungeonModelBlockType.tFactory(Theme::getSolidStairs), PlacementBehaviour.SOLID),
    SOLID_SLAB(DungeonModelBlockType.tFactory(Theme::getSolidSlab), PlacementBehaviour.SOLID),
    GENERIC(DungeonModelBlockType.tFactory(Theme::getGeneric)),
    SLAB(DungeonModelBlockType.tFactory(Theme::getSlab)),
    SOLID_PILLAR(DungeonModelBlockType.tFactory(Theme::getPillar), PlacementBehaviour.SOLID, true),
    SOLID_FLOOR(DungeonModelBlockType.tFactory(Theme::getFloor), PlacementBehaviour.SOLID),
    FENCING(DungeonModelBlockType.tFactory(Theme::getFencing)),
    FLOOR(DungeonModelBlockType.tFactory(Theme::getFloor), PlacementBehaviour.RANDOM_IF_SOLID_NEARBY),
    FLUID(DungeonModelBlockType.tFactory(Theme::getFluid)),
    LOOSE_GROUND(DungeonModelBlockType.tFactory(Theme::getFloor)),
    STAIRS(DungeonModelBlockType.tFactory(Theme::getStairs)),
    WALL(DungeonModelBlockType.tFactory(Theme::getWall)),
    PILLAR(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getPillar), true),
    MATERIAL_STAIRS(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getStairs)),
    TRAPDOOR(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getTrapDoor)),
    DOOR(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getDoor)),
    FENCE(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getFence)),
    FENCE_GATE(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getFenceGate)),
    MATERIAL_SLAB(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getSlab)),
    MATERIAL_BUTTON(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getButton)),
    MATERIAL_PRESSURE_PLATE(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getPressurePlate)),
    MATERIAL(DungeonModelBlockType.sFactory(Theme.SecondaryTheme::getMaterial)),
    CHEST((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(Blocks.f_50087_.m_49966_(), world, pos, rotation)),
    SKULL((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> {
        BlockState state = block.create(Blocks.f_50310_.m_49966_(), world, pos, rotation);
        if (state.m_61138_((Property)BlockStateProperties.f_61390_)) {
            int r = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_);
            int add = rand.nextInt(3);
            if (rand.nextBoolean()) {
                if ((r -= add) < 0) {
                    r += 16;
                }
            } else {
                r = (r + add) % 16;
            }
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(r));
            return state;
        }
        return state;
    }),
    CARPET((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> {
        Block b;
        Block block2 = b = block.variation != null && variation != null ? DungeonBlocks.CARPET[(block.variation + variation[block.variation % variation.length]) % DungeonBlocks.CARPET.length] : (Block)ForgeRegistries.BLOCKS.getValue(block.blockName);
        if (b == null) {
            b = DungeonBlocks.CARPET[rand.nextInt(DungeonBlocks.CARPET.length)];
        }
        return block.create(b.m_49966_());
    }),
    OTHER((block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(block.getBlock().m_49966_(), world, pos, rotation));

    public static final ImmutableMap<String, DungeonModelBlockType> NAME_TO_TYPE;
    public final BlockFactory blockFactory;
    public final PlacementBehaviour placementBehavior;
    private final boolean isPillar;

    private DungeonModelBlockType(BlockFactory blockFactory) {
        this(blockFactory, PlacementBehaviour.NON_SOLID);
    }

    private DungeonModelBlockType(BlockFactory blockFactory, boolean isPillar) {
        this(blockFactory, PlacementBehaviour.NON_SOLID, isPillar);
    }

    private DungeonModelBlockType(BlockFactory blockFactory, PlacementBehaviour placementBehavior) {
        this(blockFactory, placementBehavior, false);
    }

    private DungeonModelBlockType(BlockFactory blockFactory, PlacementBehaviour placementBehavior, boolean isPillar) {
        this.blockFactory = blockFactory;
        this.placementBehavior = placementBehavior;
        this.isPillar = isPillar;
    }

    public boolean isPillar() {
        return this.isPillar;
    }

    public boolean isSolid(LevelAccessor world, BlockPos pos, Random rand, int relativeX, int relativeY, int relativeZ) {
        return (Boolean)Config.SOLID.get() != false || this.placementBehavior.function.isSolid(world, pos, rand, relativeX, relativeY, relativeZ);
    }

    public static DungeonModelBlockType get(Block block, ModelBlockDefinition definition) {
        if (definition.containsBlock(block)) {
            return definition.getType(block);
        }
        if (definition.fallback != null && definition.fallback.containsBlock(block)) {
            return definition.fallback.getType(block);
        }
        if (BlockTags.f_13094_.m_8110_((Object)block)) {
            return CARPET;
        }
        return OTHER;
    }

    private static BlockFactory tFactory(Function<Theme, IBlockStateProvider> blockSelector) {
        return (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(((IBlockStateProvider)blockSelector.apply(theme)).get(world, pos, rotation), world, pos, rotation);
    }

    private static BlockFactory sFactory(Function<Theme.SecondaryTheme, IBlockStateProvider> blockSelector) {
        return (block, rotation, world, pos, theme, subTheme, rand, variation, stage) -> block.create(((IBlockStateProvider)blockSelector.apply(subTheme)).get(world, pos, rotation), world, pos, rotation);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (DungeonModelBlockType type : DungeonModelBlockType.values()) {
            builder.put((Object)type.name(), (Object)type);
        }
        builder.put((Object)"NORMAL", (Object)GENERIC);
        builder.put((Object)"VANILLA_WALL", (Object)WALL);
        builder.put((Object)"WOODEN_BUTTON", (Object)MATERIAL_BUTTON);
        builder.put((Object)"WOODEN_SLAB", (Object)MATERIAL_SLAB);
        builder.put((Object)"WOODEN_PRESSURE_PLATE", (Object)MATERIAL_PRESSURE_PLATE);
        builder.put((Object)"NORMAL_2", (Object)AIR);
        builder.put((Object)"GENERIC_SECONDARY", (Object)AIR);
        builder.put((Object)"SPAWNER", (Object)AIR);
        builder.put((Object)"BARREL", (Object)AIR);
        NAME_TO_TYPE = builder.build();
    }

    @FunctionalInterface
    public static interface BlockFactory {
        public BlockState get(DungeonModelBlock var1, Rotation var2, LevelAccessor var3, BlockPos var4, Theme var5, Theme.SecondaryTheme var6, Random var7, byte[] var8, int var9);
    }
}

