/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.monster.WeightedRandomPotionEffect;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.util.Range;

public class RandomPotionEffect {
    public static float[] CHANCES;
    public static Range[] ROLLS;
    public static WeightedRandomPotionEffect[] EFFECTS;
    public static PotionEffect[][] GUARANTEED_EFFECTS;

    public static void loadJson(ResourceManager resourceManager) {
        CHANCES = new float[5];
        ROLLS = new Range[5];
        EFFECTS = new WeightedRandomPotionEffect[5];
        GUARANTEED_EFFECTS = new PotionEffect[5][];
        JsonParser parser = new JsonParser();
        try {
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_1.json"), parser, 0);
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_2.json"), parser, 1);
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_3.json"), parser, 2);
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_4.json"), parser, 3);
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_5.json"), parser, 4);
        }
        catch (IOException e) {
            DungeonCrawl.LOGGER.error("Failed to load the monster potion effect files.");
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadFile(ResourceManager resourceManager, ResourceLocation file, JsonParser parser, int stage) throws IOException {
        if (!resourceManager.m_7165_(file)) throw new FileNotFoundException("Missing file " + file);
        try {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)file.toString());
            JsonObject object = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.m_142591_(file).m_6679_()))).getAsJsonObject();
            if (!object.has("chance")) {
                throw new DatapackLoadException("Missing entry 'chance' in " + file);
            }
            RandomPotionEffect.CHANCES[stage] = object.get("chance").getAsFloat();
            if (!object.has("rolls")) {
                throw new DatapackLoadException("Missing entry 'rolls' in " + file);
            }
            JsonObject amount = object.getAsJsonObject("rolls");
            RandomPotionEffect.ROLLS[stage] = new Range(amount.get("min").getAsInt(), amount.get("max").getAsInt());
            if (!object.has("effects")) {
                throw new DatapackLoadException("Missing entry 'effects' in " + file);
            }
            RandomPotionEffect.EFFECTS[stage] = WeightedRandomPotionEffect.fromJson(object.getAsJsonArray("effects"));
            if (!object.has("guaranteed")) return;
            JsonArray array = object.getAsJsonArray("guaranteed");
            RandomPotionEffect.GUARANTEED_EFFECTS[stage] = new PotionEffect[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                JsonObject effect = array.get(i).getAsJsonObject();
                Range amplifier = effect.has("amplifier") ? new Range(effect.getAsJsonObject("amplifier").get("min").getAsInt(), effect.getAsJsonObject("amplifier").get("max").getAsInt()) : new Range(0, 0);
                RandomPotionEffect.GUARANTEED_EFFECTS[stage][i] = new PotionEffect((MobEffect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effect.get("effect").getAsString())), effect.get("duration").getAsInt(), amplifier);
            }
            return;
        }
        catch (Exception e) {
            DungeonCrawl.LOGGER.error("Failed to load {} ", (Object)file);
            e.printStackTrace();
            return;
        }
    }

    @Nullable
    public static ListTag createPotionEffects(Random rand, int stage) {
        boolean guaranteed;
        if (stage > 4) {
            stage = 4;
        }
        boolean chance = rand.nextFloat() < CHANCES[stage];
        boolean bl = guaranteed = GUARANTEED_EFFECTS[stage] != null;
        if (chance || guaranteed) {
            int rolls;
            ListTag list = new ListTag();
            if (chance && (rolls = ROLLS[stage].nextInt(rand)) > 0) {
                MobEffect[] effects = new MobEffect[rolls - 1];
                block0: for (int i = 0; i < rolls; ++i) {
                    WeightedRandomPotionEffect.WeightedEntry weightedEntry = EFFECTS[stage].roll(rand);
                    if (weightedEntry == null) continue;
                    for (MobEffect value : effects) {
                        if (value == weightedEntry.effect()) continue block0;
                    }
                    if (i < rolls - 1) {
                        effects[i] = weightedEntry.effect();
                    }
                    list.add((Object)RandomPotionEffect.toNBT(weightedEntry.effect(), weightedEntry.duration(), weightedEntry.amplifier().nextInt(rand)));
                }
            }
            if (guaranteed) {
                for (PotionEffect potionEffect : GUARANTEED_EFFECTS[stage]) {
                    list.add((Object)RandomPotionEffect.toNBT(potionEffect.effect, potionEffect.duration, potionEffect.amplifier.nextInt(rand)));
                }
            }
            return list;
        }
        return null;
    }

    private static CompoundTag toNBT(MobEffect effect, int duration, int amplifier) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Id", MobEffect.m_19459_((MobEffect)effect));
        nbt.m_128405_("Duration", duration);
        nbt.m_128405_("Amplifier", amplifier);
        return nbt;
    }

    private record PotionEffect(MobEffect effect, int duration, Range amplifier) {
    }
}

