/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.theme.Theme;

public class Loot {
    public static final ResourceLocation CHEST_STAGE_1 = DungeonCrawl.locate("chests/stage_1");
    public static final ResourceLocation CHEST_STAGE_2 = DungeonCrawl.locate("chests/stage_2");
    public static final ResourceLocation CHEST_STAGE_3 = DungeonCrawl.locate("chests/stage_3");
    public static final ResourceLocation CHEST_STAGE_4 = DungeonCrawl.locate("chests/stage_4");
    public static final ResourceLocation CHEST_STAGE_5 = DungeonCrawl.locate("chests/stage_5");
    public static final ResourceLocation FORGE = DungeonCrawl.locate("chests/forge");
    public static final ResourceLocation FOOD = DungeonCrawl.locate("chests/food");
    public static final ResourceLocation TREASURE_ROOM = DungeonCrawl.locate("chests/treasure_room");
    public static final ResourceLocation SUPPLY_CHEST = DungeonCrawl.locate("chests/supply_chest");
    public static final ResourceLocation LIBRARY = DungeonCrawl.locate("chests/library");
    public static final ResourceLocation SECRET_ROOM = DungeonCrawl.locate("chests/secret_room");
    public static final ResourceLocation DISPENSER_STAGE_1 = DungeonCrawl.locate("misc/dispenser_1");
    public static final ResourceLocation DISPENSER_STAGE_2 = DungeonCrawl.locate("misc/dispenser_2");
    public static final ResourceLocation DISPENSER_STAGE_3 = DungeonCrawl.locate("misc/dispenser_3");
    public static final ResourceLocation WITHER_SKELETON = DungeonCrawl.locate("monster_overrides/wither_skeleton");

    public static void setLoot(RandomizableContainerBlockEntity tile, ResourceLocation lootTable, Theme theme, Theme.SecondaryTheme secondaryTheme, Random rand) {
        tile.m_59626_(lootTable, rand.nextLong());
        Loot.setLootInformation(tile.getTileData(), theme, secondaryTheme);
    }

    public static ResourceLocation getLootTable(int lootLevel, Random rand) {
        switch (lootLevel) {
            case 0: {
                return (double)rand.nextFloat() < 0.1 ? BuiltInLootTables.f_78686_ : CHEST_STAGE_1;
            }
            case 1: {
                return (double)rand.nextFloat() < 0.1 ? BuiltInLootTables.f_78742_ : CHEST_STAGE_2;
            }
            case 2: {
                return (double)rand.nextFloat() < 0.1 ? BuiltInLootTables.f_78742_ : CHEST_STAGE_3;
            }
            case 3: {
                return (double)rand.nextFloat() < 0.1 ? BuiltInLootTables.f_78762_ : CHEST_STAGE_4;
            }
            case 4: {
                return (double)rand.nextFloat() < 0.1 ? BuiltInLootTables.f_78762_ : CHEST_STAGE_5;
            }
        }
        return CHEST_STAGE_5;
    }

    public static void setLootInformation(CompoundTag nbt, Theme theme, Theme.SecondaryTheme secondaryTheme) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("theme", theme.getKey().toString());
        data.m_128359_("secondaryTheme", secondaryTheme.getKey().toString());
        nbt.m_128365_("dungeoncrawl", (Tag)data);
    }

    public static Tuple<Theme, Theme.SecondaryTheme> getLootInformation(CompoundTag nbt) {
        CompoundTag data = nbt.m_128469_("dungeoncrawl");
        return new Tuple((Object)Theme.getTheme(new ResourceLocation(data.m_128461_("theme"))), (Object)Theme.getSecondaryTheme(new ResourceLocation(data.m_128461_("secondaryTheme"))));
    }
}

