/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Random;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.misc.Banner;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.dungeon.treasure.TreasureItem;
import xiroc.dungeoncrawl.dungeon.treasure.WeightedRandomTreasureItem;
import xiroc.dungeoncrawl.util.Range;

public class RandomItems {
    public static final int COLOR = 3847130;
    public static final ItemStack[] ITEMS;
    public static final ItemStack[] RARE_ITEMS;
    public static final ItemStack REINFORCED_BOW;
    public static final ItemStack BOOTS_OF_BATTLE;
    public static final ItemStack PANTS_OF_DEFLECTION;
    public static final ItemStack LUMBERJACKET;
    public static final ItemStack YOKEL_AXE;
    public static final ItemStack DOOM;
    public static final ItemStack THE_SLAYER;
    public static final ItemStack DEMON_HUNTER_CROSSBOW;
    public static final ItemStack THIEF_DAGGER;
    public static final ItemStack THE_GREAT_CLEAVER;
    public static final ItemStack ARCHANGEL_SWORD;
    public static final ItemStack REPULSER;
    public static final ItemStack ELB_BOW;
    public static WeightedRandomTreasureItem STAGE_1;
    public static WeightedRandomTreasureItem STAGE_2;
    public static WeightedRandomTreasureItem STAGE_3;
    public static WeightedRandomTreasureItem STAGE_4;
    public static WeightedRandomTreasureItem STAGE_5;
    private static final Range[] UNBREAKING_LEVELS;

    public static void loadJson(ResourceManager resourceManager) {
        try {
            JsonParser parser = new JsonParser();
            ResourceLocation stage1 = DungeonCrawl.locate("treasure/stage_1.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage1.toString());
            JsonArray array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.m_142591_(stage1).m_6679_()))).getAsJsonArray();
            STAGE_1 = WeightedRandomTreasureItem.fromJson(array);
            ResourceLocation stage2 = DungeonCrawl.locate("treasure/stage_2.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage2.toString());
            array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.m_142591_(stage2).m_6679_()))).getAsJsonArray();
            STAGE_2 = WeightedRandomTreasureItem.fromJson(array);
            ResourceLocation stage3 = DungeonCrawl.locate("treasure/stage_3.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage3.toString());
            array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.m_142591_(stage3).m_6679_()))).getAsJsonArray();
            STAGE_3 = WeightedRandomTreasureItem.fromJson(array);
            ResourceLocation stage4 = DungeonCrawl.locate("treasure/stage_4.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage4.toString());
            array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.m_142591_(stage4).m_6679_()))).getAsJsonArray();
            STAGE_4 = WeightedRandomTreasureItem.fromJson(array);
            ResourceLocation stage5 = DungeonCrawl.locate("treasure/stage_5.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage5.toString());
            array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.m_142591_(stage5).m_6679_()))).getAsJsonArray();
            STAGE_5 = WeightedRandomTreasureItem.fromJson(array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack generate(ServerLevel world, Random rand, Integer lootLevel) {
        switch (lootLevel) {
            case 0: {
                return STAGE_1.roll(rand).createItem((LevelAccessor)world, rand, lootLevel);
            }
            case 1: {
                return STAGE_2.roll(rand).createItem((LevelAccessor)world, rand, lootLevel);
            }
            case 2: {
                return STAGE_3.roll(rand).createItem((LevelAccessor)world, rand, lootLevel);
            }
            case 3: {
                return STAGE_4.roll(rand).createItem((LevelAccessor)world, rand, lootLevel);
            }
        }
        return STAGE_5.roll(rand).createItem((LevelAccessor)world, rand, lootLevel);
    }

    public static TreasureItem createEnchantedSpecialItem(String itemName) {
        return new TreasureItem("minecraft:air").setProcessor((world, rand, lootLevel) -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
            if (item != null) {
                return EnchantmentHelper.m_44877_((Random)rand, (ItemStack)new ItemStack((ItemLike)item), (int)(10 + 3 * lootLevel), (lootLevel > 2 ? 1 : 0) != 0);
            }
            DungeonCrawl.LOGGER.error("The item {} does not exist.", (Object)itemName);
            return ItemStack.f_41583_;
        });
    }

    public static ItemStack createShield(Random rand, int lootLevel) {
        ItemStack shield = new ItemStack((ItemLike)Items.f_42740_);
        lootLevel = Math.min(4, lootLevel);
        float f = rand.nextFloat();
        if (f < 0.12f + (float)lootLevel * 0.02f) {
            shield.m_41663_(Enchantments.f_44986_, UNBREAKING_LEVELS[Mth.m_14045_((int)lootLevel, (int)0, (int)4)].nextInt(rand));
            if ((double)f < 0.04 + (double)lootLevel * 0.01) {
                shield.m_41663_(Enchantments.f_44962_, 1);
            }
            if ((double)rand.nextFloat() < 0.75) {
                shield.m_41663_(Enchantments.f_44963_, 1);
            }
        }
        shield.m_41784_().m_128365_("BlockEntityTag", (Tag)Banner.createPatterns(rand));
        return shield;
    }

    static {
        UNBREAKING_LEVELS = new Range[]{new Range(1, 1), new Range(1, 2), new Range(2, 2), new Range(2, 3), new Range(3, 3)};
        REINFORCED_BOW = new ItemStack((ItemLike)Items.f_42411_);
        REINFORCED_BOW.m_41663_(Enchantments.f_44986_, 1);
        REINFORCED_BOW.m_41663_(Enchantments.f_44988_, 1);
        REINFORCED_BOW.m_41714_((Component)new TextComponent("Reinforced Bow"));
        BOOTS_OF_BATTLE = new ItemStack((ItemLike)Items.f_42463_);
        RandomEquipment.setArmorColor(BOOTS_OF_BATTLE, 3847130);
        BOOTS_OF_BATTLE.m_41663_(Enchantments.f_44986_, 1);
        BOOTS_OF_BATTLE.m_41663_(Enchantments.f_44965_, 1);
        BOOTS_OF_BATTLE.m_41714_((Component)new TextComponent("Boots of Battle"));
        PANTS_OF_DEFLECTION = new ItemStack((ItemLike)Items.f_42462_);
        RandomEquipment.setArmorColor(PANTS_OF_DEFLECTION, 3847130);
        PANTS_OF_DEFLECTION.m_41663_(Enchantments.f_44965_, 2);
        PANTS_OF_DEFLECTION.m_41663_(Enchantments.f_44972_, 1);
        PANTS_OF_DEFLECTION.m_41714_((Component)new TextComponent("Pants of Deflection"));
        LUMBERJACKET = new ItemStack((ItemLike)Items.f_42408_);
        RandomEquipment.setArmorColor(LUMBERJACKET, 11546150);
        LUMBERJACKET.m_41663_(Enchantments.f_44986_, 3);
        LUMBERJACKET.m_41663_(Enchantments.f_44966_, 1);
        LUMBERJACKET.m_41714_((Component)new TextComponent("Lumberjacket"));
        YOKEL_AXE = new ItemStack((ItemLike)Items.f_42386_);
        YOKEL_AXE.m_41663_(Enchantments.f_44984_, 2);
        YOKEL_AXE.m_41663_(Enchantments.f_44977_, 1);
        YOKEL_AXE.m_41663_(Enchantments.f_44986_, 1);
        YOKEL_AXE.m_41714_((Component)new TextComponent("Yokel's Axe"));
        DOOM = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:golden_sword")));
        DOOM.m_41663_(Enchantments.f_44977_, 1);
        DOOM.m_41663_(Enchantments.f_44981_, 2);
        DOOM.m_41663_(Enchantments.f_44986_, 1);
        DOOM.m_41714_((Component)new TextComponent("Doom"));
        THE_SLAYER = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:diamond_sword")));
        THE_SLAYER.m_41663_(Enchantments.f_44977_, 4);
        THE_SLAYER.m_41714_((Component)new TextComponent("The Slayer"));
        DEMON_HUNTER_CROSSBOW = new ItemStack((ItemLike)Items.f_42717_);
        DEMON_HUNTER_CROSSBOW.m_41663_(Enchantments.f_44961_, 2);
        DEMON_HUNTER_CROSSBOW.m_41663_(Enchantments.f_44959_, 1);
        DEMON_HUNTER_CROSSBOW.m_41663_(Enchantments.f_44960_, 1);
        DEMON_HUNTER_CROSSBOW.m_41663_(Enchantments.f_44988_, 4);
        DEMON_HUNTER_CROSSBOW.m_41714_((Component)new TextComponent("Demon Hunter's Crossbow"));
        THIEF_DAGGER = new ItemStack((ItemLike)Items.f_42383_);
        THIEF_DAGGER.m_41663_(Enchantments.f_44977_, 1);
        THIEF_DAGGER.m_41663_(Enchantments.f_44982_, 3);
        THIEF_DAGGER.m_41714_((Component)new TextComponent("Thief's Dagger"));
        THE_GREAT_CLEAVER = new ItemStack((ItemLike)Items.f_42388_);
        THE_GREAT_CLEAVER.m_41663_(Enchantments.f_44983_, 3);
        THE_GREAT_CLEAVER.m_41663_(Enchantments.f_44978_, 4);
        THE_GREAT_CLEAVER.m_41663_(Enchantments.f_44986_, 3);
        THE_GREAT_CLEAVER.m_41714_((Component)new TextComponent("The Great Cleaver"));
        ARCHANGEL_SWORD = new ItemStack((ItemLike)Items.f_42430_);
        ARCHANGEL_SWORD.m_41663_(Enchantments.f_44977_, 4);
        ARCHANGEL_SWORD.m_41663_(Enchantments.f_44986_, 2);
        ARCHANGEL_SWORD.m_41663_(Enchantments.f_44963_, 1);
        ARCHANGEL_SWORD.m_41714_((Component)new TextComponent("Archangel's Sword"));
        REPULSER = new ItemStack((ItemLike)Items.f_42383_);
        REPULSER.m_41663_(Enchantments.f_44980_, 2);
        REPULSER.m_41663_(Enchantments.f_44983_, 1);
        REPULSER.m_41714_((Component)new TextComponent("Repulser"));
        ELB_BOW = new ItemStack((ItemLike)Items.f_42411_);
        ELB_BOW.m_41663_(Enchantments.f_44988_, 4);
        ELB_BOW.m_41663_(Enchantments.f_44961_, 3);
        ELB_BOW.m_41663_(Enchantments.f_44962_, 1);
        ELB_BOW.m_41714_((Component)new TextComponent("Bow of the Elbs"));
        ITEMS = new ItemStack[]{REINFORCED_BOW, BOOTS_OF_BATTLE, LUMBERJACKET, YOKEL_AXE, DOOM, ARCHANGEL_SWORD, REPULSER};
        RARE_ITEMS = new ItemStack[]{THE_SLAYER, DEMON_HUNTER_CROSSBOW, THIEF_DAGGER, THE_GREAT_CLEAVER};
    }
}

