/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.block.provider.pattern;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.util.Orientation;

public class TerracottaPattern
implements BlockStateProvider {
    protected static final String TYPE = "pattern";
    protected static final String PATTERN_TYPE = "terracotta";
    private final BlockStateProvider block;

    public TerracottaPattern(BlockStateProvider block) {
        this.block = block;
    }

    @Override
    public BlockState get(IWorld world, BlockPos pos, Random random, Rotation rotation) {
        BlockState state = this.block.get(world, pos, random, rotation);
        if ((pos.func_177958_n() & 1) == 0) {
            if ((pos.func_177952_p() & 1) == 0) {
                return DungeonBlocks.applyProperty(state, BlockStateProperties.field_208157_J, Direction.SOUTH).rotate(world, pos, Orientation.getOppositeRotation(rotation));
            }
            return DungeonBlocks.applyProperty(state, BlockStateProperties.field_208157_J, Direction.EAST).rotate(world, pos, Orientation.getOppositeRotation(rotation));
        }
        if ((pos.func_177952_p() & 1) == 0) {
            return DungeonBlocks.applyProperty(state, BlockStateProperties.field_208157_J, Direction.WEST).rotate(world, pos, Orientation.getOppositeRotation(rotation));
        }
        return DungeonBlocks.applyProperty(state, BlockStateProperties.field_208157_J, Direction.NORTH).rotate(world, pos, Orientation.getOppositeRotation(rotation));
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", TYPE);
        object.addProperty("pattern_type", PATTERN_TYPE);
        object.add("block", (JsonElement)this.block.serialize());
        return object;
    }
}

