/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public class FloorDecoration
implements DungeonDecoration {
    private final float chance;
    private final BlockStateProvider blockStateProvider;

    public FloorDecoration(BlockStateProvider blockStateProvider, float chance) {
        this.blockStateProvider = blockStateProvider;
        this.chance = chance;
    }

    @Override
    public void decorate(DungeonModel model, IWorld world, BlockPos origin, Random random, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds, DungeonPiece piece) {
        model.blocks.forEach(block -> {
            BlockPos pos = DungeonDecoration.getRotatedBlockPos(block.position.func_177958_n(), block.position.func_177956_o() + 1, block.position.func_177952_p(), origin, model, piece.field_186169_c);
            if (block.type == DungeonModelBlockType.FLOOR && block.position.func_177956_o() < model.height - 1 && worldGenBounds.func_175898_b((Vector3i)pos) && structureBounds.func_175898_b((Vector3i)pos) && !DungeonBuilder.isBlockProtected(world, origin) && world.func_175623_d(origin.func_177971_a(block.position).func_177984_a()) && FloorDecoration.checkSolid(world, origin.func_177971_a(block.position), worldGenBounds, structureBounds) && random.nextFloat() < this.chance) {
                world.func_180501_a(pos, this.blockStateProvider.get(world, pos, random), 2);
            }
        });
    }

    private static boolean checkSolid(IWorld world, BlockPos pos, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds) {
        return worldGenBounds.func_175898_b((Vector3i)pos) && structureBounds.func_175898_b((Vector3i)pos) && world.func_180495_p(pos).func_200132_m();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "floor");
        object.addProperty("chance", (Number)Float.valueOf(this.chance));
        object.add("block", (JsonElement)this.blockStateProvider.serialize());
        return object;
    }

    public static class NextToSolid
    implements DungeonDecoration {
        private final float chance;
        private final BlockStateProvider blockStateProvider;

        public NextToSolid(BlockStateProvider blockStateProvider, float chance) {
            this.blockStateProvider = blockStateProvider;
            this.chance = chance;
        }

        @Override
        public void decorate(DungeonModel model, IWorld world, BlockPos origin, Random random, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds, DungeonPiece piece) {
            model.blocks.forEach(block -> {
                BlockPos pos;
                if (block.type == DungeonModelBlockType.FLOOR && block.position.func_177956_o() < model.height - 1 && worldGenBounds.func_175898_b((Vector3i)(pos = DungeonDecoration.getRotatedBlockPos(block.position.func_177958_n(), block.position.func_177956_o() + 1, block.position.func_177952_p(), origin, model, piece.field_186169_c))) && structureBounds.func_175898_b((Vector3i)pos) && world.func_175623_d(pos) && world.func_180495_p(pos.func_177977_b()).func_200132_m() && !DungeonBuilder.isBlockProtected(world, pos) && (FloorDecoration.checkSolid(world, pos.func_177978_c(), worldGenBounds, structureBounds) || FloorDecoration.checkSolid(world, pos.func_177974_f(), worldGenBounds, structureBounds) || FloorDecoration.checkSolid(world, pos.func_177968_d(), worldGenBounds, structureBounds) || FloorDecoration.checkSolid(world, pos.func_177976_e(), worldGenBounds, structureBounds)) && random.nextFloat() < this.chance) {
                    world.func_180501_a(pos, this.blockStateProvider.get(world, pos, random), 2);
                }
            });
        }

        @Override
        public JsonObject serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("type", "floor_next_to_solid");
            object.addProperty("chance", (Number)Float.valueOf(this.chance));
            object.add("block", (JsonElement)this.blockStateProvider.serialize());
            return object;
        }
    }
}

