/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;

public class ModelBlockDefinition {
    private static final String DIRECTORY = "dev/block_definitions";
    public static final Hashtable<ResourceLocation, ModelBlockDefinition> DEFINITIONS = new Hashtable();
    private static final Hashtable<Block, DungeonModelBlockType> DEFAULT = new Hashtable();
    private static final ModelBlockDefinition DEFAULT_DEFINITION;
    private static final ResourceLocation DEFAULT_LOCATION;
    public ModelBlockDefinition fallback;
    private final Hashtable<Block, DungeonModelBlockType> definition;
    private final Hashtable<DungeonModelBlockType, Block> invertedDefinition;
    private static ImmutableSet<ResourceLocation> KEYS;
    private static ImmutableSet.Builder<ResourceLocation> keySetBuilder;

    public ModelBlockDefinition(Hashtable<Block, DungeonModelBlockType> definition) {
        this.definition = definition;
        this.invertedDefinition = new Hashtable();
        this.definition.forEach((block, type) -> this.invertedDefinition.put((DungeonModelBlockType)((Object)type), (Block)block));
    }

    public boolean containsBlock(Block block) {
        return this.definition.containsKey(block);
    }

    public DungeonModelBlockType getType(Block block) {
        return this.definition.getOrDefault(block, DungeonModelBlockType.OTHER);
    }

    public Block getBlock(DungeonModelBlock block) {
        if (block.type == DungeonModelBlockType.OTHER) {
            return (Block)ForgeRegistries.BLOCKS.getValue(block.blockName);
        }
        if (block.type == DungeonModelBlockType.CARPET) {
            if (block.block != null) {
                return block.block;
            }
            return Blocks.field_196724_fH;
        }
        if (this.invertedDefinition.containsKey((Object)block.type)) {
            return this.invertedDefinition.get((Object)block.type);
        }
        if (this.fallback != null && this.fallback.invertedDefinition.containsKey((Object)block.type)) {
            return this.fallback.invertedDefinition.get((Object)block.type);
        }
        return Blocks.field_150350_a;
    }

    public static void loadJson(IResourceManager resourceManager) {
        keySetBuilder = new ImmutableSet.Builder();
        ArrayList referencesToUpdate = Lists.newArrayList();
        resourceManager.func_199003_a(DIRECTORY, s -> s.endsWith(".json")).forEach(resource -> ModelBlockDefinition.loadDefinition(resourceManager, resource, referencesToUpdate));
        for (Tuple reference : referencesToUpdate) {
            ResourceLocation key = (ResourceLocation)reference.func_76340_b();
            if (DEFINITIONS.containsKey(key)) {
                ((ModelBlockDefinition)reference.func_76341_a()).fallback = DEFINITIONS.get(key);
                continue;
            }
            DungeonCrawl.LOGGER.warn("Unknown fallback model block definition: {}", (Object)key);
        }
        KEYS = keySetBuilder.build();
    }

    private static void loadDefinition(IResourceManager resourceManager, ResourceLocation resourceLocation, List<Tuple<ModelBlockDefinition, ResourceLocation>> referencesToUpdate) {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)resourceLocation);
        JsonParser parser = new JsonParser();
        Hashtable<Block, DungeonModelBlockType> definition = new Hashtable<Block, DungeonModelBlockType>();
        try {
            JsonObject object = parser.parse((Reader)new InputStreamReader(resourceManager.func_199002_a(resourceLocation).func_199027_b())).getAsJsonObject();
            object.getAsJsonObject("definition").entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
                if (block != null) {
                    String value = ((JsonElement)entry.getValue()).getAsString().toUpperCase();
                    if (DungeonModelBlockType.NAME_TO_TYPE.containsKey((Object)value)) {
                        definition.put(block, (DungeonModelBlockType)((Object)DungeonModelBlockType.NAME_TO_TYPE.get((Object)value)));
                    } else {
                        DungeonCrawl.LOGGER.warn("Unknown model block type: {}", (Object)value);
                    }
                } else {
                    DungeonCrawl.LOGGER.warn("Unknown block: {}", (Object)key);
                }
            });
            ModelBlockDefinition blockDefinition = new ModelBlockDefinition(definition);
            if (object.has("fallback")) {
                referencesToUpdate.add((Tuple<ModelBlockDefinition, ResourceLocation>)new Tuple((Object)blockDefinition, (Object)new ResourceLocation(object.get("fallback").getAsString())));
            }
            ResourceLocation key = DungeonCrawl.key(resourceLocation, DIRECTORY, ".json");
            DEFINITIONS.put(key, blockDefinition);
            keySetBuilder.add((Object)key);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ModelBlockDefinition getDefaultDefinition() {
        return DEFINITIONS.getOrDefault(DEFAULT_LOCATION, DEFAULT_DEFINITION);
    }

    public static ImmutableSet<ResourceLocation> getKeys() {
        return KEYS;
    }

    static {
        DEFAULT_LOCATION = DungeonCrawl.locate("default");
        DEFAULT.put(Blocks.field_150350_a, DungeonModelBlockType.AIR);
        DEFAULT.put(Blocks.field_201941_jj, DungeonModelBlockType.AIR);
        DEFAULT.put(Blocks.field_150486_ae, DungeonModelBlockType.CHEST);
        DEFAULT.put(Blocks.field_150390_bg, DungeonModelBlockType.SOLID_STAIRS);
        DEFAULT.put(Blocks.field_150347_e, DungeonModelBlockType.GENERIC);
        DEFAULT.put(Blocks.field_196696_di, DungeonModelBlockType.SOLID);
        DEFAULT.put(Blocks.field_222413_lB, DungeonModelBlockType.WALL);
        DEFAULT.put(Blocks.field_185768_cU, DungeonModelBlockType.SOLID_PILLAR);
        DEFAULT.put(Blocks.field_150411_aY, DungeonModelBlockType.FENCING);
        DEFAULT.put(Blocks.field_150355_j, DungeonModelBlockType.FLUID);
        DEFAULT.put(Blocks.field_196617_K, DungeonModelBlockType.PILLAR);
        DEFAULT.put(Blocks.field_196662_n, DungeonModelBlockType.MATERIAL);
        DEFAULT.put(Blocks.field_180413_ao, DungeonModelBlockType.DOOR);
        DEFAULT.put(Blocks.field_150476_ad, DungeonModelBlockType.MATERIAL_STAIRS);
        DEFAULT.put(Blocks.field_196622_bq, DungeonModelBlockType.MATERIAL_SLAB);
        DEFAULT.put(Blocks.field_196689_eF, DungeonModelBlockType.MATERIAL_BUTTON);
        DEFAULT.put(Blocks.field_180407_aO, DungeonModelBlockType.FENCE);
        DEFAULT.put(Blocks.field_180390_bo, DungeonModelBlockType.FENCE_GATE);
        DEFAULT.put(Blocks.field_196663_cq, DungeonModelBlockType.MATERIAL_PRESSURE_PLATE);
        DEFAULT.put(Blocks.field_196636_cW, DungeonModelBlockType.TRAPDOOR);
        DEFAULT.put(Blocks.field_150351_n, DungeonModelBlockType.FLOOR);
        DEFAULT.put(Blocks.field_196700_dk, DungeonModelBlockType.SOLID_FLOOR);
        DEFAULT.put(Blocks.field_196659_cl, DungeonModelBlockType.STAIRS);
        DEFAULT.put(Blocks.field_196646_bz, DungeonModelBlockType.SLAB);
        DEFAULT.put(Blocks.field_196703_eM, DungeonModelBlockType.SKULL);
        DEFAULT_DEFINITION = new ModelBlockDefinition(DEFAULT);
        DEFINITIONS.put(DungeonCrawl.locate("builtin/default"), DEFAULT_DEFINITION);
    }
}

