/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.monster.WeightedRandomPotionEffect;

public class RandomPotionEffect {
    public static float[] CHANCES;
    public static RandomValueRange[] ROLLS;
    public static WeightedRandomPotionEffect[] EFFECTS;
    public static PotionEffect[][] GUARANTEED_EFFECTS;

    public static void loadJson(IResourceManager resourceManager) {
        CHANCES = new float[5];
        ROLLS = new RandomValueRange[5];
        EFFECTS = new WeightedRandomPotionEffect[5];
        GUARANTEED_EFFECTS = new PotionEffect[5][];
        JsonParser parser = new JsonParser();
        try {
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_1.json"), parser, 0);
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_2.json"), parser, 1);
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_3.json"), parser, 2);
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_4.json"), parser, 3);
            RandomPotionEffect.loadFile(resourceManager, DungeonCrawl.locate("monster/potion_effects/stage_5.json"), parser, 4);
        }
        catch (IOException e) {
            DungeonCrawl.LOGGER.error("Failed to load the monster potion effect files.");
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadFile(IResourceManager resourceManager, ResourceLocation file, JsonParser parser, int stage) throws IOException {
        if (!resourceManager.func_219533_b(file)) throw new FileNotFoundException("Missing file " + file.toString());
        try {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)file.toString());
            JsonObject object = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(file).func_199027_b()))).getAsJsonObject();
            if (object.has("chance")) {
                RandomPotionEffect.CHANCES[stage] = object.get("chance").getAsFloat();
            } else {
                DungeonCrawl.LOGGER.warn("Missing entry 'chance' in {}", (Object)file.toString());
                RandomPotionEffect.CHANCES[stage] = 0.0f;
            }
            if (object.has("rolls")) {
                JsonObject amount = object.getAsJsonObject("rolls");
                RandomPotionEffect.ROLLS[stage] = new RandomValueRange((float)amount.get("min").getAsInt(), (float)amount.get("max").getAsInt());
            } else {
                DungeonCrawl.LOGGER.warn("Missing entry 'rolls' in {}", (Object)file.toString());
                RandomPotionEffect.ROLLS[stage] = new RandomValueRange(0.0f);
            }
            if (object.has("effects")) {
                RandomPotionEffect.EFFECTS[stage] = WeightedRandomPotionEffect.fromJson(object.getAsJsonArray("effects"));
            } else {
                DungeonCrawl.LOGGER.warn("Missing entry 'effects' in {}", (Object)file.toString());
                RandomPotionEffect.EFFECTS[stage] = WeightedRandomPotionEffect.EMPTY;
            }
            if (!object.has("guaranteed")) return;
            JsonArray array = object.getAsJsonArray("guaranteed");
            RandomPotionEffect.GUARANTEED_EFFECTS[stage] = new PotionEffect[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                JsonObject effect = array.get(i).getAsJsonObject();
                RandomValueRange amplifier = effect.has("amplifier") ? new RandomValueRange((float)effect.getAsJsonObject("amplifier").get("min").getAsInt(), (float)effect.getAsJsonObject("amplifier").get("max").getAsInt()) : new RandomValueRange(0.0f);
                RandomPotionEffect.GUARANTEED_EFFECTS[stage][i] = new PotionEffect((Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effect.get("effect").getAsString())), effect.get("duration").getAsInt(), amplifier);
            }
            return;
        }
        catch (Exception e) {
            DungeonCrawl.LOGGER.error("Failed to load {}" + file.toString());
            e.printStackTrace();
            return;
        }
    }

    public static void applyPotionEffects(MonsterEntity entity, Random rand, int stage) {
        int rolls;
        if (stage > 4) {
            stage = 4;
        }
        if (rand.nextFloat() < CHANCES[stage] && (rolls = ROLLS[stage].func_186511_a(rand)) > 0) {
            Effect[] effects = new Effect[rolls - 1];
            block0: for (int i = 0; i < rolls; ++i) {
                WeightedRandomPotionEffect.WeightedEntry weightedEntry = EFFECTS[stage].roll(rand);
                if (weightedEntry == null) continue;
                for (Effect value : effects) {
                    if (value == weightedEntry.effect) continue block0;
                }
                if (i < rolls - 1) {
                    effects[i] = weightedEntry.effect;
                }
                entity.func_195064_c(new EffectInstance(weightedEntry.effect, weightedEntry.duration, weightedEntry.amplifier.func_186511_a(rand)));
            }
        }
        if (GUARANTEED_EFFECTS[stage] != null) {
            for (PotionEffect potionEffect : GUARANTEED_EFFECTS[stage]) {
                entity.func_195064_c(new EffectInstance(potionEffect.effect, potionEffect.duration, potionEffect.amplifier.func_186511_a(rand)));
            }
        }
    }

    @Nullable
    public static ListNBT createPotionEffects(Random rand, int stage) {
        boolean guaranteed;
        if (stage > 4) {
            stage = 4;
        }
        boolean chance = rand.nextFloat() < CHANCES[stage];
        boolean bl = guaranteed = GUARANTEED_EFFECTS[stage] != null;
        if (chance || guaranteed) {
            int rolls;
            ListNBT list = new ListNBT();
            if (chance && (rolls = ROLLS[stage].func_186511_a(rand)) > 0) {
                Effect[] effects = new Effect[rolls - 1];
                block0: for (int i = 0; i < rolls; ++i) {
                    WeightedRandomPotionEffect.WeightedEntry weightedEntry = EFFECTS[stage].roll(rand);
                    if (weightedEntry == null) continue;
                    for (Effect value : effects) {
                        if (value == weightedEntry.effect) continue block0;
                    }
                    if (i < rolls - 1) {
                        effects[i] = weightedEntry.effect;
                    }
                    list.add((Object)RandomPotionEffect.toNBT(weightedEntry.effect, weightedEntry.duration, weightedEntry.amplifier.func_186511_a(rand)));
                }
            }
            if (guaranteed) {
                for (PotionEffect potionEffect : GUARANTEED_EFFECTS[stage]) {
                    list.add((Object)RandomPotionEffect.toNBT(potionEffect.effect, potionEffect.duration, potionEffect.amplifier.func_186511_a(rand)));
                }
            }
            return list;
        }
        return null;
    }

    private static CompoundNBT toNBT(Effect effect, int duration, int amplifier) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("Id", Effect.func_188409_a((Effect)effect));
        nbt.func_74768_a("Duration", duration);
        nbt.func_74768_a("Amplifier", amplifier);
        return nbt;
    }

    private static class PotionEffect {
        public final Effect effect;
        public final int duration;
        public final RandomValueRange amplifier;

        public PotionEffect(Effect effect, int duration, RandomValueRange amplifier) {
            this.effect = effect;
            this.duration = duration;
            this.amplifier = amplifier;
        }
    }
}

