/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.mojang.datafixers.Dynamic;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.ServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.config.ObfuscationValues;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonPieces;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelRegistry;

public class Dungeon
extends Structure<NoFeatureConfig> {
    public static final String NAME = "DCDungeon";
    public static final Dungeon DUNGEON = new Dungeon(NoFeatureConfig::func_214639_a);
    public static final IStructurePieceType ENTRANCE_BUILDER = IStructurePieceType.func_214750_a(DungeonPieces.EntranceBuilder::new, (String)"DUNGEON_ENTR_BLDR");
    public static final IStructurePieceType ROOM = IStructurePieceType.func_214750_a(DungeonPieces.Room::new, (String)"DUNGEON_ROOM");
    public static final IStructurePieceType CORRIDOR = IStructurePieceType.func_214750_a(DungeonPieces.Corridor::new, (String)"DUNGEON_CRRDR");
    public static final IStructurePieceType STAIRSTOP = IStructurePieceType.func_214750_a(DungeonPieces.StairsTop::new, (String)"DUNGEON_STTP");
    public static final IStructurePieceType STAIRS = IStructurePieceType.func_214750_a(DungeonPieces.Stairs::new, (String)"DUNGEON_STRS");
    public static final IStructurePieceType STAIRSBOT = IStructurePieceType.func_214750_a(DungeonPieces.StairsBot::new, (String)"DUNGEON_STBT");
    public static final IStructurePieceType HOLE = IStructurePieceType.func_214750_a(DungeonPieces.Hole::new, (String)"DUNGEON_HOLE");
    public static final IStructurePieceType CORRIDOR_ROOM = IStructurePieceType.func_214750_a(DungeonPieces.CorridorRoom::new, (String)"DUNGEON_CRRDR_ROOM");
    public static final IStructurePieceType CORRIDOR_TRAP = IStructurePieceType.func_214750_a(DungeonPieces.CorridorTrap::new, (String)"DUNGEON_TRAP");
    public static final IStructurePieceType PART = IStructurePieceType.func_214750_a(DungeonPieces.Part::new, (String)"DUNGEON_PART");
    public static final IStructurePieceType HOLE_TRAP = IStructurePieceType.func_214750_a(DungeonPieces.HoleTrap::new, (String)"DUNGEON_HOLE_TRAP");
    public static final IStructurePieceType SIDE_ROOM = IStructurePieceType.func_214750_a(DungeonPieces.SideRoom::new, (String)"DUNGEON_SIDE_ROOM");

    public Dungeon(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51427_1_) {
        super(p_i51427_1_);
    }

    public ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int i = 15;
        int j = 10;
        int k = x + i * spacingOffsetsX;
        int l = z + i * spacingOffsetsZ;
        int i1 = k < 0 ? k - i + 1 : k;
        int j1 = l < 0 ? l - i + 1 : l;
        int k1 = i1 / i;
        int l1 = j1 / i;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, 10387319);
        k1 *= i;
        l1 *= i;
        return new ChunkPos(k1 += (random.nextInt(i - j) + random.nextInt(i - j)) / 2, l1 += (random.nextInt(i - j) + random.nextInt(i - j)) / 2);
    }

    public boolean func_202372_a(ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b) {
            for (Biome biome : chunkGen.func_202090_b().func_201538_a(chunkPosX * 16 + 64, chunkPosZ * 16 + 64, 128)) {
                if (((Boolean)Config.IGNORE_OVERWORLD_BLACKLIST.get()).booleanValue() || chunkGen.func_202094_a(biome, (Structure)DUNGEON)) continue;
                return false;
            }
            return (double)rand.nextFloat() < (Double)Config.DUNGEON_PROBABLILITY.get();
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return NAME;
    }

    public int func_202367_b() {
        return 8;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> p_i51341_1_, int chunkX, int chunkZ, Biome biomeIn, MutableBoundingBox boundsIn, int referenceIn, long seed) {
            super(p_i51341_1_, chunkX, chunkZ, biomeIn, boundsIn, referenceIn, seed);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            try {
                Field world = ChunkGenerator.class.getDeclaredField(ObfuscationValues.CHUNKGEN_WORLD);
                world.setAccessible(true);
                Field modifierField = Field.class.getDeclaredField("modifiers");
                modifierField.setAccessible(true);
                modifierField.setInt(world, world.getModifiers() & 0xFFFFFFEF);
                DungeonCrawl.LOGGER.debug("Checking [{}, {}]", (Object)chunkX, (Object)chunkZ);
                ServerWorld serverWorld = (ServerWorld)world.get(generator);
                BlockPos spawn = serverWorld.func_175694_M();
                int spawnChunkX = spawn.func_177958_n() % 16;
                int spawnChunkZ = spawn.func_177952_p() % 16;
                if (serverWorld.func_201675_m().func_186058_p() != DimensionType.field_223227_a_ || spawnChunkX - chunkX < 8 && spawnChunkX - chunkX > -8 || spawnChunkZ - chunkZ < 8 && spawnChunkZ - chunkZ > -8) {
                    return;
                }
                modifierField.setInt(world, 18);
                modifierField.setAccessible(false);
                world.setAccessible(false);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                DungeonCrawl.LOGGER.error("Failed to access the chunkGen world through reflection. This might result in dungeons getting generated near the spawn chunk.");
                e.printStackTrace();
            }
            ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
            long now = System.currentTimeMillis();
            DungeonBuilder builder = new DungeonBuilder(generator, chunkpos, (Random)this.field_214631_d);
            this.field_75075_a.addAll(builder.build());
            this.func_202500_a();
            DungeonCrawl.LOGGER.info("Built dungeon logic for [{}, {}] ({} ms) ({} pieces)", (Object)chunkX, (Object)chunkZ, (Object)(System.currentTimeMillis() - now), (Object)this.field_75075_a.size());
        }

        public void func_75068_a(IWorld worldIn, Random rand, MutableBoundingBox structurebb, ChunkPos pos) {
            if (!((Boolean)Config.IGNORE_DIMENSION.get()).booleanValue() && worldIn.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
                DungeonCrawl.LOGGER.warn("Refusing to generate a placed Dungeon in {} because it is not in OVERWORLD.", (Object)worldIn.func_201675_m().func_186058_p());
                return;
            }
            DungeonSegmentModelRegistry.load((IResourceManager)((ServerWorld)worldIn.func_201672_e()).func_73046_m().func_195570_aG());
            super.func_75068_a(worldIn, rand, structurebb, pos);
        }
    }
}

