/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.DungeonPieces;
import xiroc.dungeoncrawl.dungeon.RandomFeature;
import xiroc.dungeoncrawl.util.Position2D;
import xiroc.dungeoncrawl.util.RotationHelper;

public class DungeonFeatures {
    public static final List<CorridorFeature> CORRIDOR_FEATURES = Lists.newArrayList();

    public static void processCorridor(DungeonLayer layer, int x, int z, Random rand, int lyr, int stage, BlockPos startPos) {
        for (CorridorFeature corridorFeature : CORRIDOR_FEATURES) {
            if (!corridorFeature.process(layer, x, z, rand, lyr, stage, startPos)) continue;
            return;
        }
    }

    static {
        CORRIDOR_FEATURES.add((layer, x, z, rand, lyr, stage, startPos) -> {
            if (layer.segments[x][z].connectedSides == 2 && (layer.segments[x][z].sides[0] && layer.segments[x][z].sides[2] || layer.segments[x][z].sides[1] && layer.segments[x][z].sides[3]) && rand.nextDouble() < 0.08) {
                ((DungeonPieces.Corridor)layer.segments[x][z]).specialType = lyr > 0 ? 1 : 2;
                return true;
            }
            return false;
        });
        CORRIDOR_FEATURES.add((layer, x, z, rand, lyr, stage, startPos) -> {
            Direction facing;
            Position2D pos;
            Position2D roomPos;
            if (layer.segments[x][z].getType() == 0 && layer.segments[x][z].connectedSides < 4 && (roomPos = (pos = new Position2D(x, z)).shift(RotationHelper.translateDirectionLeft(facing = RotationHelper.translateDirection(Direction.EAST, layer.segments[x][z].field_186169_c)), 1)).isValid(layer.width, layer.length) && layer.segments[roomPos.x][roomPos.z] == null && rand.nextDouble() < 0.06) {
                layer.segments[x][z].openSide(RotationHelper.translateDirectionLeft(facing));
                DungeonPieces.SideRoom sideRoom = (DungeonPieces.SideRoom)RandomFeature.SIDE_ROOM.roll(rand);
                sideRoom.setPosition(roomPos.x, roomPos.z);
                sideRoom.stage = stage;
                sideRoom.connectedSides = 1;
                sideRoom.setRealPosition(startPos.func_177958_n() + roomPos.x * 8, startPos.func_177956_o() - lyr * 16, startPos.func_177952_p() + roomPos.z * 8);
                sideRoom.field_186169_c = layer.segments[x][z].field_186169_c.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
                layer.rotatePiece(layer.segments[x][z]);
                layer.segments[roomPos.x][roomPos.z] = sideRoom;
                return true;
            }
            return false;
        });
        CORRIDOR_FEATURES.add((layer, x, z, rand, lyr, stage, startPos) -> {
            if (layer.segments[x][z].connectedSides == 2 && rand.nextDouble() < 0.07 && (layer.segments[x][z].sides[0] && layer.segments[x][z].sides[2] || layer.segments[x][z].sides[1] && layer.segments[x][z].sides[3])) {
                DungeonPieces.DungeonPiece feature = RandomFeature.CORRIDOR_FEATURE.roll(rand);
                feature.sides = layer.segments[x][z].sides;
                feature.connectedSides = layer.segments[x][z].connectedSides;
                feature.setRealPosition(startPos.func_177958_n() + x * 8, startPos.func_177956_o() - lyr * 16, startPos.func_177952_p() + z * 8);
                feature.stage = stage;
                feature.field_186169_c = layer.segments[x][z].field_186169_c;
                layer.segments[x][z] = feature;
                return true;
            }
            return false;
        });
        CORRIDOR_FEATURES.add((layer, x, z, rand, lyr, stage, startPos) -> {
            if (layer.segments[x][z].getType() == 0 && layer.segments[x][z].connectedSides < 4) {
                Direction facing = RotationHelper.translateDirection(Direction.EAST, layer.segments[x][z].field_186169_c);
                Position2D pos = new Position2D(x, z);
                Position2D part1Pos = pos.shift(RotationHelper.translateDirectionLeft(facing), 1);
                Position2D part2Pos = part1Pos.shift(facing, 1);
                if (part1Pos.isValid(layer.width, layer.length) && part2Pos.isValid(layer.width, layer.length) && layer.canPutDoubleRoom(part1Pos, facing) && rand.nextDouble() < 0.019) {
                    layer.segments[x][z].openSide(RotationHelper.translateDirectionLeft(facing));
                    DungeonPieces.Part part1 = new DungeonPieces.Part(null, DungeonPieces.DEFAULT_NBT);
                    DungeonPieces.Part part2 = new DungeonPieces.Part(null, DungeonPieces.DEFAULT_NBT);
                    part1.connectedSides = 1;
                    part1.treasureType = 1;
                    part2.treasureType = 1;
                    part1.stage = stage;
                    part2.stage = stage;
                    part1.setPosition(part1Pos.x, part1Pos.z);
                    part2.setPosition(part2Pos.x, part2Pos.z);
                    part1.setRotation(layer.segments[x][z].field_186169_c.func_185830_a(Rotation.COUNTERCLOCKWISE_90));
                    part2.setRotation(layer.segments[x][z].field_186169_c.func_185830_a(Rotation.COUNTERCLOCKWISE_90));
                    layer.rotatePiece(layer.segments[x][z]);
                    int id = 27;
                    part1.set(id, 0, 0, 0, 8, 8, 8);
                    part2.set(id, 0, 0, 8, 8, 8, 8);
                    part1.setRealPosition(startPos.func_177958_n() + part1Pos.x * 8, startPos.func_177956_o() - lyr * 16, startPos.func_177952_p() + part1Pos.z * 8);
                    part2.setRealPosition(startPos.func_177958_n() + part2Pos.x * 8, startPos.func_177956_o() - lyr * 16, startPos.func_177952_p() + part2Pos.z * 8);
                    layer.segments[part1Pos.x][part1Pos.z] = part1;
                    layer.segments[part2Pos.x][part2Pos.z] = part2;
                    return true;
                }
                return false;
            }
            return false;
        });
    }

    @FunctionalInterface
    public static interface CorridorFeature {
        public boolean process(DungeonLayer var1, int var2, int var3, Random var4, int var5, int var6, BlockPos var7);
    }
}

