/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.segment;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlock;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlockType;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelRegistry;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

public class DungeonSegmentModel {
    public Integer id;
    public int width;
    public int height;
    public int length;
    public DungeonSegmentModelBlock[][][] model;

    public DungeonSegmentModel() {
        this.model = new DungeonSegmentModelBlock[8][8][8];
        this.length = 8;
        this.height = 8;
        this.width = 8;
    }

    public DungeonSegmentModel(DungeonSegmentModelBlock[][][] model) {
        this.model = model;
        this.width = model.length;
        this.height = model[0].length;
        this.length = model[0][0].length;
    }

    public DungeonSegmentModel setId(int id) {
        DungeonSegmentModelRegistry.MAP.put(id, this);
        this.id = id;
        return this;
    }

    public DungeonSegmentModel build() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    if (this.model[x][y][z] == null || this.model[x][y][z].type != DungeonSegmentModelBlockType.OTHER) continue;
                    this.model[x][y][z].readResourceLocation();
                }
            }
        }
        return this;
    }

    public static void build(DungeonSegmentModel model, IWorld world, BlockPos pos, Theme theme, Treasure.Type treasureType, int lootLevel) {
        for (int x = 0; x < model.width; ++x) {
            for (int y = 0; y < model.height; ++y) {
                for (int z = 0; z < model.length; ++z) {
                    BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, world.func_201674_k(), 0);
                    if (state == null) continue;
                    world.func_180501_a(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z), state, 2);
                }
            }
        }
    }

    public static void buildRotated(DungeonSegmentModel model, IWorld world, BlockPos pos, Theme theme, Treasure.Type treasureType, int lootLevel, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = 0; y < model.height; ++y) {
                        for (int z = 0; z < model.length; ++z) {
                            BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, world.func_201674_k(), 0, Rotation.CLOCKWISE_90);
                            if (state == null) continue;
                            world.func_180501_a(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z), state, 2);
                        }
                    }
                }
                break;
            }
            case COUNTERCLOCKWISE_90: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = 0; y < model.height; ++y) {
                        for (int z = 0; z < model.length; ++z) {
                            BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, world.func_201674_k(), 0, Rotation.COUNTERCLOCKWISE_90);
                            if (state == null) continue;
                            world.func_180501_a(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z), state, 2);
                        }
                    }
                }
                break;
            }
            case CLOCKWISE_180: {
                for (int x = 0; x < model.width; ++x) {
                    for (int y = 0; y < model.height; ++y) {
                        for (int z = 0; z < model.length; ++z) {
                            BlockState state = model.model[x][y][z] == null ? Blocks.field_150350_a.func_176223_P() : DungeonSegmentModelBlock.getBlockState(model.model[x][y][z], theme, world.func_201674_k(), 0, Rotation.CLOCKWISE_180);
                            if (state == null) continue;
                            world.func_180501_a(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z), state, 2);
                        }
                    }
                }
                break;
            }
            case NONE: {
                DungeonSegmentModel.build(model, world, pos, theme, treasureType, lootLevel);
                break;
            }
            default: {
                DungeonCrawl.LOGGER.warn("Failed to build a rotated dungeon segment: Unknown rotation " + rotation);
            }
        }
    }

    public static void setupBlockState(BlockState state, World world, BlockPos pos, Treasure.Type treasureType, int theme) {
        if (state == null) {
            return;
        }
        IBlockPlacementHandler.getHandler(state.func_177230_c()).setupBlock((IWorld)world, state, pos, world.func_201674_k(), treasureType, theme, 0);
    }

    public BlockState[][][] transform() {
        return null;
    }
}

