/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.part.block;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.storage.loot.LootTables;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.dungeon.treasure.TreasureLootTable;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

public class Chest
implements IBlockPlacementHandler {
    @Override
    public void setupBlock(IWorld world, BlockState state, BlockPos pos, Random rand, Treasure.Type treasureType, int theme, int lootLevel) {
        world.func_180501_a(pos, state, 2);
        if (treasureType != Treasure.Type.DEFAULT || lootLevel < 1 || rand.nextDouble() > 0.25) {
            LockableLootTileEntity tile = (LockableLootTileEntity)world.func_175625_s(pos);
            TreasureLootTable lootTable = Treasure.SPECIAL_LOOT_TABLES.get((Object)treasureType);
            if (lootTable != null) {
                lootTable.fillInventory((IInventory)tile, rand, theme, lootLevel);
            } else {
                Chest.getTreasureLootTable(theme, lootLevel).fillInventory((IInventory)tile, rand, theme, lootLevel);
            }
        } else {
            LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)world.func_201674_k(), (BlockPos)pos, (ResourceLocation)Chest.getLootTable(theme, lootLevel));
        }
    }

    public static TreasureLootTable getTreasureLootTable(int theme, int lootLevel) {
        switch (lootLevel) {
            case 0: {
                return theme != 3 ? Treasure.CHEST_STAGE_1 : Treasure.CHEST_STAGE_1_OCEAN;
            }
            case 1: {
                return theme != 3 ? Treasure.CHEST_STAGE_2 : Treasure.CHEST_STAGE_2_OCEAN;
            }
            case 2: {
                return theme != 3 ? Treasure.CHEST_STAGE_3 : Treasure.CHEST_STAGE_3_OCEAN;
            }
        }
        DungeonCrawl.LOGGER.warn("Unknown Loot Level: " + lootLevel);
        return null;
    }

    public static ResourceLocation getLootTable(int theme, int lootLevel) {
        switch (lootLevel) {
            case 1: {
                return theme != 3 ? LootTables.field_186424_f : LootTables.field_204114_p;
            }
            case 2: {
                return theme != 3 ? LootTables.field_186427_i : LootTables.field_204773_u;
            }
        }
        DungeonCrawl.LOGGER.warn("Unknown Vanilla Loot Level: {}", (Object)lootLevel);
        return null;
    }

    public static class Barrel
    implements IBlockPlacementHandler {
        @Override
        public void setupBlock(IWorld world, BlockState state, BlockPos pos, Random rand, Treasure.Type treasureType, int theme, int lootLevel) {
            world.func_180501_a(pos, state, 2);
            if (treasureType != Treasure.Type.DEFAULT || lootLevel < 1 || rand.nextDouble() > 0.25) {
                LockableLootTileEntity tile = (LockableLootTileEntity)world.func_175625_s(pos);
                TreasureLootTable lootTable = Treasure.SPECIAL_LOOT_TABLES.get((Object)treasureType);
                if (lootTable != null) {
                    lootTable.fillInventory((IInventory)tile, rand, theme, lootLevel);
                } else {
                    Chest.getTreasureLootTable(theme, lootLevel).fillInventory((IInventory)tile, rand, theme, lootLevel);
                }
            } else {
                LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)world.func_201674_k(), (BlockPos)pos, (ResourceLocation)Chest.getLootTable(theme, lootLevel));
            }
        }
    }
}

