/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.segment;

import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlockType;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.theme.Theme;

public class DungeonSegmentModelBlock {
    public static HashMap<DungeonSegmentModelBlockType, DungeonSegmentBlockStateProvider> PROVIDERS = new HashMap();
    private static final HashMap<String, PropertyLoader> LOADERS = new HashMap();
    public DungeonSegmentModelBlockType type;
    public Direction facing;
    public Direction.Axis axis;
    public Boolean upsideDown;
    public Boolean north;
    public Boolean east;
    public Boolean south;
    public Boolean west;
    public Boolean waterlogged;
    public Boolean lit;
    public Boolean open;
    public Boolean disarmed;
    public Boolean attached;
    public ResourceLocation registryName;
    public String resourceName;
    public Half half;
    public DoubleBlockHalf doubleBlockHalf;
    public AttachFace attachFace;
    public BedPart bedPart;
    public DoorHingeSide hinge;

    public DungeonSegmentModelBlock(DungeonSegmentModelBlockType type) {
        this.type = type;
    }

    public CompoundNBT getAsNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("type", this.type.toString());
        ListNBT properties = new ListNBT();
        if (this.resourceName != null) {
            tag.func_74778_a("resourceName", this.resourceName);
        }
        this.add(tag, properties, this.facing, "facing");
        this.add(tag, properties, this.axis, "axis");
        this.addBoolean(tag, properties, this.upsideDown, "upsideDown");
        this.addBoolean(tag, properties, this.north, "north");
        this.addBoolean(tag, properties, this.east, "east");
        this.addBoolean(tag, properties, this.south, "south");
        this.addBoolean(tag, properties, this.west, "west");
        this.addBoolean(tag, properties, this.waterlogged, "waterlogged");
        this.addBoolean(tag, properties, this.lit, "lit");
        this.addBoolean(tag, properties, this.open, "open");
        this.addBoolean(tag, properties, this.disarmed, "disarmed");
        this.addBoolean(tag, properties, this.attached, "attached");
        this.add(tag, properties, this.half, "half");
        this.add(tag, properties, this.doubleBlockHalf, "doubleBlockHalf");
        this.add(tag, properties, this.attachFace, "attachFace");
        this.add(tag, properties, this.bedPart, "bedPart");
        this.add(tag, properties, this.hinge, "doorHinge");
        if (properties.size() > 0) {
            tag.func_218657_a("properties", (INBT)properties);
        }
        return tag;
    }

    public static DungeonSegmentModelBlock fromNBT(CompoundNBT nbt) {
        if (!nbt.func_74764_b("type")) {
            return null;
        }
        DungeonSegmentModelBlock block = new DungeonSegmentModelBlock(DungeonSegmentModelBlockType.valueOf(nbt.func_74779_i("type")));
        if (nbt.func_74764_b("resourceName")) {
            block.resourceName = nbt.func_74779_i("resourceName");
        }
        if (nbt.func_74764_b("properties")) {
            ListNBT properties = nbt.func_150295_c("properties", 8);
            for (int i = 0; i < properties.size(); ++i) {
                LOADERS.get(properties.func_150307_f(i)).load(block, nbt);
            }
        }
        return block;
    }

    private void add(CompoundNBT tag, ListNBT properties, @Nullable Object object, String name) {
        if (object != null) {
            tag.func_74778_a(name, object.toString());
            properties.add((Object)new StringNBT(name));
        }
    }

    private void addBoolean(CompoundNBT tag, ListNBT properties, @Nullable Boolean bool, String name) {
        if (bool != null) {
            tag.func_74757_a(name, bool.booleanValue());
            properties.add((Object)new StringNBT(name));
        }
    }

    private static <T> T read(Class<T> c, String name, CompoundNBT nbt, Function<String, T> f) {
        return f.apply(nbt.func_74779_i(name).toUpperCase(Locale.ROOT));
    }

    public DungeonSegmentModelBlock set(BlockState state) {
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
            this.facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208157_J)) {
            this.facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208148_A)) {
            this.axis = (Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208148_A);
        } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208199_z)) {
            this.axis = (Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208199_z);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208151_D)) {
            this.north = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208151_D);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208152_E)) {
            this.east = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208152_E);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208153_F)) {
            this.south = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208153_F);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208154_G)) {
            this.west = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208154_G);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
            this.waterlogged = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208188_o)) {
            this.upsideDown = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208188_o);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208178_e)) {
            this.disarmed = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208178_e);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208174_a)) {
            this.attached = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208174_a);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208190_q)) {
            this.lit = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208190_q);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208193_t)) {
            this.open = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208193_t);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208164_Q)) {
            this.half = (Half)state.func_177229_b((IProperty)BlockStateProperties.field_208164_Q);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208163_P)) {
            this.doubleBlockHalf = (DoubleBlockHalf)state.func_177229_b((IProperty)BlockStateProperties.field_208163_P);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208158_K)) {
            this.attachFace = (AttachFace)state.func_177229_b((IProperty)BlockStateProperties.field_208158_K);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208139_an)) {
            this.bedPart = (BedPart)state.func_177229_b((IProperty)BlockStateProperties.field_208139_an);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208142_aq)) {
            this.hinge = (DoorHingeSide)state.func_177229_b((IProperty)BlockStateProperties.field_208142_aq);
        }
        if (this.type == DungeonSegmentModelBlockType.OTHER) {
            this.resourceName = state.func_177230_c().getRegistryName().toString();
        }
        return this;
    }

    public BlockState create(BlockState state) {
        if (this.facing != null && state.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)this.facing);
        } else if (this.facing != null && state.func_196959_b((IProperty)BlockStateProperties.field_208157_J)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)this.facing);
        } else if (this.axis != null && state.func_196959_b((IProperty)BlockStateProperties.field_208148_A)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)this.axis);
        } else if (this.axis != null && state.func_196959_b((IProperty)BlockStateProperties.field_208199_z)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)this.axis);
        }
        if (this.north != null && state.func_196959_b((IProperty)BlockStateProperties.field_208151_D)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208151_D, (Comparable)this.north);
        }
        if (this.east != null && state.func_196959_b((IProperty)BlockStateProperties.field_208152_E)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208152_E, (Comparable)this.east);
        }
        if (this.south != null && state.func_196959_b((IProperty)BlockStateProperties.field_208153_F)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208153_F, (Comparable)this.south);
        }
        if (this.west != null && state.func_196959_b((IProperty)BlockStateProperties.field_208154_G)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208154_G, (Comparable)this.west);
        }
        if (this.waterlogged != null && state.func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)this.waterlogged);
        }
        if (this.upsideDown != null && state.func_196959_b((IProperty)BlockStateProperties.field_208188_o)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208188_o, (Comparable)this.upsideDown);
        }
        if (this.disarmed != null && state.func_196959_b((IProperty)BlockStateProperties.field_208178_e)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208178_e, (Comparable)this.disarmed);
        }
        if (this.attached != null && state.func_196959_b((IProperty)BlockStateProperties.field_208174_a)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208174_a, (Comparable)this.attached);
        }
        if (this.lit != null && state.func_196959_b((IProperty)BlockStateProperties.field_208190_q)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208190_q, (Comparable)this.lit);
        }
        if (this.open != null && state.func_196959_b((IProperty)BlockStateProperties.field_208193_t)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208193_t, (Comparable)this.open);
        }
        if (this.half != null && state.func_196959_b((IProperty)BlockStateProperties.field_208164_Q)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)this.half);
        }
        if (this.attachFace != null && state.func_196959_b((IProperty)BlockStateProperties.field_208158_K)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208158_K, (Comparable)this.attachFace);
        }
        if (this.doubleBlockHalf != null && state.func_196959_b((IProperty)BlockStateProperties.field_208163_P)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208163_P, (Comparable)this.doubleBlockHalf);
        }
        if (this.bedPart != null && state.func_196959_b((IProperty)BlockStateProperties.field_208139_an)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208139_an, (Comparable)this.bedPart);
        }
        if (this.hinge != null && state.func_196959_b((IProperty)BlockStateProperties.field_208142_aq)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208142_aq, (Comparable)this.hinge);
        }
        return state;
    }

    public static void load() {
        PROVIDERS.put(DungeonSegmentModelBlockType.NONE, (block, theme, subTheme, rand, stage) -> null);
        PROVIDERS.put(DungeonSegmentModelBlockType.BARREL, (block, theme, subTheme, rand, stage) -> (BlockState)Blocks.field_222422_lK.func_176223_P().func_206870_a((IProperty)BarrelBlock.field_220092_a, (Comparable)block.facing));
        PROVIDERS.put(DungeonSegmentModelBlockType.MATERIAL, (block, theme, subTheme, rand, stage) -> block.create(theme.material.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.CEILING, (block, theme, subTheme, rand, stage) -> theme.ceiling.get());
        PROVIDERS.put(DungeonSegmentModelBlockType.CEILING_STAIRS, (block, theme, subTheme, rand, stage) -> block.create(theme.stairs.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.CHEST, (block, theme, subTheme, rand, stage) -> (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)block.facing));
        PROVIDERS.put(DungeonSegmentModelBlockType.DISPENSER, (block, theme, subTheme, rand, stage) -> (BlockState)Blocks.field_150367_z.func_176223_P().func_206870_a((IProperty)DispenserBlock.field_176441_a, (Comparable)block.facing));
        PROVIDERS.put(DungeonSegmentModelBlockType.FLOOR, (block, theme, subTheme, rand, stage) -> theme.floor.get());
        PROVIDERS.put(DungeonSegmentModelBlockType.FLOOR_STAIRS, (block, theme, subTheme, rand, stage) -> block.create(theme.stairs.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_FLOOR_CHESTCOMMON_SPAWNER, (Boolean)Config.NO_SPAWNERS.get() != false ? (block, theme, subTheme, rand, stage) -> {
            if (rand.nextInt(10) == 5) {
                return (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)block.facing);
            }
            return theme.floor.get();
        } : (block, theme, subTheme, rand, stage) -> {
            int i = rand.nextInt(20);
            if (i < 1 + stage) {
                return BlockRegistry.SPAWNER;
            }
            if (i == 5) {
                return (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)block.facing);
            }
            return theme.floor.get();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_FLOOR_LAVA, (block, theme, subTheme, rand, stage) -> {
            switch (rand.nextInt(2)) {
                case 0: {
                    return theme.floor.get();
                }
                case 1: {
                    return Blocks.field_150353_l.func_176223_P();
                }
            }
            return Blocks.field_150353_l.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_FLOOR_WATER, (block, theme, subTheme, rand, stage) -> {
            switch (rand.nextInt(2)) {
                case 0: {
                    return theme.floor.get();
                }
                case 1: {
                    return Blocks.field_150355_j.func_176223_P();
                }
            }
            return Blocks.field_150355_j.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_WALL_AIR, (block, theme, subTheme, rand, stage) -> {
            if ((double)rand.nextFloat() < 0.75) {
                return theme.wall.get();
            }
            return Blocks.field_201941_jj.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_WALL_SPAWNER, (Boolean)Config.NO_SPAWNERS.get() != false ? (block, theme, subTheme, rand, stage) -> theme.wall.get() : (block, theme, subTheme, rand, stage) -> {
            if (rand.nextInt(4 + (3 - stage)) == 0) {
                return BlockRegistry.SPAWNER;
            }
            return theme.wall.get();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_COBWEB_AIR, (block, theme, subTheme, rand, stage) -> {
            if (rand.nextInt(5) == 0) {
                return Blocks.field_201941_jj.func_176223_P();
            }
            return Blocks.field_196553_aF.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_BOOKSHELF_COBWEB, (block, theme, subTheme, rand, stage) -> {
            int roll = rand.nextInt(10);
            if (roll > 2) {
                return Blocks.field_150342_X.func_176223_P();
            }
            return Blocks.field_196553_aF.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.STAIRS, (block, theme, subTheme, rand, stage) -> block.create(theme.stairs.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.TRAPDOOR, (block, theme, subTheme, rand, stage) -> block.create(subTheme.trapDoor.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.WALL, (block, theme, subTheme, rand, stage) -> theme.wall.get());
        PROVIDERS.put(DungeonSegmentModelBlockType.WALL_LOG, (block, theme, subTheme, rand, stage) -> block.create(subTheme.wallLog.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.DOOR, (block, theme, subTheme, rand, stage) -> block.create(subTheme.door.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.OTHER, (block, theme, subTheme, rand, stage) -> block.create(((Block)ForgeRegistries.BLOCKS.getValue(block.registryName)).func_176223_P()));
    }

    public void readResourceLocation() {
        this.registryName = new ResourceLocation(this.resourceName);
    }

    public static BlockState getBlockState(DungeonSegmentModelBlock block, Theme theme, Theme.SubTheme subTheme, Random rand, int stage) {
        DungeonSegmentBlockStateProvider provider = PROVIDERS.get((Object)block.type);
        if (provider == null) {
            return Blocks.field_201941_jj.func_176223_P();
        }
        BlockState state = provider.get(block, theme, subTheme, rand, stage);
        if (state == null) {
            return null;
        }
        return state;
    }

    public static BlockState getBlockState(DungeonSegmentModelBlock block, Theme theme, Theme.SubTheme subTheme, Random rand, int stage, Rotation rotation) {
        BlockState state = DungeonSegmentModelBlock.getBlockState(block, theme, subTheme, rand, stage);
        return state == null ? null : state.func_185907_a(rotation);
    }

    static {
        LOADERS.put("facing", (block, nbt) -> {
            block.facing = DungeonSegmentModelBlock.read(Direction.class, "facing", nbt, Direction::func_176739_a);
        });
        LOADERS.put("axis", (block, nbt) -> {
            block.axis = DungeonSegmentModelBlock.read(Direction.Axis.class, "axis", nbt, Direction.Axis::func_176717_a);
        });
        LOADERS.put("upsideDown", (block, nbt) -> {
            block.upsideDown = nbt.func_74767_n("upsideDown");
        });
        LOADERS.put("north", (block, nbt) -> {
            block.north = nbt.func_74767_n("north");
        });
        LOADERS.put("east", (block, nbt) -> {
            block.east = nbt.func_74767_n("east");
        });
        LOADERS.put("south", (block, nbt) -> {
            block.south = nbt.func_74767_n("south");
        });
        LOADERS.put("west", (block, nbt) -> {
            block.west = nbt.func_74767_n("west");
        });
        LOADERS.put("waterlogged", (block, nbt) -> {
            block.waterlogged = nbt.func_74767_n("waterlogged");
        });
        LOADERS.put("lit", (block, nbt) -> {
            block.lit = nbt.func_74767_n("lit");
        });
        LOADERS.put("open", (block, nbt) -> {
            block.open = nbt.func_74767_n("open");
        });
        LOADERS.put("disarmed", (block, nbt) -> {
            block.disarmed = nbt.func_74767_n("disarmed");
        });
        LOADERS.put("attached", (block, nbt) -> {
            block.attached = nbt.func_74767_n("attached");
        });
        LOADERS.put("half", (block, nbt) -> {
            block.half = DungeonSegmentModelBlock.read(Half.class, "half", nbt, Half::valueOf);
        });
        LOADERS.put("doubleBlockHalf", (block, nbt) -> {
            block.doubleBlockHalf = DungeonSegmentModelBlock.read(DoubleBlockHalf.class, "doubleBlockHalf", nbt, DoubleBlockHalf::valueOf);
        });
        LOADERS.put("attachFace", (block, nbt) -> {
            block.attachFace = DungeonSegmentModelBlock.read(AttachFace.class, "attachFace", nbt, AttachFace::valueOf);
        });
        LOADERS.put("bedPart", (block, nbt) -> {
            block.bedPart = DungeonSegmentModelBlock.read(BedPart.class, "bedPart", nbt, BedPart::valueOf);
        });
        LOADERS.put("doorHinge", (block, nbt) -> {
            block.hinge = DungeonSegmentModelBlock.read(DoorHingeSide.class, "doorHinge", nbt, DoorHingeSide::valueOf);
        });
    }

    @FunctionalInterface
    private static interface PropertyLoader {
        public void load(DungeonSegmentModelBlock var1, CompoundNBT var2);
    }

    @FunctionalInterface
    public static interface DungeonSegmentBlockStateProvider {
        public BlockState get(DungeonSegmentModelBlock var1, Theme var2, Theme.SubTheme var3, Random var4, int var5);
    }
}

