/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.segment;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlockType;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.theme.Theme;

public class DungeonSegmentModelBlock {
    public static HashMap<DungeonSegmentModelBlockType, DungeonSegmentBlockStateProvider> PROVIDERS = new HashMap();
    public DungeonSegmentModelBlockType type;
    public Direction facing;
    public Direction.Axis axis;
    public Boolean upsideDown;
    public Boolean north;
    public Boolean east;
    public Boolean south;
    public Boolean west;
    public Boolean waterlogged;
    public Boolean lit;
    public Boolean open;
    public Boolean disarmed;
    public Boolean attached;
    public ResourceLocation registryName;
    public String resourceName;
    public Half half;
    public DoubleBlockHalf doubleBlockHalf;
    public AttachFace attachFace;
    public BedPart bedPart;
    public DoorHingeSide hinge;

    public DungeonSegmentModelBlock(DungeonSegmentModelBlockType type) {
        this.type = type;
    }

    public DungeonSegmentModelBlock set(BlockState state) {
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
            this.facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208157_J)) {
            this.facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208148_A)) {
            this.axis = (Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208148_A);
        } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208199_z)) {
            this.axis = (Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208199_z);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208151_D)) {
            this.north = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208151_D);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208152_E)) {
            this.east = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208152_E);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208153_F)) {
            this.south = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208153_F);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208154_G)) {
            this.west = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208154_G);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
            this.waterlogged = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208188_o)) {
            this.upsideDown = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208188_o);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208178_e)) {
            this.disarmed = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208178_e);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208174_a)) {
            this.attached = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208174_a);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208190_q)) {
            this.lit = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208190_q);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208193_t)) {
            this.open = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208193_t);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208164_Q)) {
            this.half = (Half)state.func_177229_b((IProperty)BlockStateProperties.field_208164_Q);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208163_P)) {
            this.doubleBlockHalf = (DoubleBlockHalf)state.func_177229_b((IProperty)BlockStateProperties.field_208163_P);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208158_K)) {
            this.attachFace = (AttachFace)state.func_177229_b((IProperty)BlockStateProperties.field_208158_K);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208139_an)) {
            this.bedPart = (BedPart)state.func_177229_b((IProperty)BlockStateProperties.field_208139_an);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208142_aq)) {
            this.hinge = (DoorHingeSide)state.func_177229_b((IProperty)BlockStateProperties.field_208142_aq);
        }
        if (this.type == DungeonSegmentModelBlockType.OTHER) {
            this.resourceName = state.func_177230_c().getRegistryName().toString();
        }
        return this;
    }

    public BlockState create(BlockState state) {
        if (this.facing != null && state.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)this.facing);
        } else if (this.facing != null && state.func_196959_b((IProperty)BlockStateProperties.field_208157_J)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)this.facing);
        } else if (this.axis != null && state.func_196959_b((IProperty)BlockStateProperties.field_208148_A)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)this.axis);
        } else if (this.axis != null && state.func_196959_b((IProperty)BlockStateProperties.field_208199_z)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)this.axis);
        }
        if (this.north != null && state.func_196959_b((IProperty)BlockStateProperties.field_208151_D)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208151_D, (Comparable)this.north);
        }
        if (this.east != null && state.func_196959_b((IProperty)BlockStateProperties.field_208152_E)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208152_E, (Comparable)this.east);
        }
        if (this.south != null && state.func_196959_b((IProperty)BlockStateProperties.field_208153_F)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208153_F, (Comparable)this.south);
        }
        if (this.west != null && state.func_196959_b((IProperty)BlockStateProperties.field_208154_G)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208154_G, (Comparable)this.west);
        }
        if (this.waterlogged != null && state.func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)this.waterlogged);
        }
        if (this.upsideDown != null && state.func_196959_b((IProperty)BlockStateProperties.field_208188_o)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208188_o, (Comparable)this.upsideDown);
        }
        if (this.disarmed != null && state.func_196959_b((IProperty)BlockStateProperties.field_208178_e)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208178_e, (Comparable)this.disarmed);
        }
        if (this.attached != null && state.func_196959_b((IProperty)BlockStateProperties.field_208174_a)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208174_a, (Comparable)this.attached);
        }
        if (this.lit != null && state.func_196959_b((IProperty)BlockStateProperties.field_208190_q)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208190_q, (Comparable)this.lit);
        }
        if (this.open != null && state.func_196959_b((IProperty)BlockStateProperties.field_208193_t)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208193_t, (Comparable)this.open);
        }
        if (this.half != null && state.func_196959_b((IProperty)BlockStateProperties.field_208164_Q)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)this.half);
        }
        if (this.attachFace != null && state.func_196959_b((IProperty)BlockStateProperties.field_208158_K)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208158_K, (Comparable)this.attachFace);
        }
        if (this.doubleBlockHalf != null && state.func_196959_b((IProperty)BlockStateProperties.field_208163_P)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208163_P, (Comparable)this.doubleBlockHalf);
        }
        if (this.bedPart != null && state.func_196959_b((IProperty)BlockStateProperties.field_208139_an)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208139_an, (Comparable)this.bedPart);
        }
        if (this.hinge != null && state.func_196959_b((IProperty)BlockStateProperties.field_208142_aq)) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208142_aq, (Comparable)this.hinge);
        }
        return state;
    }

    public static void load() {
        PROVIDERS.put(DungeonSegmentModelBlockType.NONE, (block, theme, rand, stage) -> null);
        PROVIDERS.put(DungeonSegmentModelBlockType.BARREL, (block, theme, rand, stage) -> (BlockState)Blocks.field_222422_lK.func_176223_P().func_206870_a((IProperty)BarrelBlock.field_220092_a, (Comparable)block.facing));
        PROVIDERS.put(DungeonSegmentModelBlockType.MATERIAL, (block, theme, rand, stage) -> block.create(theme.material.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.CEILING, (block, theme, rand, stage) -> theme.ceiling.get());
        PROVIDERS.put(DungeonSegmentModelBlockType.CEILING_STAIRS, (block, theme, rand, stage) -> block.create(theme.ceilingStairs.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.CHEST, (block, theme, rand, stage) -> (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)block.facing));
        PROVIDERS.put(DungeonSegmentModelBlockType.DISPENSER, (block, theme, rand, stage) -> (BlockState)Blocks.field_150367_z.func_176223_P().func_206870_a((IProperty)DispenserBlock.field_176441_a, (Comparable)block.facing));
        PROVIDERS.put(DungeonSegmentModelBlockType.FLOOR, (block, theme, rand, stage) -> theme.floor.get());
        PROVIDERS.put(DungeonSegmentModelBlockType.FLOOR_STAIRS, (block, theme, rand, stage) -> block.create(theme.floorStairs.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_FLOOR_CHESTCOMMON_SPAWNER, (block, theme, rand, stage) -> {
            int i = rand.nextInt(10);
            if (i < 1 + stage) {
                return BlockRegistry.SPAWNER;
            }
            if (i == 5) {
                return (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)block.facing);
            }
            return theme.floor.get();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_FLOOR_LAVA, (block, theme, rand, stage) -> {
            switch (rand.nextInt(2)) {
                case 0: {
                    return theme.floor.get();
                }
                case 1: {
                    return Blocks.field_150353_l.func_176223_P();
                }
            }
            return Blocks.field_150353_l.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_FLOOR_WATER, (block, theme, rand, stage) -> {
            switch (rand.nextInt(2)) {
                case 0: {
                    return theme.floor.get();
                }
                case 1: {
                    return Blocks.field_150355_j.func_176223_P();
                }
            }
            return Blocks.field_150355_j.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_WALL_AIR, (block, theme, rand, stage) -> {
            if ((double)rand.nextFloat() < 0.75) {
                return theme.wall.get();
            }
            return Blocks.field_201941_jj.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_WALL_SPAWNER, (block, theme, rand, stage) -> {
            if (rand.nextInt(2 + (2 - stage)) == 0) {
                return BlockRegistry.SPAWNER;
            }
            return theme.wall.get();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_COBWEB_AIR, (block, theme, rand, stage) -> {
            if (rand.nextInt(5) == 0) {
                return Blocks.field_201941_jj.func_176223_P();
            }
            return Blocks.field_196553_aF.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.RAND_BOOKSHELF_COBWEB, (block, theme, rand, stage) -> {
            int roll = rand.nextInt(10);
            if (roll > 2) {
                return Blocks.field_150342_X.func_176223_P();
            }
            return Blocks.field_196553_aF.func_176223_P();
        });
        PROVIDERS.put(DungeonSegmentModelBlockType.STAIRS, (block, theme, rand, stage) -> block.create(theme.stairs.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.TRAPDOOR, (block, theme, rand, stage) -> block.create(theme.trapDoorDecoration.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.WALL, (block, theme, rand, stage) -> theme.wall.get());
        PROVIDERS.put(DungeonSegmentModelBlockType.WALL_LOG, (block, theme, rand, stage) -> block.create(theme.wallLog.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.DOOR, (block, theme, rand, stage) -> block.create(theme.door.get()));
        PROVIDERS.put(DungeonSegmentModelBlockType.OTHER, (block, theme, rand, stage) -> block.create(((Block)ForgeRegistries.BLOCKS.getValue(block.registryName)).func_176223_P()));
    }

    public void readResourceLocation() {
        this.registryName = new ResourceLocation(this.resourceName);
    }

    public static BlockState getBlockState(DungeonSegmentModelBlock block, Theme theme, Random rand, int stage) {
        DungeonSegmentBlockStateProvider provider = PROVIDERS.get((Object)block.type);
        if (provider == null) {
            return Blocks.field_201941_jj.func_176223_P();
        }
        BlockState state = provider.get(block, theme, rand, stage);
        if (state == null) {
            return null;
        }
        return state;
    }

    public static BlockState getBlockState(DungeonSegmentModelBlock block, Theme theme, Random rand, int stage, Rotation rotation) {
        BlockState state = DungeonSegmentModelBlock.getBlockState(block, theme, rand, stage);
        return state == null ? null : state.func_185907_a(rotation);
    }

    @FunctionalInterface
    public static interface DungeonSegmentBlockStateProvider {
        public BlockState get(DungeonSegmentModelBlock var1, Theme var2, Random var3, int var4);
    }
}

