/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import java.util.Random;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.config.SpecialItemTags;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.dungeon.treasure.TreasureEntry;

public class RandomSpecialItem {
    public static final int COLOR = 3847130;
    public static final ItemStack[] ITEMS;
    public static final ItemStack[] RARE_ITEMS;
    public static final ItemStack REINFORCED_BOW;
    public static final ItemStack BOOTS_OF_BATTLE;
    public static final ItemStack PANTS_OF_DEFLECTION;
    public static final ItemStack LUMBERJACKET;
    public static final ItemStack YOKEL_AXE;
    public static final ItemStack DOOM;
    public static final ItemStack THE_SLAYER;
    public static final ItemStack DEMON_HUNTER_CROSSBOW;
    public static final TreasureEntry CAP;
    public static final TreasureEntry PANTALOONS;
    public static final TreasureEntry LEATHER_JACKET;
    public static final TreasureEntry LEATHER_BOOTS;
    public static final TreasureEntry IRON_SWORD;
    public static final TreasureEntry[] SPECIAL_ITEMS;
    public static final TreasureEntry[] RARE_SPECIAL_ITEMS;

    public static ItemStack generate(ServerWorld world, Random rand, Integer theme, Integer lootLevel) {
        if (lootLevel > 4 || rand.nextDouble() < 0.025 * (double)lootLevel.intValue()) {
            return rand.nextBoolean() ? RARE_SPECIAL_ITEMS[rand.nextInt(RARE_SPECIAL_ITEMS.length)].generate(world, rand, theme, lootLevel) : RARE_ITEMS[rand.nextInt(RARE_ITEMS.length)].func_77946_l();
        }
        return rand.nextDouble() < 0.8 ? SPECIAL_ITEMS[rand.nextInt(SPECIAL_ITEMS.length)].generate(world, rand, theme, lootLevel) : ITEMS[rand.nextInt(ITEMS.length)].func_77946_l();
    }

    private static TreasureEntry getDefaultSpecialItem(String item) {
        return new TreasureEntry("minecraft:air", 1).withProcessor((world, rand, theme, lootLevel) -> SpecialItemTags.rollForTagsAndApply((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item)), lootLevel, rand));
    }

    static {
        REINFORCED_BOW = new ItemStack((IItemProvider)Items.field_151031_f);
        REINFORCED_BOW.func_77966_a(Enchantments.field_185307_s, 1);
        REINFORCED_BOW.func_77966_a(Enchantments.field_185309_u, 1);
        REINFORCED_BOW.func_200302_a((ITextComponent)new StringTextComponent("Reinforced Bow"));
        BOOTS_OF_BATTLE = new ItemStack((IItemProvider)Items.field_151021_T);
        RandomEquipment.setArmorColor(BOOTS_OF_BATTLE, 3847130);
        BOOTS_OF_BATTLE.func_77966_a(Enchantments.field_185307_s, 1);
        BOOTS_OF_BATTLE.func_77966_a(Enchantments.field_180310_c, 1);
        BOOTS_OF_BATTLE.func_200302_a((ITextComponent)new StringTextComponent("Boots of Battle"));
        PANTS_OF_DEFLECTION = new ItemStack((IItemProvider)Items.field_151026_S);
        RandomEquipment.setArmorColor(PANTS_OF_DEFLECTION, 3847130);
        PANTS_OF_DEFLECTION.func_77966_a(Enchantments.field_180310_c, 2);
        PANTS_OF_DEFLECTION.func_77966_a(Enchantments.field_92091_k, 1);
        PANTS_OF_DEFLECTION.func_200302_a((ITextComponent)new StringTextComponent("Pants of Deflection"));
        LUMBERJACKET = new ItemStack((IItemProvider)Items.field_151027_R);
        RandomEquipment.setArmorColor(LUMBERJACKET, 11546150);
        LUMBERJACKET.func_77966_a(Enchantments.field_185307_s, 3);
        LUMBERJACKET.func_77966_a(Enchantments.field_77329_d, 1);
        LUMBERJACKET.func_200302_a((ITextComponent)new StringTextComponent("Lumberjacket"));
        YOKEL_AXE = new ItemStack((IItemProvider)Items.field_151036_c);
        YOKEL_AXE.func_77966_a(Enchantments.field_185305_q, 2);
        YOKEL_AXE.func_77966_a(Enchantments.field_185302_k, 1);
        YOKEL_AXE.func_77966_a(Enchantments.field_185307_s, 1);
        YOKEL_AXE.func_200302_a((ITextComponent)new StringTextComponent("Yokel's Axe"));
        DOOM = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:golden_sword")));
        DOOM.func_77966_a(Enchantments.field_185302_k, 1);
        DOOM.func_77966_a(Enchantments.field_77334_n, 2);
        DOOM.func_77966_a(Enchantments.field_185307_s, 1);
        DOOM.func_200302_a((ITextComponent)new StringTextComponent("Doom"));
        THE_SLAYER = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:diamond_sword")));
        THE_SLAYER.func_77966_a(Enchantments.field_185302_k, 4);
        THE_SLAYER.func_200302_a((ITextComponent)new StringTextComponent("The Slayer"));
        DEMON_HUNTER_CROSSBOW = new ItemStack((IItemProvider)Items.field_222114_py);
        DEMON_HUNTER_CROSSBOW.func_77966_a(Enchantments.field_222194_I, 2);
        DEMON_HUNTER_CROSSBOW.func_77966_a(Enchantments.field_222192_G, 1);
        DEMON_HUNTER_CROSSBOW.func_77966_a(Enchantments.field_222193_H, 1);
        DEMON_HUNTER_CROSSBOW.func_77966_a(Enchantments.field_185309_u, 4);
        DEMON_HUNTER_CROSSBOW.func_200302_a((ITextComponent)new StringTextComponent("Demon Hunter's Crossbow"));
        ITEMS = new ItemStack[]{REINFORCED_BOW, BOOTS_OF_BATTLE, LUMBERJACKET, YOKEL_AXE, DOOM};
        RARE_ITEMS = new ItemStack[]{THE_SLAYER, DEMON_HUNTER_CROSSBOW};
        CAP = new TreasureEntry("minecraft:air", 1).withProcessor((world, rand, theme, lootLevel) -> RandomEquipment.setArmorColor(SpecialItemTags.rollForTagsAndApply((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:leather_helmet")), lootLevel, rand, "Cap"), RandomEquipment.getRandomColor(rand)));
        LEATHER_JACKET = new TreasureEntry("minecraft:air", 1).withProcessor((world, rand, theme, lootLevel) -> RandomEquipment.setArmorColor(SpecialItemTags.rollForTagsAndApply((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:leather_chestplate")), lootLevel, rand, "Jacket"), RandomEquipment.getRandomColor(rand)));
        PANTALOONS = new TreasureEntry("minecraft:air", 1).withProcessor((world, rand, theme, lootLevel) -> RandomEquipment.setArmorColor(SpecialItemTags.rollForTagsAndApply((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:leather_leggings")), lootLevel, rand, "Pantaloons"), RandomEquipment.getRandomColor(rand)));
        LEATHER_BOOTS = new TreasureEntry("minecraft:air", 1).withProcessor((world, rand, theme, lootLevel) -> RandomEquipment.setArmorColor(SpecialItemTags.rollForTagsAndApply((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:leather_boots")), lootLevel, rand, "Boots"), RandomEquipment.getRandomColor(rand)));
        IRON_SWORD = new TreasureEntry("minecraft:air", 1).withProcessor((world, rand, theme, lootLevel) -> SpecialItemTags.rollForTagsAndApply((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:iron_sword")), lootLevel, rand, "Blade"));
        SPECIAL_ITEMS = new TreasureEntry[]{CAP, PANTALOONS, LEATHER_JACKET, LEATHER_BOOTS, RandomSpecialItem.getDefaultSpecialItem("minecraft:chainmail_boots"), RandomSpecialItem.getDefaultSpecialItem("minecraft:chainmail_leggings"), RandomSpecialItem.getDefaultSpecialItem("minecraft:chainmail_chestplate"), RandomSpecialItem.getDefaultSpecialItem("minecraft:chainmail_helmet"), RandomSpecialItem.getDefaultSpecialItem("minecraft:stone_sword"), RandomSpecialItem.getDefaultSpecialItem("minecraft:golden_sword"), RandomSpecialItem.getDefaultSpecialItem("minecraft:golden_axe"), RandomSpecialItem.getDefaultSpecialItem("minecraft:golden_boots"), RandomSpecialItem.getDefaultSpecialItem("minecraft:golden_leggings"), RandomSpecialItem.getDefaultSpecialItem("minecraft:golden_chestplate"), RandomSpecialItem.getDefaultSpecialItem("minecraft:golden_helmet"), RandomSpecialItem.getDefaultSpecialItem("minecraft:iron_axe"), RandomSpecialItem.getDefaultSpecialItem("minecraft:iron_boots"), RandomSpecialItem.getDefaultSpecialItem("minecraft:iron_leggings"), RandomSpecialItem.getDefaultSpecialItem("minecraft:iron_chestplate"), RandomSpecialItem.getDefaultSpecialItem("minecraft:iron_helmet"), IRON_SWORD};
        RARE_SPECIAL_ITEMS = new TreasureEntry[]{RandomSpecialItem.getDefaultSpecialItem("minecraft:diamond_sword"), RandomSpecialItem.getDefaultSpecialItem("minecraft:diamond_boots"), RandomSpecialItem.getDefaultSpecialItem("minecraft:diamond_leggings"), RandomSpecialItem.getDefaultSpecialItem("minecraft:diamond_chestplate"), RandomSpecialItem.getDefaultSpecialItem("minecraft:diamond_helmet"), RandomSpecialItem.getDefaultSpecialItem("minecraft:diamond_axe"), RandomSpecialItem.getDefaultSpecialItem("minecraft:diamond_shovel"), RandomSpecialItem.getDefaultSpecialItem("minecraft:diamond_pickaxe")};
    }
}

