/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.dungeon.treasure.TreasureLootTable;
import xiroc.dungeoncrawl.util.ItemProcessor;

public class TreasureEntry {
    public ResourceLocation item;
    public String resourceName;
    public int min;
    public int max;
    public int weight;
    public ItemEnchantment[] enchantments;
    public CompoundNBT nbt;
    public LootFunction[] functions;
    private ItemProcessor<ServerWorld, Random, Integer, Integer> itemProcessor;

    public TreasureEntry(String resourceName, int weight) {
        this(resourceName, 1, 1, weight, null, null);
    }

    public TreasureEntry(String resourceName, int min, int max, int weight) {
        this(resourceName, min, max, weight, null, null);
    }

    public TreasureEntry(String resourceName, int min, int max, int weight, CompoundNBT nbt, ItemEnchantment[] enchantments) {
        this.resourceName = resourceName;
        this.min = min;
        this.max = max;
        this.weight = weight;
        this.nbt = nbt;
        this.enchantments = enchantments;
    }

    public TreasureEntry(String resourceName, int min, int max, int weight, CompoundNBT nbt, ItemEnchantment[] enchantments, ItemProcessor<ServerWorld, Random, Integer, Integer> itemProcessor) {
        this(resourceName, min, max, weight, nbt, enchantments);
        this.itemProcessor = itemProcessor;
    }

    public TreasureEntry withWeight(int weight) {
        return new TreasureEntry(this.resourceName, this.min, this.max, weight, this.nbt, this.enchantments, this.itemProcessor);
    }

    public TreasureEntry withEnchantments(ItemEnchantment[] enchantments) {
        return new TreasureEntry(this.resourceName, this.min, this.max, this.weight, this.nbt, enchantments, this.itemProcessor);
    }

    public TreasureEntry withProcessor(ItemProcessor<ServerWorld, Random, Integer, Integer> itemProcessor) {
        return new TreasureEntry(this.resourceName, this.min, this.max, this.weight, this.nbt, this.enchantments, itemProcessor);
    }

    public TreasureEntry setNBT(CompoundNBT nbt) {
        this.nbt = nbt.func_74737_b();
        return this;
    }

    public TreasureEntry setEnchantments(ItemEnchantment[] enchantments) {
        this.enchantments = enchantments;
        return this;
    }

    public ItemStack generate(ServerWorld world, Random rand, int theme, int lootLevel) {
        if (this.itemProcessor != null) {
            return this.itemProcessor.generate(world, rand, theme, lootLevel);
        }
        IItemProvider itemIn = (IItemProvider)ForgeRegistries.ITEMS.getValue(this.item);
        IItemProvider blockIn = (IItemProvider)ForgeRegistries.BLOCKS.getValue(this.item);
        ItemStack stack = new ItemStack(itemIn == null ? blockIn : itemIn);
        stack.func_77982_d(this.nbt);
        if (this.max > 1) {
            stack.func_190920_e(this.min + rand.nextInt(this.max - this.min + 1));
        }
        return stack;
    }

    public void readResourceLocation() {
        this.item = new ResourceLocation(this.resourceName);
    }

    public static class VanillaLootTable
    extends TreasureEntry {
        public TreasureLootTable.VanillaImport table;

        public VanillaLootTable(TreasureLootTable.VanillaImport table) {
            this(table, table.weight);
        }

        public VanillaLootTable(TreasureLootTable.VanillaImport table, int weight) {
            super("no_resource", weight);
            this.table = table;
        }

        @Override
        public ItemStack generate(ServerWorld world, Random rand, int theme, int lootLevel) {
            return this.table.generate(new LootContext.Builder(world).func_216023_a(world.field_73012_v).func_216016_a(rand.nextLong()).func_216022_a(LootParameterSets.field_216260_a));
        }

        @Override
        public void readResourceLocation() {
        }
    }

    public static class ItemEnchantment {
        ResourceLocation id;
        int level;

        public ItemEnchantment(ResourceLocation id, int level) {
            this.id = id;
            this.level = level;
        }
    }
}

