/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.part.block;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

public class Chest
implements IBlockPlacementHandler {
    @Override
    public void setupBlock(IWorld world, BlockState state, BlockPos pos, Random rand, Treasure.Type treasureType, int theme, int lootLevel) {
        world.func_180501_a(pos, state, 2);
        if (world.func_175625_s(pos) instanceof LockableLootTileEntity) {
            ResourceLocation lootTable = Treasure.SPECIAL_LOOT_TABLES.get((Object)treasureType);
            LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)world.func_201674_k(), (BlockPos)pos, (ResourceLocation)(lootTable == null ? Chest.getLootTable(theme, lootLevel) : lootTable));
        } else {
            DungeonCrawl.LOGGER.warn("Failed to fetch a chest/barrel entity at {}", (Object)pos.toString());
        }
    }

    public static ResourceLocation getLootTable(int theme, int lootLevel) {
        switch (lootLevel) {
            case 0: {
                return theme != 3 ? Loot.CHEST_STAGE_1 : Loot.CHEST_STAGE_1_OCEAN;
            }
            case 1: {
                return theme != 3 ? Loot.CHEST_STAGE_2 : Loot.CHEST_STAGE_2_OCEAN;
            }
            case 2: {
                return theme != 3 ? Loot.CHEST_STAGE_3 : Loot.CHEST_STAGE_3_OCEAN;
            }
        }
        DungeonCrawl.LOGGER.warn("Unknown Vanilla Loot Level: {}", (Object)lootLevel);
        return null;
    }
}

