/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.util.IBlockStateProvider;

public class Theme {
    public static final Random RANDOM = new Random();
    public static HashMap<String, Integer> BIOME_TO_THEME_MAP;
    public static HashMap<Integer, Theme> ID_TO_THEME_MAP;
    public static HashMap<Integer, ThemeRandomizer> RANDOMIZERS;
    public static final Theme TEST;
    public static final Theme DEFAULT;
    public static final Theme BRICKS;
    public static final Theme ANDESITE;
    public static final Theme BRICKS_BIRCH;
    public static final Theme ANDESITE_BIRCH;
    public static final Theme BRICKS_JUNGLE;
    public static final Theme ANDESITE_JUNGLE;
    public static final Theme NETHER;
    public static final Theme BRICKS_SAVANNA;
    public static final Theme ANDESITE_SAVANNA;
    public static final Theme BRICKS_DARK_OAK;
    public static final Theme ANDESITE_DARK_OAK;
    public static final Theme BRICKS_SPRUCE;
    public static final Theme ANDESITE_SPRUCE;
    public static final Theme SWAMP;
    public static final Theme OCEAN;
    public static final Theme FROZEN_OCEAN;
    public static final Theme JUNGLE;
    public static final Theme BIRCH_FOREST;
    public static final Theme SAVANNA;
    public static final Theme OAK_FOREST;
    public static final Theme DARK_OAK_FOREST;
    public static final Theme TAIGA;
    public static final Theme DESERT;
    public static final Theme BADLANDS;
    public static final Theme ICE;
    private static final ThemeRandomizer DEFAULT_RANDOMIZER;
    public final IBlockStateProvider ceiling;
    public final IBlockStateProvider wall;
    public final IBlockStateProvider wallLog;
    public final IBlockStateProvider floor;
    public final IBlockStateProvider stairs;
    public final IBlockStateProvider ceilingStairs;
    public final IBlockStateProvider floorStairs;
    public final IBlockStateProvider trapDoorDecoration;
    public final IBlockStateProvider torchDark;
    public final IBlockStateProvider door;
    public final IBlockStateProvider material;
    public final IBlockStateProvider vanillaWall;
    public final IBlockStateProvider column;

    public Theme(IBlockStateProvider ceiling, IBlockStateProvider wall, IBlockStateProvider floor, IBlockStateProvider stairs, IBlockStateProvider ceilingStairs, IBlockStateProvider floorStairs, IBlockStateProvider wallLog, IBlockStateProvider trapDoorDecoration, IBlockStateProvider torchDark, IBlockStateProvider door, IBlockStateProvider material, IBlockStateProvider vanillaWall, IBlockStateProvider column) {
        this.ceiling = ceiling;
        this.wall = wall;
        this.wallLog = wallLog;
        this.floor = floor;
        this.stairs = stairs;
        this.ceilingStairs = ceilingStairs;
        this.floorStairs = floorStairs;
        this.trapDoorDecoration = trapDoorDecoration;
        this.torchDark = torchDark;
        this.door = door;
        this.material = material;
        this.vanillaWall = vanillaWall;
        this.column = column;
    }

    public Theme(BlockState ceiling, BlockState wall, BlockState floor, BlockState stairs, BlockState ceilingStairs, BlockState floorStairs, BlockState wallLog, BlockState trapDoorDecoration, BlockState torchDark, BlockState door, BlockState material, BlockState vanillaWall, BlockState column) {
        this.ceiling = () -> ceiling;
        this.wall = () -> wall;
        this.wallLog = () -> wallLog;
        this.floor = () -> floor;
        this.stairs = () -> stairs;
        this.ceilingStairs = () -> ceilingStairs;
        this.floorStairs = () -> floorStairs;
        this.trapDoorDecoration = () -> trapDoorDecoration;
        this.torchDark = () -> torchDark;
        this.door = () -> door;
        this.material = () -> material;
        this.vanillaWall = () -> vanillaWall;
        this.column = () -> column;
    }

    public static int getTheme(String biome) {
        int theme = BIOME_TO_THEME_MAP.getOrDefault(biome, 0);
        return RANDOMIZERS.getOrDefault(theme, DEFAULT_RANDOMIZER).randomize(RANDOM, theme);
    }

    public static Theme get(int theme) {
        return ID_TO_THEME_MAP.getOrDefault(theme, DEFAULT);
    }

    public static ThemeRandomizer createRandomizer(int ... themes) {
        return (rand, base) -> themes[rand.nextInt(themes.length)];
    }

    static {
        TEST = new Theme(() -> BlockRegistry.STONE_BRICKS, () -> BlockRegistry.STONE_BRICKS, () -> BlockRegistry.GRAVEL, () -> Blocks.field_150476_ad.func_176223_P(), () -> BlockRegistry.STAIRS_STONE_BRICKS, () -> Blocks.field_150476_ad.func_176223_P(), () -> BlockRegistry.OAK_LOG, () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196662_n.func_176223_P(), () -> Blocks.field_222413_lB.func_176223_P(), null);
        DEFAULT = new Theme(() -> BlockRegistry.STONE_BRICKS, BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150476_ad.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150476_ad.func_176223_P(), () -> BlockRegistry.OAK_LOG, () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196662_n.func_176223_P(), BlockRegistry.STONE_WALL, null);
        BRICKS = new Theme(BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE_FLOOR, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.STAIRS_BRICKS_GRANITE, () -> Blocks.field_196584_bK.func_176223_P(), () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196584_bK.func_176223_P(), BlockRegistry.BRICKS_GRANITE_WALL, null);
        ANDESITE = new Theme(BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, () -> Blocks.field_196657_h.func_176223_P(), () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196657_h.func_176223_P(), BlockRegistry.ANDESITE_STONE_WALL, null);
        BRICKS_BIRCH = new Theme(BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE_FLOOR, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.STAIRS_BRICKS_GRANITE, () -> Blocks.field_196584_bK.func_176223_P(), () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196584_bK.func_176223_P(), BlockRegistry.BRICKS_GRANITE_WALL, null);
        ANDESITE_BIRCH = new Theme(BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, () -> Blocks.field_196657_h.func_176223_P(), () -> Blocks.field_196641_cY.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180412_aq.func_176223_P(), () -> Blocks.field_196657_h.func_176223_P(), BlockRegistry.ANDESITE_STONE_WALL, null);
        BRICKS_JUNGLE = new Theme(BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE_FLOOR, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.STAIRS_BRICKS_GRANITE, () -> Blocks.field_196584_bK.func_176223_P(), () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196584_bK.func_176223_P(), BlockRegistry.BRICKS_GRANITE_WALL, null);
        ANDESITE_JUNGLE = new Theme(BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, () -> Blocks.field_196657_h.func_176223_P(), () -> Blocks.field_196644_cZ.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180411_ar.func_176223_P(), () -> Blocks.field_196657_h.func_176223_P(), BlockRegistry.ANDESITE_STONE_WALL, null);
        NETHER = new Theme(() -> BlockRegistry.STONE_BRICKS, BlockRegistry.NETHERRACK_NETHERBRICK, BlockRegistry.NETHERRACK_NETHERBRICK_SOULSAND, BlockRegistry.NETHER_BRICK_STAIRS, BlockRegistry.NETHER_BRICK_STAIRS, BlockRegistry.NETHER_BRICK_STAIRS, () -> Blocks.field_196770_fj.func_176223_P(), () -> Blocks.field_180400_cw.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_150454_av.func_176223_P(), () -> Blocks.field_150424_aL.func_176223_P(), BlockRegistry.NETHER_WALL, () -> Blocks.field_196653_dH.func_176223_P());
        BRICKS_SAVANNA = new Theme(BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE_FLOOR, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.STAIRS_BRICKS_GRANITE, () -> Blocks.field_196584_bK.func_176223_P(), () -> Blocks.field_196682_da.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180410_as.func_176223_P(), () -> Blocks.field_196584_bK.func_176223_P(), BlockRegistry.BRICKS_GRANITE_WALL, null);
        ANDESITE_SAVANNA = new Theme(BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, () -> Blocks.field_196657_h.func_176223_P(), () -> Blocks.field_196682_da.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180410_as.func_176223_P(), () -> Blocks.field_196657_h.func_176223_P(), BlockRegistry.ANDESITE_STONE_WALL, null);
        BRICKS_DARK_OAK = new Theme(BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE_FLOOR, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.STAIRS_BRICKS_GRANITE, () -> Blocks.field_196584_bK.func_176223_P(), () -> Blocks.field_196684_db.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180409_at.func_176223_P(), () -> Blocks.field_196584_bK.func_176223_P(), BlockRegistry.BRICKS_GRANITE_WALL, null);
        ANDESITE_DARK_OAK = new Theme(BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, () -> Blocks.field_196657_h.func_176223_P(), () -> Blocks.field_196684_db.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180409_at.func_176223_P(), () -> Blocks.field_196657_h.func_176223_P(), BlockRegistry.ANDESITE_STONE_WALL, null);
        BRICKS_SPRUCE = new Theme(BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE, BlockRegistry.BRICKS_GRANITE_FLOOR, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.STAIRS_BRICKS_GRANITE, BlockRegistry.STAIRS_BRICKS_GRANITE, () -> Blocks.field_196584_bK.func_176223_P(), () -> Blocks.field_196638_cX.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180414_ap.func_176223_P(), () -> Blocks.field_196584_bK.func_176223_P(), BlockRegistry.BRICKS_GRANITE_WALL, null);
        ANDESITE_SPRUCE = new Theme(BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS, BlockRegistry.ANDESITE_STONE_BRICKS_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, BlockRegistry.STAIRS_ANDESITE_STONE_COBBLESTONE, () -> Blocks.field_196657_h.func_176223_P(), () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_196677_cy.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196657_h.func_176223_P(), BlockRegistry.ANDESITE_STONE_WALL, null);
        SWAMP = new Theme(() -> BlockRegistry.STONE_BRICKS, BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150476_ad.func_176223_P(), () -> Blocks.field_150476_ad.func_176223_P(), () -> Blocks.field_150476_ad.func_176223_P(), () -> Blocks.field_196617_K.func_176223_P(), () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196662_n.func_176223_P(), BlockRegistry.STONE_WALL, null);
        FROZEN_OCEAN = OCEAN = new Theme(Blocks.field_180397_cI.func_176223_P(), Blocks.field_196779_gQ.func_176223_P(), Blocks.field_196781_gR.func_176223_P(), Blocks.field_203212_hg.func_176223_P(), Blocks.field_203211_hf.func_176223_P(), Blocks.field_203211_hf.func_176223_P(), Blocks.field_196781_gR.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), Blocks.field_180411_ar.func_176223_P(), Blocks.field_180397_cI.func_176223_P(), Blocks.field_222460_lx.func_176223_P(), Blocks.field_196781_gR.func_176223_P());
        JUNGLE = new Theme(() -> Blocks.field_196696_di.func_176223_P(), BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150481_bH.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150481_bH.func_176223_P(), () -> Blocks.field_196620_N.func_176223_P(), () -> Blocks.field_196644_cZ.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180411_ar.func_176223_P(), () -> Blocks.field_196668_q.func_176223_P(), BlockRegistry.STONE_WALL, () -> Blocks.field_196620_N.func_176223_P());
        BIRCH_FOREST = new Theme(() -> Blocks.field_196696_di.func_176223_P(), BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150487_bG.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150487_bG.func_176223_P(), () -> Blocks.field_196619_M.func_176223_P(), () -> Blocks.field_196641_cY.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180412_aq.func_176223_P(), () -> Blocks.field_196666_p.func_176223_P(), BlockRegistry.STONE_WALL, null);
        SAVANNA = new Theme(() -> Blocks.field_196696_di.func_176223_P(), BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150400_ck.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150400_ck.func_176223_P(), () -> Blocks.field_196621_O.func_176223_P(), () -> Blocks.field_196682_da.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180410_as.func_176223_P(), () -> Blocks.field_196670_r.func_176223_P(), BlockRegistry.STONE_WALL, null);
        OAK_FOREST = new Theme(() -> Blocks.field_196696_di.func_176223_P(), BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150476_ad.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150476_ad.func_176223_P(), () -> Blocks.field_196617_K.func_176223_P(), () -> Blocks.field_196636_cW.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), () -> Blocks.field_196662_n.func_176223_P(), BlockRegistry.STONE_WALL, null);
        DARK_OAK_FOREST = new Theme(() -> Blocks.field_196696_di.func_176223_P(), BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150401_cl.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150401_cl.func_176223_P(), () -> Blocks.field_196623_P.func_176223_P(), () -> Blocks.field_196684_db.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180409_at.func_176223_P(), () -> Blocks.field_196672_s.func_176223_P(), BlockRegistry.STONE_WALL, null);
        TAIGA = new Theme(() -> Blocks.field_196696_di.func_176223_P(), BlockRegistry.STONE_BRICKS_NORMAL_MOSSY_CRACKED_COBBLESTONE, BlockRegistry.STONE_BRICKS_GRAVEL_COBBLESTONE, () -> Blocks.field_150485_bF.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, () -> Blocks.field_150485_bF.func_176223_P(), () -> Blocks.field_196618_L.func_176223_P(), () -> Blocks.field_196638_cX.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180414_ap.func_176223_P(), () -> Blocks.field_196664_o.func_176223_P(), BlockRegistry.STONE_WALL, null);
        DESERT = new Theme(BlockRegistry.SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.SANDSTONE_DEFAULT_SMOOTH_SAND, BlockRegistry.STAIRS_SANDSTONE_DEFAULT_SMOOTH, BlockRegistry.STAIRS_SANDSTONE_DEFAULT_SMOOTH, BlockRegistry.STAIRS_SANDSTONE_DEFAULT_SMOOTH, () -> Blocks.field_196583_aj.func_176223_P(), () -> Blocks.field_201941_jj.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), BlockRegistry.SANDSTONE_DEFAULT_CHSELED_SMOOTH, () -> Blocks.field_222417_lF.func_176223_P(), BlockRegistry.SANDSTONE_DEFAULT_CHSELED_SMOOTH);
        BADLANDS = new Theme(BlockRegistry.RED_SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.RED_SANDSTONE_DEFAULT_CHSELED_SMOOTH, BlockRegistry.RED_SANDSTONE_DEFAULT_SMOOTH_RED_SAND, BlockRegistry.STAIRS_RED_SANDSTONE_DEFAULT_SMOOTH, BlockRegistry.STAIRS_RED_SANDSTONE_DEFAULT_SMOOTH, BlockRegistry.STAIRS_RED_SANDSTONE_DEFAULT_SMOOTH, () -> Blocks.field_196798_hA.func_176223_P(), () -> Blocks.field_201941_jj.func_176223_P(), () -> Blocks.field_150429_aA.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), BlockRegistry.RED_SANDSTONE_DEFAULT_CHSELED_SMOOTH, () -> Blocks.field_222461_ly.func_176223_P(), BlockRegistry.RED_SANDSTONE_DEFAULT_CHSELED_SMOOTH);
        ICE = new Theme(BlockRegistry.ICE_DEFAULT_PACKED, BlockRegistry.ICE_DEFAULT_PACKED, () -> Blocks.field_150432_aD.func_176223_P(), BlockRegistry.STAIRS_STONE_COBBLESTONE, BlockRegistry.ICE_DEFAULT_PACKED, BlockRegistry.ICE_DEFAULT_PACKED, () -> Blocks.field_150403_cj.func_176223_P(), () -> Blocks.field_201941_jj.func_176223_P(), () -> Blocks.field_201941_jj.func_176223_P(), () -> Blocks.field_180413_ao.func_176223_P(), BlockRegistry.ICE_DEFAULT_PACKED, BlockRegistry.ICE_DEFAULT_PACKED, BlockRegistry.ICE_DEFAULT_PACKED);
        DEFAULT_RANDOMIZER = (rand, base) -> base;
        BIOME_TO_THEME_MAP = new HashMap();
        BIOME_TO_THEME_MAP.put("minecraft:swamp", 2);
        BIOME_TO_THEME_MAP.put("minecraft:swamp_hills", 2);
        BIOME_TO_THEME_MAP.put("minecraft:ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:deep_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:cold_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:deep_cold_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:lukewarm_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:deep_lukewarm_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:warm_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:deep_warm_ocean", 3);
        BIOME_TO_THEME_MAP.put("minecraft:frozen_ocean", 4);
        BIOME_TO_THEME_MAP.put("mineraft:deep_frozen_ocean", 4);
        BIOME_TO_THEME_MAP.put("minecraft:jungle", 5);
        BIOME_TO_THEME_MAP.put("minecraft:jungle_edge", 5);
        BIOME_TO_THEME_MAP.put("minecraft:jungle_hills", 5);
        BIOME_TO_THEME_MAP.put("minecraft:modified_jungle", 5);
        BIOME_TO_THEME_MAP.put("minecraft:modified_jungle_edge", 5);
        BIOME_TO_THEME_MAP.put("minecraft:bamboo_jungle", 5);
        BIOME_TO_THEME_MAP.put("minecraft:bamboo_jungle_hills", 5);
        BIOME_TO_THEME_MAP.put("minecraft:birch_forest", 6);
        BIOME_TO_THEME_MAP.put("minecraft:birch_forest_hills", 6);
        BIOME_TO_THEME_MAP.put("minecraft:tall_birch_forest", 6);
        BIOME_TO_THEME_MAP.put("minecraft:tall_birch_hills", 6);
        BIOME_TO_THEME_MAP.put("minecraft:flower_forest", 6);
        BIOME_TO_THEME_MAP.put("minecraft:savanna", 7);
        BIOME_TO_THEME_MAP.put("minecraft:savanna_plateau", 7);
        BIOME_TO_THEME_MAP.put("minecraft:shattered_savanna", 7);
        BIOME_TO_THEME_MAP.put("minecraft:shattered_savanna_plateau", 7);
        BIOME_TO_THEME_MAP.put("minecraft:dark_forest", 9);
        BIOME_TO_THEME_MAP.put("minecraft:dark_forest_hills", 9);
        BIOME_TO_THEME_MAP.put("minecraft:taiga", 10);
        BIOME_TO_THEME_MAP.put("minecraft:snowy_tundra", 10);
        BIOME_TO_THEME_MAP.put("minecraft:taiga_hills", 10);
        BIOME_TO_THEME_MAP.put("minecraft:snowy_taiga", 10);
        BIOME_TO_THEME_MAP.put("minecraft:snowy_taga_hills", 10);
        BIOME_TO_THEME_MAP.put("minecraft:giant_tree_taiga", 10);
        BIOME_TO_THEME_MAP.put("minecraft:giant_tree_taiga_hills", 10);
        BIOME_TO_THEME_MAP.put("minecraft:taiga_mountains", 10);
        BIOME_TO_THEME_MAP.put("minecraft:snowy_taiga_mountains", 10);
        BIOME_TO_THEME_MAP.put("minecraft:giant_spruce_taiga", 10);
        BIOME_TO_THEME_MAP.put("minecraft:giant_spruce_taiga_hills", 10);
        BIOME_TO_THEME_MAP.put("minecraft:desert", 16);
        BIOME_TO_THEME_MAP.put("minecraft:desert_hills", 16);
        BIOME_TO_THEME_MAP.put("minecraft:desert_lakes", 16);
        BIOME_TO_THEME_MAP.put("minecraft:badlands", 17);
        BIOME_TO_THEME_MAP.put("minecraft:wooded_badlands_plateau", 17);
        BIOME_TO_THEME_MAP.put("minecraft:badlands_plateau", 17);
        BIOME_TO_THEME_MAP.put("minecraft:eroded_badlands", 17);
        BIOME_TO_THEME_MAP.put("minecraft:modified_wooded_badlands_plateau", 17);
        BIOME_TO_THEME_MAP.put("minecraft:modified_badlands_plateau", 17);
        BIOME_TO_THEME_MAP.put("minecraft:ice_spikes", 32);
        ID_TO_THEME_MAP = new HashMap();
        ID_TO_THEME_MAP.put(-1, TEST);
        ID_TO_THEME_MAP.put(0, DEFAULT);
        ID_TO_THEME_MAP.put(1, NETHER);
        ID_TO_THEME_MAP.put(2, SWAMP);
        ID_TO_THEME_MAP.put(3, OCEAN);
        ID_TO_THEME_MAP.put(4, OCEAN);
        ID_TO_THEME_MAP.put(5, JUNGLE);
        ID_TO_THEME_MAP.put(6, BIRCH_FOREST);
        ID_TO_THEME_MAP.put(7, SAVANNA);
        ID_TO_THEME_MAP.put(8, OAK_FOREST);
        ID_TO_THEME_MAP.put(9, DARK_OAK_FOREST);
        ID_TO_THEME_MAP.put(10, TAIGA);
        ID_TO_THEME_MAP.put(16, DESERT);
        ID_TO_THEME_MAP.put(17, BADLANDS);
        ID_TO_THEME_MAP.put(32, ICE);
        ID_TO_THEME_MAP.put(48, BRICKS);
        ID_TO_THEME_MAP.put(49, ANDESITE);
        ID_TO_THEME_MAP.put(50, BRICKS_BIRCH);
        ID_TO_THEME_MAP.put(51, ANDESITE_BIRCH);
        ID_TO_THEME_MAP.put(52, BRICKS_JUNGLE);
        ID_TO_THEME_MAP.put(53, ANDESITE_JUNGLE);
        ID_TO_THEME_MAP.put(54, BRICKS_SAVANNA);
        ID_TO_THEME_MAP.put(55, ANDESITE_SAVANNA);
        ID_TO_THEME_MAP.put(56, BRICKS_DARK_OAK);
        ID_TO_THEME_MAP.put(57, ANDESITE_DARK_OAK);
        ID_TO_THEME_MAP.put(58, BRICKS_SPRUCE);
        ID_TO_THEME_MAP.put(59, ANDESITE_SPRUCE);
        RANDOMIZERS = new HashMap();
        RANDOMIZERS.put(0, Theme.createRandomizer(0, 48, 49));
        RANDOMIZERS.put(5, Theme.createRandomizer(5, 52, 53));
        RANDOMIZERS.put(6, Theme.createRandomizer(6, 50, 51));
        RANDOMIZERS.put(7, Theme.createRandomizer(7, 54, 55));
        RANDOMIZERS.put(8, Theme.createRandomizer(8, 48, 49));
        RANDOMIZERS.put(9, Theme.createRandomizer(9, 56, 57));
        RANDOMIZERS.put(10, Theme.createRandomizer(10, 58, 59));
    }

    @FunctionalInterface
    public static interface ThemeRandomizer {
        public int randomize(Random var1, int var2);
    }
}

