/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.DungeonLayerType;
import xiroc.dungeoncrawl.dungeon.DungeonPieces;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModel;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelRegistry;
import xiroc.dungeoncrawl.util.Position2D;

public class DungeonBuilder {
    public Random rand;
    public Position2D start;
    public DungeonLayer[] layers;
    public BlockPos startPos;

    public DungeonBuilder(IWorld world, ChunkPos pos, Random rand) {
        this.rand = rand;
        this.start = new Position2D(rand.nextInt(16), rand.nextInt(16));
        this.startPos = new BlockPos(pos.field_77276_a * 16, world.func_72863_F().func_201711_g().func_205470_d() - 16, pos.field_77275_b * 16);
        this.layers = new DungeonLayer[this.startPos.func_177956_o() / 16];
        DungeonCrawl.LOGGER.info("DungeonBuilder starts at (" + this.startPos.func_177958_n() + " / " + this.startPos.func_177956_o() + " / " + this.startPos.func_177952_p() + "), " + this.layers.length + " layers");
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new DungeonLayer(DungeonLayerType.NORMAL);
            this.layers[i].buildMap(rand, i == 0 ? this.start : this.layers[i - 1].end, false);
        }
    }

    public DungeonBuilder(ChunkGenerator<?> world, ChunkPos pos, Random rand) {
        this.rand = rand;
        this.start = new Position2D(rand.nextInt(16), rand.nextInt(16));
        this.startPos = new BlockPos(pos.field_77276_a * 16, world.func_205470_d() - 16, pos.field_77275_b * 16);
        this.layers = new DungeonLayer[this.startPos.func_177956_o() / 16];
        DungeonCrawl.LOGGER.info("DungeonBuilder starts at (" + this.startPos.func_177958_n() + " / " + this.startPos.func_177956_o() + " / " + this.startPos.func_177952_p() + "), " + this.layers.length + " layers");
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new DungeonLayer(DungeonLayerType.NORMAL);
            this.layers[i].buildMap(rand, i == 0 ? this.start : this.layers[i - 1].end, i == this.layers.length - 1);
        }
    }

    public List<DungeonPieces.DungeonPiece> build() {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.layers.length; ++i) {
            list.addAll(this.buildLayer(this.layers[i], i, this.startPos));
            DungeonPieces.DungeonPiece stairs = i == 0 ? new DungeonPieces.EntranceBuilder(null, DungeonPieces.DEFAULT_NBT) : new DungeonPieces.Stairs(null, DungeonPieces.DEFAULT_NBT);
            stairs.setRealPosition(this.startPos.func_177958_n() + this.layers[i].start.x * 8, this.startPos.func_177956_o() + 8 - i * 16, this.startPos.func_177952_p() + this.layers[i].start.z * 8);
            stairs.stage = 1;
            list.add(stairs);
        }
        return list;
    }

    public List<DungeonPieces.DungeonPiece> buildLayer(DungeonLayer layer, int lyr, BlockPos startPos) {
        int stage = lyr > 2 ? 2 : lyr;
        ArrayList list = Lists.newArrayList();
        for (int x = 0; x < layer.width; ++x) {
            for (int z = 0; z < layer.length; ++z) {
                if (layer.segments[x][z] == null) continue;
                layer.segments[x][z].setRealPosition(startPos.func_177958_n() + x * 8, startPos.func_177956_o() - lyr * 16, startPos.func_177952_p() + z * 8);
                layer.segments[x][z].stage = stage;
                list.add(layer.segments[x][z]);
            }
        }
        return list;
    }

    public static DungeonSegmentModel getModel(DungeonPieces.DungeonPiece piece) {
        boolean north = piece.sides[0];
        boolean east = piece.sides[1];
        boolean south = piece.sides[2];
        boolean west = piece.sides[3];
        switch (piece.getType()) {
            case 0: {
                switch (piece.connectedSides) {
                    case 2: {
                        if (north && south || east && west) {
                            return DungeonSegmentModelRegistry.CORRIDOR_EW;
                        }
                        return DungeonSegmentModelRegistry.CORRIDOR_EW_TURN;
                    }
                    case 3: {
                        return DungeonSegmentModelRegistry.CORRIDOR_EW_OPEN;
                    }
                    case 4: {
                        return DungeonSegmentModelRegistry.CORRIDOR_EW_ALL_OPEN;
                    }
                }
                return null;
            }
            case 1: {
                return DungeonSegmentModelRegistry.STAIRS_BOTTOM;
            }
            case 2: {
                return DungeonSegmentModelRegistry.STAIRS;
            }
            case 3: {
                return DungeonSegmentModelRegistry.STAIRS_TOP;
            }
            case 5: {
                return DungeonSegmentModelRegistry.ROOM;
            }
        }
        return null;
    }
}

