/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.segment;

import java.util.Random;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlockType;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelFourWayBlock;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelTrapDoorBlock;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.RotationHelper;

public class DungeonSegmentModelBlock {
    public DungeonSegmentModelBlockType type;
    public Direction facing;
    public Boolean upsideDown;

    public DungeonSegmentModelBlock(DungeonSegmentModelBlockType type) {
        this.type = type;
    }

    public DungeonSegmentModelBlock(DungeonSegmentModelBlockType type, Direction facing, boolean upsideDown) {
        if (facing == null && !upsideDown) {
            this.type = type;
            return;
        }
        this.type = type;
        this.facing = facing;
        this.upsideDown = upsideDown;
    }

    public static BlockState getBlockState(DungeonSegmentModelBlock block, Theme theme, Random rand) {
        if (block == null || block.type == null) {
            return Blocks.field_201941_jj.func_176223_P();
        }
        switch (block.type) {
            case NONE: {
                return null;
            }
            case WOOD: {
                return Blocks.field_196662_n.func_176223_P();
            }
            case WATER: {
                return Blocks.field_150355_j.func_176223_P();
            }
            case LAVA: {
                return Blocks.field_150353_l.func_176223_P();
            }
            case IRON_BARS: {
                DungeonSegmentModelFourWayBlock fwb = (DungeonSegmentModelFourWayBlock)block;
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(fwb.north))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(fwb.east))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(fwb.south))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(fwb.west))).func_206870_a((IProperty)FourWayBlock.field_204514_u, (Comparable)Boolean.valueOf(fwb.waterlogged));
            }
            case CEILING: {
                return theme.ceiling.get();
            }
            case CEILING_STAIRS: {
                return (BlockState)((BlockState)theme.ceilingStairs.get().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)block.facing)).func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)(block.upsideDown != false ? Half.TOP : Half.BOTTOM));
            }
            case CHEST_COMMON: {
                return (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)block.facing);
            }
            case FLOOR: {
                return theme.floor.get();
            }
            case FLOOR_STAIRS: {
                return (BlockState)((BlockState)theme.floorStairs.get().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)block.facing)).func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)(block.upsideDown != false ? Half.TOP : Half.BOTTOM));
            }
            case TORCH_DARK: {
                return (BlockState)theme.torchDark.get().func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)block.facing);
            }
            case OTHER: {
                return null;
            }
            case RAND_FLOOR_CHESTCOMMON_SPAWNER: {
                int i = rand.nextInt(10);
                if (i < 2) {
                    return BlockRegistry.SPAWNER;
                }
                if (i == 5) {
                    return (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)block.facing);
                }
                return theme.floor.get();
            }
            case SPAWNER: {
                return BlockRegistry.SPAWNER;
            }
            case STAIRS: {
                return (BlockState)((BlockState)theme.stairs.get().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)block.facing)).func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)(block.upsideDown != false ? Half.TOP : Half.BOTTOM));
            }
            case WALL: {
                return theme.wall.get();
            }
            case WALL_LOG: {
                return (BlockState)theme.wallLog.get().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y);
            }
            case BARREL: {
                return (BlockState)Blocks.field_222422_lK.func_176223_P().func_206870_a((IProperty)BarrelBlock.field_220092_a, (Comparable)block.facing);
            }
            case ANVIL: {
                return (BlockState)Blocks.field_150467_bQ.func_176223_P().func_206870_a((IProperty)AnvilBlock.field_176506_a, (Comparable)block.facing);
            }
        }
        if (block instanceof DungeonSegmentModelTrapDoorBlock) {
            return (BlockState)((BlockState)((BlockState)theme.trapDoorDecoration.get().func_206870_a((IProperty)TrapDoorBlock.field_176283_b, (Comparable)Boolean.valueOf(((DungeonSegmentModelTrapDoorBlock)block).open))).func_206870_a((IProperty)TrapDoorBlock.field_176285_M, (Comparable)(block.upsideDown != false ? Half.TOP : Half.BOTTOM))).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)block.facing);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static BlockState getBlockState(DungeonSegmentModelBlock block, Theme theme, Random rand, Rotation rotation) {
        if (block == null || block.type == null) {
            return Blocks.field_201941_jj.func_176223_P();
        }
        switch (block.type) {
            case NONE: {
                return null;
            }
            case WOOD: {
                return Blocks.field_196662_n.func_176223_P();
            }
            case WATER: {
                return Blocks.field_150355_j.func_176223_P();
            }
            case LAVA: {
                return Blocks.field_150353_l.func_176223_P();
            }
            case IRON_BARS: {
                return RotationHelper.tanslateFourWayBlock(DungeonSegmentModelBlock.getBlockState(block, theme, rand), rotation);
            }
            case CEILING: {
                return theme.ceiling.get();
            }
            case CEILING_STAIRS: {
                return (BlockState)((BlockState)theme.ceilingStairs.get().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)RotationHelper.translateDirection(block.facing, rotation))).func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)(block.upsideDown != false ? Half.TOP : Half.BOTTOM));
            }
            case CHEST_COMMON: {
                return (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)block.facing);
            }
            case FLOOR: {
                return theme.floor.get();
            }
            case FLOOR_STAIRS: {
                return (BlockState)((BlockState)theme.floorStairs.get().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)RotationHelper.translateDirection(block.facing, rotation))).func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)(block.upsideDown != false ? Half.TOP : Half.BOTTOM));
            }
            case TORCH_DARK: {
                return (BlockState)theme.torchDark.get().func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)RotationHelper.translateDirection(block.facing, rotation));
            }
            case OTHER: {
                return null;
            }
            case RAND_FLOOR_CHESTCOMMON_SPAWNER: {
                int i = rand.nextInt(10);
                if (i < 2) {
                    return BlockRegistry.SPAWNER;
                }
                if (i == 5) {
                    return (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)RotationHelper.translateDirection(block.facing, rotation));
                }
                return theme.floor.get();
            }
            case SPAWNER: {
                return BlockRegistry.SPAWNER;
            }
            case STAIRS: {
                return (BlockState)((BlockState)theme.stairs.get().func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)RotationHelper.translateDirection(block.facing, rotation))).func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)(block.upsideDown != false ? Half.TOP : Half.BOTTOM));
            }
            case WALL: {
                return theme.wall.get();
            }
            case WALL_LOG: {
                return (BlockState)theme.wallLog.get().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y);
            }
            case BARREL: {
                return (BlockState)Blocks.field_222422_lK.func_176223_P().func_206870_a((IProperty)BarrelBlock.field_220092_a, (Comparable)RotationHelper.translateDirection(block.facing, rotation));
            }
            case ANVIL: {
                return (BlockState)Blocks.field_150467_bQ.func_176223_P().func_206870_a((IProperty)AnvilBlock.field_176506_a, (Comparable)RotationHelper.translateDirection(block.facing, rotation));
            }
        }
        if (block instanceof DungeonSegmentModelTrapDoorBlock) {
            return (BlockState)((BlockState)((BlockState)theme.trapDoorDecoration.get().func_206870_a((IProperty)TrapDoorBlock.field_176283_b, (Comparable)Boolean.valueOf(((DungeonSegmentModelTrapDoorBlock)block).open))).func_206870_a((IProperty)TrapDoorBlock.field_176285_M, (Comparable)(block.upsideDown != false ? Half.TOP : Half.BOTTOM))).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)RotationHelper.translateDirection(block.facing, rotation));
        }
        return Blocks.field_150350_a.func_176223_P();
    }
}

