/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ServerWorld;
import net.minecraft.world.World;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModel;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlock;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelBlockType;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelFourWayBlock;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModelTrapDoorBlock;

public class DungeonSegmentModelReader {
    public static void readModelToFile(World world, BlockPos pos, int width, int height, int length) {
        int fwb = 0;
        int td = 0;
        DungeonSegmentModelFourWayBlock[] fourWayBlocks = new DungeonSegmentModelFourWayBlock[64];
        DungeonSegmentModelTrapDoorBlock[] trapDoors = new DungeonSegmentModelTrapDoorBlock[16];
        DungeonSegmentModelBlock[][][] model = new DungeonSegmentModelBlock[width][height][length];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    BlockState state = world.func_180495_p(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z));
                    if (state.func_177230_c() == Blocks.field_150350_a) {
                        model[x][y][z] = null;
                        continue;
                    }
                    if (state.func_177230_c() instanceof TrapDoorBlock) {
                        model[x][y][z] = new DungeonSegmentModelBlock(DungeonSegmentModelBlockType.TRAPDOOR, Direction.NORTH, false);
                        trapDoors[td++] = new DungeonSegmentModelTrapDoorBlock(DungeonSegmentModelBlockType.get(state.func_177230_c()), (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J), (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208193_t), (Half)state.func_177229_b((IProperty)BlockStateProperties.field_208164_Q), state.func_177229_b((IProperty)BlockStateProperties.field_208164_Q) == Half.TOP);
                        continue;
                    }
                    if (state.func_177230_c() instanceof FourWayBlock) {
                        model[x][y][z] = new DungeonSegmentModelBlock(DungeonSegmentModelBlockType.FWB_PLACEHOLDER, Direction.NORTH, false);
                        fourWayBlocks[fwb++] = new DungeonSegmentModelFourWayBlock(DungeonSegmentModelBlockType.get(state.func_177230_c()), (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208151_D), (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208152_E), (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208153_F), (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208154_G), (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y));
                        continue;
                    }
                    model[x][y][z] = new DungeonSegmentModelBlock(DungeonSegmentModelBlockType.get(state.func_177230_c()), (Direction)(state.func_196959_b((IProperty)BlockStateProperties.field_208155_H) ? (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H) : (state.func_196959_b((IProperty)BlockStateProperties.field_208157_J) ? (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J) : null)), state.func_196959_b((IProperty)BlockStateProperties.field_208164_Q) ? state.func_177229_b((IProperty)BlockStateProperties.field_208164_Q) == Half.TOP : false);
                }
            }
        }
        DungeonSegmentModelReader.writeModelToFile(new DungeonSegmentModel(model, trapDoors, fourWayBlocks), new File(((ServerWorld)world).func_217485_w().func_75765_b(), "model_" + System.currentTimeMillis() + ".json"));
    }

    public static String readModelToArrayString(World world, BlockPos pos, int width, int length, int height) {
        String array = "";
        array = array + "new DungeonSegmentModelBlock[][][] { ";
        for (int x = 0; x < width; ++x) {
            array = array + "{ ";
            for (int y = 0; y < height; ++y) {
                array = array + "{ ";
                for (int z = 0; z < length; ++z) {
                    Direction direction;
                    BlockState state = world.func_180495_p(new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z));
                    if (state.func_177230_c() instanceof TrapDoorBlock) {
                        direction = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
                        boolean open = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208193_t);
                        boolean upsideDown = state.func_177229_b((IProperty)BlockStateProperties.field_208164_Q) == Half.TOP;
                        array = array + (Object)((Object)DungeonSegmentModelBlockType.get(state.func_177230_c()));
                        if (!open) {
                            array = array + "_CLOSED";
                        }
                        if (direction != null) {
                            array = array + "_" + direction.toString().toUpperCase();
                        }
                        if (upsideDown) {
                            array = array + "_UD";
                        }
                        if (z + 1 >= length) continue;
                        array = array + ", ";
                        continue;
                    }
                    if (state.func_177230_c() instanceof FourWayBlock) {
                        array = array + (Object)((Object)DungeonSegmentModelBlockType.get(state.func_177230_c()));
                        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208151_D)).booleanValue()) {
                            array = array + "_NORTH";
                        }
                        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208152_E)).booleanValue()) {
                            array = array + "_EAST";
                        }
                        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208153_F)).booleanValue()) {
                            array = array + "_SOUTH";
                        }
                        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208154_G)).booleanValue()) {
                            array = array + "_WEST";
                        }
                        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
                            array = array + "_WATERLOGGED";
                        }
                        if (z + 1 >= length) continue;
                        array = array + ", ";
                        continue;
                    }
                    Object object = state.func_196959_b((IProperty)BlockStateProperties.field_208155_H) ? (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H) : (direction = state.func_196959_b((IProperty)BlockStateProperties.field_208157_J) ? (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J) : null);
                    boolean upsideDown = state.func_196959_b((IProperty)BlockStateProperties.field_208164_Q) ? state.func_177229_b((IProperty)BlockStateProperties.field_208164_Q) == Half.TOP : false;
                    array = array + (Object)((Object)DungeonSegmentModelBlockType.get(state.func_177230_c()));
                    if (direction != null) {
                        array = array + "_" + direction.toString().toUpperCase();
                    }
                    if (upsideDown) {
                        array = array + "_UD";
                    }
                    if (z + 1 >= length) continue;
                    array = array + ", ";
                }
                array = array + " }";
                if (y + 1 >= height) continue;
                array = array + ", ";
            }
            array = array + " }";
            if (x + 1 >= width) continue;
            array = array + ", ";
        }
        array = array + " }";
        return array;
    }

    public static void writeModelToFile(DungeonSegmentModel model, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            DungeonCrawl.GSON.toJson((Object)model, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DungeonSegmentModel readModelFromFile(File file) {
        DungeonCrawl.LOGGER.info("Loading model from file " + file.getAbsolutePath());
        try {
            FileReader reader = new FileReader(file);
            return (DungeonSegmentModel)DungeonCrawl.GSON.fromJson((Reader)reader, DungeonSegmentModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DungeonSegmentModel readModelFromInputStream(InputStream input) {
        try {
            InputStreamReader reader = new InputStreamReader(input);
            return (DungeonSegmentModel)DungeonCrawl.GSON.fromJson((Reader)reader, DungeonSegmentModel.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

