/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.part.block;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Tuple;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.util.IBlockStateProvider;
import xiroc.dungeoncrawl.util.IRandom;

public class WeightedRandomBlock
implements IRandom<BlockState>,
IBlockStateProvider {
    private final int totalWeight;
    private final BlockRegistry.TupleFloatBlock[] map;

    public WeightedRandomBlock(Tuple<Integer, BlockState>[] entries) {
        int weight = 0;
        for (Tuple<Integer, BlockState> entry : entries) {
            weight += ((Integer)entry.func_76341_a()).intValue();
        }
        this.totalWeight = weight;
        this.map = new BlockRegistry.TupleFloatBlock[entries.length];
        this.assign(entries);
    }

    private void assign(Tuple<Integer, BlockState>[] values) {
        float f = 0.0f;
        int i = 0;
        for (Tuple<Integer, BlockState> entry : values) {
            float weight = (float)((Integer)entry.func_76341_a()).intValue() / (float)this.totalWeight;
            this.map[i] = new BlockRegistry.TupleFloatBlock(Float.valueOf(weight + f), (BlockState)entry.func_76340_b());
            f += weight;
            ++i;
        }
    }

    @Override
    public BlockState roll(Random rand) {
        float f = rand.nextFloat();
        for (BlockRegistry.TupleFloatBlock entry : this.map) {
            if (!(((Float)entry.func_76341_a()).floatValue() >= f)) continue;
            return (BlockState)entry.func_76340_b();
        }
        return null;
    }

    @Override
    public BlockState get() {
        return this.roll(new Random());
    }
}

