/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl;

import com.google.common.collect.Lists;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.command.SpawnDungeonCommand;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.init.ModStructures;
import xiroc.dungeoncrawl.util.ResourceReloadHandler;
import xiroc.dungeoncrawl.util.tools.Tools;

@Mod(value="dungeoncrawl")
public class DungeonCrawl {
    public static final String MOD_ID = "dungeoncrawl";
    public static final String NAME = "Dungeon Crawl";
    public static final String VERSION = "2.3.3";
    public static final Logger LOGGER = LogManager.getLogger((String)"Dungeon Crawl");
    public static final JsonParser JSON_PARSER = new JsonParser();

    public DungeonCrawl() {
        LOGGER.info("Here we go! Launching Dungeon Crawl {}...", (Object)VERSION);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(this::onAddReloadListener);
        forgeEventBus.addListener(this::onWorldLoad);
        forgeEventBus.addListener(this::onServerStarting);
        this.init();
    }

    private void init() {
        ModStructures.init();
        Loot.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup");
        Config.load(FMLPaths.CONFIGDIR.get().resolve("dungeon_crawl.toml"));
        if (((Boolean)Config.ENABLE_TOOLS.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)new Tools());
        }
        event.enqueueWork(() -> {
            StructurePieceTypes.register();
            ModStructures.register();
        });
    }

    private void onServerStarting(FMLServerStartingEvent event) {
        SpawnDungeonCommand.register((CommandDispatcher<CommandSourceStack>)event.getServer().m_129892_().m_82094_());
    }

    private void onWorldLoad(WorldEvent.Load event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor;
        if (((Boolean)Config.PRINT_BIOME_CATEGORIES.get()).booleanValue() && (levelAccessor = event.getWorld()) instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_().equals((Object)Level.f_46428_)) {
            HashMap<String, List> biomes = new HashMap<String, List>();
            ForgeRegistries.BIOMES.getEntries().forEach(entry -> {
                ResourceLocation registryName = ((Biome)entry.getValue()).getRegistryName();
                if (registryName != null) {
                    biomes.computeIfAbsent(((Biome)entry.getValue()).m_47567_().m_47645_(), key -> Lists.newArrayList()).add(registryName.toString());
                }
            });
            biomes.forEach((key, value) -> {
                LOGGER.info("Biome Category '{}' contains the following biomes:", key);
                value.forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
            });
        }
    }

    private void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ResourceReloadHandler());
    }

    public static ResourceLocation locate(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation key(ResourceLocation resourceLocation, String baseDirectory, String fileEnding) {
        String path = resourceLocation.m_135815_();
        return new ResourceLocation(resourceLocation.m_135827_(), path.substring(baseDirectory.length() + 1, path.length() - fileEnding.length()));
    }
}

