/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.block;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.dungeon.monster.RandomMonster;
import xiroc.dungeoncrawl.dungeon.monster.RandomPotionEffect;
import xiroc.dungeoncrawl.dungeon.monster.SpawnRates;
import xiroc.dungeoncrawl.dungeon.treasure.RandomItems;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.Range;

public class Spawner
implements IBlockPlacementHandler {
    public static final Set<EntityType<?>> INVENTORY_ENTITIES = ImmutableSet.builder().add((Object)EntityType.f_20501_).add((Object)EntityType.f_20524_).add((Object)EntityType.f_20458_).add((Object)EntityType.f_20481_).add((Object)EntityType.f_20497_).build();
    public static final Set<EntityType<?>> RANGED_INVENTORY_ENTITIES = ImmutableSet.builder().add((Object)EntityType.f_20524_).add((Object)EntityType.f_20481_).build();

    @Override
    public void place(LevelAccessor world, BlockState state, BlockPos pos, Random rand, Theme theme, Theme.SecondaryTheme secondaryTheme, int stage, boolean worldGen) {
        BlockEntity tile;
        world.m_7731_(pos, Blocks.f_50085_.m_49966_(), 2);
        BlockEntity blockEntity = tile = world.m_7702_(pos);
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
            EntityType<?> type = RandomMonster.randomMonster(rand, stage);
            spawner.m_59801_().m_45462_(type);
            if (((Boolean)Config.CUSTOM_SPAWNERS.get()).booleanValue() && INVENTORY_ENTITIES.contains(type)) {
                CompoundTag spawnerNBT = spawner.m_59801_().m_151339_(spawner.m_58904_(), pos, new CompoundTag());
                ListTag potentialSpawns = new ListTag();
                for (int i = 0; i < (Integer)Config.SPAWNER_ENTITIES.get(); ++i) {
                    CompoundTag nbt = new CompoundTag();
                    CompoundTag spawnData = Spawner.createSpawnData(type, null, rand, stage);
                    nbt.m_128365_("Entity", (Tag)spawnData);
                    nbt.m_128405_("Weight", 1);
                    if (i == 0) {
                        spawnerNBT.m_128365_("SpawnData", (Tag)spawnData);
                    }
                    potentialSpawns.add((Object)nbt);
                }
                Range delay = SpawnRates.getDelay(stage);
                spawnerNBT.m_128365_("SpawnPotentials", (Tag)potentialSpawns);
                spawnerNBT.m_128376_("MinSpawnDelay", (short)delay.min());
                spawnerNBT.m_128376_("MaxSpawnDelay", (short)delay.max());
                spawnerNBT.m_128376_("SpawnCount", (short)SpawnRates.getAmount(stage).nextInt(rand));
                spawnerNBT.m_128376_("RequiredPlayerRange", ((Integer)Config.SPAWNER_RANGE.get()).shortValue());
                spawner.m_59801_().m_151328_(spawner.m_58904_(), pos, spawnerNBT);
            }
        } else {
            DungeonCrawl.LOGGER.error("Failed to fetch a mob spawner at ({}, {}, {})", (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
    }

    public static CompoundTag createSpawnData(@Nullable EntityType<?> type, @Nullable CompoundTag spawnData, Random rand, int stage) {
        ResourceLocation registryName;
        if (type == null) {
            type = RandomMonster.randomMonster(rand, stage);
        }
        if (spawnData == null) {
            spawnData = new CompoundTag();
        }
        if ((registryName = type.getRegistryName()) == null) {
            DungeonCrawl.LOGGER.warn("Entity type {} has no registry name.", type);
            return new CompoundTag();
        }
        spawnData.m_128359_("id", registryName.toString());
        if (INVENTORY_ENTITIES.contains(type)) {
            ListTag potionEffects;
            ItemStack mainHand;
            ItemStack[] armor = RandomEquipment.createArmor(rand, stage);
            ListTag armorList = new ListTag();
            for (ItemStack stack : armor) {
                armorList.add((Object)stack.m_41739_(new CompoundTag()));
            }
            if (armorList.size() > 0) {
                spawnData.m_128365_("ArmorItems", (Tag)armorList);
            }
            ListTag handItems = new ListTag();
            ItemStack itemStack = mainHand = RANGED_INVENTORY_ENTITIES.contains(type) ? RandomEquipment.getRangedWeapon(DungeonBlocks.RANDOM, stage) : RandomEquipment.getMeleeWeapon(DungeonBlocks.RANDOM, stage);
            if (mainHand != ItemStack.f_41583_) {
                handItems.add((Object)mainHand.m_41739_(new CompoundTag()));
            }
            handItems.add((Object)(rand.nextDouble() < 0.25 ? RandomItems.createShield(rand, stage).m_41739_(new CompoundTag()) : ItemStack.f_41583_.m_41739_(new CompoundTag())));
            spawnData.m_128365_("HandItems", (Tag)handItems);
            if (!((Boolean)Config.NATURAL_DESPAWN.get()).booleanValue()) {
                spawnData.m_128379_("PersistenceRequired", true);
            }
            if ((potionEffects = RandomPotionEffect.createPotionEffects(rand, stage)) != null) {
                spawnData.m_128365_("ActiveEffects", (Tag)potionEffects);
            }
        }
        if (((Boolean)Config.OVERWRITE_ENTITY_LOOT_TABLES.get()).booleanValue() && RandomMonster.NBT_PATCHERS.containsKey(type)) {
            RandomMonster.NBT_PATCHERS.get(type).patch(spawnData, rand, stage);
        }
        return spawnData;
    }
}

