/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.theme.Theme;

public class PlacementBehaviour {
    public static final PlacementBehaviour NON_SOLID = new PlacementBehaviour((world, pos, rand) -> false);
    public static final PlacementBehaviour SOLID = new PlacementBehaviour((world, pos, rand) -> true);
    public static final PlacementBehaviour RANDOM_IF_SOLID_NEARBY = new PlacementBehaviour((world, pos, rand) -> {
        if (PlacementBehaviour.isSolid(world, pos.m_142127_()) || PlacementBehaviour.isSolid(world, pos.m_142126_()) || PlacementBehaviour.isSolid(world, pos.m_142128_()) || PlacementBehaviour.isSolid(world, pos.m_142125_())) {
            return rand.nextFloat() < 0.6f;
        }
        return false;
    });
    private final PlacementFunction function;
    @Nullable
    public final BiFunction<Theme, Theme.SecondaryTheme, BlockStateProvider> airBlock;

    public PlacementBehaviour(PlacementFunction function) {
        this(function, null);
    }

    public PlacementBehaviour(PlacementFunction function, BiFunction<Theme, Theme.SecondaryTheme, BlockStateProvider> airBlock) {
        this.function = function;
        this.airBlock = airBlock;
    }

    public PlacementBehaviour withAirBlock(BiFunction<Theme, Theme.SecondaryTheme, BlockStateProvider> airBlock) {
        return new PlacementBehaviour(this.function, airBlock);
    }

    public boolean isSolid(LevelAccessor world, BlockPos pos, Random rand) {
        return this.function.isSolid(world, pos, rand);
    }

    private static boolean isSolid(LevelAccessor world, BlockPos pos) {
        if (world.m_7232_(pos.m_123341_() >> 4, pos.m_123343_() >> 4)) {
            return world.m_8055_(pos).m_60815_() || world.m_8055_(pos.m_7495_()).m_60815_();
        }
        return false;
    }

    public static interface PlacementFunction {
        public boolean isSolid(LevelAccessor var1, BlockPos var2, Random var3);
    }
}

