/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public class DungeonEntrance
extends DungeonPiece {
    public DungeonEntrance() {
        super(StructurePieceTypes.ENTRANCE);
    }

    public DungeonEntrance(ServerLevel serverLevel, CompoundTag nbt) {
        super(StructurePieceTypes.ENTRANCE, nbt);
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, Random rand) {
    }

    public boolean m_7832_(WorldGenLevel worldIn, StructureFeatureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, BoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        int cursorHeight;
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for {}", (Object)this);
            return true;
        }
        Heightmap.Types heightmapType = this.worldGen ? Heightmap.Types.WORLD_SURFACE_WG : Heightmap.Types.WORLD_SURFACE;
        int height = worldIn.m_6924_(heightmapType, this.x + 4, this.z + 4);
        DungeonModel staircaseLayer = DungeonModels.KEY_TO_MODEL.get(DungeonModels.STAIRCASE_LAYER);
        Rotation layerRotation = Rotation.NONE;
        for (cursorHeight = this.y; cursorHeight < height; ++cursorHeight) {
            this.buildRotated(staircaseLayer, (LevelAccessor)worldIn, structureBoundingBoxIn, new BlockPos(this.x + 2, cursorHeight, this.z + 2), this.theme, this.secondaryTheme, this.stage, layerRotation, this.worldGen, true, false);
            layerRotation = layerRotation.m_55952_(Rotation.CLOCKWISE_90);
        }
        BlockPos pos = new BlockPos(this.x + 4, cursorHeight, this.z + 4).m_141952_(DungeonEntrance.rotatedOffset(this.model.getOffset(), layerRotation, this.model));
        this.buildRotated(this.model, (LevelAccessor)worldIn, structureBoundingBoxIn, pos, this.theme, this.secondaryTheme, this.stage, layerRotation, this.worldGen, true, true);
        this.placeFeatures((LevelAccessor)worldIn, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage, this.worldGen);
        BoundingBox populationBox = this.model.createBoundingBox(pos, this.f_73379_);
        this.decorate((LevelAccessor)worldIn, pos, this.model.width, this.model.height, this.model.length, this.theme, structureBoundingBoxIn, populationBox, this.model, this.worldGen);
        return true;
    }

    private static Vec3i rotatedOffset(Vec3i offset, Rotation rotation, DungeonModel model) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new Vec3i(-model.length - offset.m_123343_() + 1, offset.m_123342_(), offset.m_123341_());
            case Rotation.CLOCKWISE_180 -> new Vec3i(-model.width - offset.m_123341_() + 1, offset.m_123342_(), -model.length - offset.m_123343_() + 1);
            case Rotation.COUNTERCLOCKWISE_90 -> new Vec3i(offset.m_123343_(), offset.m_123342_(), -model.width - offset.m_123341_() + 1);
            default -> offset;
        };
    }

    @Override
    public void createBoundingBox() {
        if (this.model != null) {
            Vec3i offset = this.model.getOffset(this.f_73379_);
            int x = this.x + 4 + offset.m_123341_();
            int z = this.z + 4 + offset.m_123343_();
            switch (this.f_73379_) {
                case CLOCKWISE_180: 
                case NONE: {
                    this.f_73383_ = new BoundingBox(x, 0, z, x + this.model.width - 1, 256, z + this.model.length - 1);
                    break;
                }
                case CLOCKWISE_90: 
                case COUNTERCLOCKWISE_90: {
                    this.f_73383_ = new BoundingBox(x, 0, z, x + this.model.length - 1, 256, z + this.model.width - 1);
                    break;
                }
                default: {
                    DungeonCrawl.LOGGER.warn("Unknown entrance rotation: {}", (Object)this.f_73379_);
                    this.f_73383_ = new BoundingBox(x, 0, z, x + this.model.width - 1, 256, z + this.model.length - 1);
                }
            }
        }
    }

    @Override
    public int getDungeonPieceType() {
        return 6;
    }
}

