/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.material.FluidState;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonType;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelFeature;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.model.MultipartModelData;
import xiroc.dungeoncrawl.dungeon.model.PlacementBehaviour;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.Position2D;

public abstract class DungeonPiece
extends StructurePiece {
    private static final BoundingBox EMPTY_BOX = new BoundingBox(0, 0, 0, 0, 0, 0);
    public static final int CORRIDOR = 0;
    public static final int STAIRS = 1;
    public static final int ENTRANCE = 6;
    public static final int ROOM = 8;
    public static final int SIDE_ROOM = 9;
    public static final int NODE_ROOM = 10;
    public static final int NODE_CONNECTOR = 11;
    public static final int MEGA_NODE_PART = 12;
    public static final int SECRET_ROOM = 14;
    public static final int SPIDER_ROOM = 15;
    public static final int MULTIPART_PIECE = 16;
    public Rotation f_73379_;
    public int connectedSides;
    public int x;
    public int y;
    public int z;
    public int stage;
    public boolean[] sides = new boolean[4];
    @Nullable
    public DungeonModelFeature.Instance[] features;
    public byte[] variation;
    public DungeonModel model;
    public Theme theme;
    public Theme.SecondaryTheme secondaryTheme;
    public Position2D gridPosition;
    public boolean worldGen = true;

    public DungeonPiece(StructurePieceType p_i51343_1_) {
        super(p_i51343_1_, 0, EMPTY_BOX);
        this.connectedSides = 0;
        this.f_73379_ = Rotation.NONE;
        this.gridPosition = new Position2D(0, 0);
    }

    public DungeonPiece(StructurePieceType p_i51343_1_, CompoundTag p_i51343_2_) {
        super(p_i51343_1_, p_i51343_2_);
        this.sides[0] = p_i51343_2_.m_128471_("north");
        this.sides[1] = p_i51343_2_.m_128471_("east");
        this.sides[2] = p_i51343_2_.m_128471_("south");
        this.sides[3] = p_i51343_2_.m_128471_("west");
        this.connectedSides = p_i51343_2_.m_128451_("connectedSides");
        this.gridPosition = new Position2D(p_i51343_2_.m_128451_("posX"), p_i51343_2_.m_128451_("posZ"));
        this.x = p_i51343_2_.m_128451_("x");
        this.y = p_i51343_2_.m_128451_("y");
        this.z = p_i51343_2_.m_128451_("z");
        this.stage = p_i51343_2_.m_128451_("stage");
        this.f_73379_ = Orientation.getRotation(p_i51343_2_.m_128451_("rotation"));
        this.theme = p_i51343_2_.m_128425_("theme", 99) ? Theme.getThemeByID(p_i51343_2_.m_128451_("theme")) : Theme.getTheme(new ResourceLocation(p_i51343_2_.m_128461_("theme")));
        this.secondaryTheme = p_i51343_2_.m_128425_("subTheme", 99) ? Theme.getSubThemeByID(p_i51343_2_.m_128451_("subTheme")) : Theme.getSecondaryTheme(new ResourceLocation(p_i51343_2_.m_128461_("secondaryTheme")));
        this.model = p_i51343_2_.m_128425_("model", 99) ? DungeonModels.ID_TO_MODEL.get(p_i51343_2_.m_128451_("model")) : DungeonModels.KEY_TO_MODEL.get(new ResourceLocation(p_i51343_2_.m_128461_("model")));
        if (p_i51343_2_.m_128425_("features", 9)) {
            this.features = DungeonPiece.readAllFeatures(p_i51343_2_.m_128437_("features", 10));
        }
        if (p_i51343_2_.m_128441_("variation")) {
            this.variation = p_i51343_2_.m_128463_("variation");
        }
        this.createBoundingBox();
    }

    public void m_142347_(ServerLevel serverLevel, CompoundTag tagCompound) {
        tagCompound.m_128379_("north", this.sides[0]);
        tagCompound.m_128379_("east", this.sides[1]);
        tagCompound.m_128379_("south", this.sides[2]);
        tagCompound.m_128379_("west", this.sides[3]);
        tagCompound.m_128405_("connectedSides", this.connectedSides);
        tagCompound.m_128405_("posX", this.gridPosition.x);
        tagCompound.m_128405_("posZ", this.gridPosition.z);
        tagCompound.m_128405_("x", this.x);
        tagCompound.m_128405_("y", this.y);
        tagCompound.m_128405_("z", this.z);
        tagCompound.m_128405_("stage", this.stage);
        tagCompound.m_128405_("rotation", Orientation.rotationAsInt(this.f_73379_));
        if (this.model != null) {
            tagCompound.m_128359_("model", this.model.getKey().toString());
        }
        if (this.theme != null) {
            tagCompound.m_128359_("theme", this.theme.getKey().toString());
        }
        if (this.secondaryTheme != null) {
            tagCompound.m_128359_("secondaryTheme", this.secondaryTheme.getKey().toString());
        }
        if (this.features != null) {
            ListTag list = new ListTag();
            DungeonPiece.writeAllFeatures(this.features, list);
            tagCompound.m_128365_("features", (Tag)list);
        }
        if (this.variation != null) {
            tagCompound.m_128382_("variation", this.variation);
        }
    }

    public abstract int getDungeonPieceType();

    public abstract void setupModel(DungeonBuilder var1, ModelSelector var2, List<DungeonPiece> var3, Random var4);

    public void createBoundingBox() {
        if (this.model != null) {
            this.f_73383_ = this.model.createBoundingBoxWithOffset(this.x, this.y, this.z, this.f_73379_);
        }
    }

    public void openSide(Direction side) {
        switch (side) {
            case NORTH: {
                if (this.sides[0]) {
                    return;
                }
                this.sides[0] = true;
                ++this.connectedSides;
                break;
            }
            case EAST: {
                if (this.sides[1]) {
                    return;
                }
                this.sides[1] = true;
                ++this.connectedSides;
                break;
            }
            case SOUTH: {
                if (this.sides[2]) {
                    return;
                }
                this.sides[2] = true;
                ++this.connectedSides;
                break;
            }
            case WEST: {
                if (this.sides[3]) {
                    return;
                }
                this.sides[3] = true;
                ++this.connectedSides;
            }
        }
    }

    public void setRotation(Rotation rotation) {
        this.f_73379_ = rotation;
    }

    public Rotation m_6830_() {
        return this.f_73379_;
    }

    public void setGridPosition(int x, int z) {
        this.gridPosition = new Position2D(x, z);
    }

    public void setGridPosition(Position2D position) {
        this.gridPosition = position;
    }

    public void setWorldPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void customSetup(Random rand) {
        if (this.model == null) {
            return;
        }
        if (this.model.hasFeatures()) {
            Vec3i offset = this.model.getOffset(this.f_73379_);
            ArrayList<DungeonModelFeature.Instance> features = new ArrayList<DungeonModelFeature.Instance>();
            for (DungeonModelFeature feature : this.model.getFeatures()) {
                feature.setup(this.model, this.x + offset.m_123341_(), this.y + offset.m_123342_(), this.z + offset.m_123343_(), this.f_73379_, features, rand);
            }
            this.features = features.toArray(new DungeonModelFeature.Instance[0]);
        }
        if (this.model.isVariationEnabled()) {
            this.variation = new byte[8];
            for (int i = 0; i < this.variation.length; ++i) {
                this.variation[i] = (byte)rand.nextInt(64);
            }
        }
    }

    public void takeOverProperties(DungeonPiece piece) {
        this.sides = piece.sides;
        this.connectedSides = piece.connectedSides;
        this.f_73379_ = piece.f_73379_;
    }

    public boolean hasChildPieces() {
        return this.model != null && this.model.hasMultipart();
    }

    public void addChildPieces(List<DungeonPiece> pieces, DungeonBuilder builder, DungeonType type, ModelSelector modelSelector, int layer, Random rand) {
        if (this.model != null && (this.model.hasMultipart() || type.getLayer(layer).hasMultipartOverride(this.model))) {
            BlockPos pos = new BlockPos(this.x, this.y, this.z).m_141952_(this.model.getOffset(this.f_73379_));
            for (MultipartModelData data : type.getLayer(layer).getMultipartData(this.model)) {
                if (data.checkConditions(this)) {
                    pieces.add(data.models.roll(rand).createMultipartPiece(this, this.model, this.f_73379_, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), rand));
                    continue;
                }
                if (data.alternatives == null) continue;
                pieces.add(data.alternatives.roll(rand).createMultipartPiece(this, this.model, this.f_73379_, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), rand));
            }
        }
    }

    public void setBlockState(LevelAccessor world, BlockState state, BlockPos pos, PlacementBehaviour placementBehaviour, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel, boolean worldGen, boolean fillAir) {
        FluidState fluidState;
        BlockEntity tile;
        if (state == null) {
            return;
        }
        if (DungeonBuilder.isBlockProtected(world, pos)) {
            return;
        }
        if (world.m_46859_(pos) && !placementBehaviour.isSolid(world, pos, world.m_5822_())) {
            if (placementBehaviour.airBlock != null) {
                state = placementBehaviour.airBlock.apply(theme, secondaryTheme).get(world, pos);
            } else if (!fillAir && !((Boolean)Config.SOLID.get()).booleanValue()) {
                return;
            }
        }
        Random rand = world.m_5822_();
        IBlockPlacementHandler.getHandler(state.m_60734_()).place(world, state, pos, rand, theme, secondaryTheme, lootLevel, worldGen);
        BlockEntity blockEntity = tile = world.m_7702_(pos);
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity randomizableContainerBlockEntity = (RandomizableContainerBlockEntity)blockEntity;
            if (this.model.hasLootTable()) {
                Loot.setLoot(world, pos, randomizableContainerBlockEntity, this.model.getLootTable(), theme, secondaryTheme, rand);
            } else {
                Loot.setLoot(world, pos, randomizableContainerBlockEntity, Loot.getLootTable(this.stage, rand), theme, secondaryTheme, rand);
            }
        }
        if (!(fluidState = world.m_6425_(pos)).m_76178_()) {
            world.m_6217_().m_5945_(pos, (Object)fluidState.m_76152_(), 0);
        }
    }

    public void replaceBlockState(LevelAccessor worldIn, BlockState blockState, int x, int y, int z, BoundingBox bounds, boolean postProcessing) {
        BlockPos blockPos = new BlockPos(x, y, z);
        if (bounds.m_71051_((Vec3i)blockPos)) {
            FluidState fluidstate;
            if (DungeonBuilder.isBlockProtected(worldIn, blockPos) || worldIn.m_46859_(blockPos)) {
                return;
            }
            worldIn.m_7731_(blockPos, blockState, 2);
            if (postProcessing) {
                worldIn.m_46865_(blockPos).m_8113_(blockPos);
            }
            if (!(fluidstate = worldIn.m_6425_(blockPos)).m_76178_()) {
                worldIn.m_6217_().m_5945_(blockPos, (Object)fluidstate.m_76152_(), 0);
            }
        }
    }

    private void buildModelBlock(LevelAccessor world, BlockPos position, BlockState state, DungeonModelBlock block, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel, boolean worldGen, boolean fillAir, boolean expandDownwards) {
        if (state == null) {
            return;
        }
        this.placeBlock(world, state, position, block, theme, secondaryTheme, lootLevel, fillAir, worldGen);
        if (block.type == DungeonModelBlockType.PILLAR) {
            this.tryBuildFancyPillarPart(world, block, position);
        }
        if (expandDownwards && block.position.m_123342_() == 0 && !world.m_8055_(position.m_7495_()).m_60815_()) {
            this.buildPillar(world, position.m_7495_());
        }
    }

    public void build(DungeonModel model, LevelAccessor world, BoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel, boolean worldGen, boolean fillAir, boolean expandDownwards) {
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Building {} at ({} | {} | {})", (Object)model.getKey(), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
        model.blocks.forEach(block -> {
            BlockPos position = pos.m_141952_(block.position);
            if (boundsIn.m_71051_((Vec3i)position)) {
                BlockState state = block.type.blockFactory.get((DungeonModelBlock)block, Rotation.NONE, world, position, theme, secondaryTheme, world.m_5822_(), this.variation, this.stage);
                this.buildModelBlock(world, position, state, (DungeonModelBlock)block, theme, secondaryTheme, lootLevel, worldGen, fillAir, expandDownwards);
            }
        });
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Finished building {} at ({} | {} | {})", (Object)model.getKey(), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
    }

    public void buildRotated(DungeonModel model, LevelAccessor world, BoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel, Rotation rotation, boolean worldGen, boolean fillAir, boolean expandDownwards) {
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Building {} with rotation {} at ({} | {} | {})", (Object)model.getKey(), (Object)rotation, (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                model.blocks.forEach(block -> {
                    BlockPos position = new BlockPos(pos.m_123341_() + model.length - block.position.m_123343_() - 1, pos.m_123342_() + block.position.m_123342_(), pos.m_123343_() + block.position.m_123341_());
                    if (boundsIn.m_71051_((Vec3i)position)) {
                        BlockState state = block.type.blockFactory.get((DungeonModelBlock)block, Rotation.CLOCKWISE_90, world, position, theme, secondaryTheme, world.m_5822_(), this.variation, this.stage);
                        this.buildModelBlock(world, position, state, (DungeonModelBlock)block, theme, secondaryTheme, lootLevel, worldGen, fillAir, expandDownwards);
                    }
                });
                break;
            }
            case COUNTERCLOCKWISE_90: {
                model.blocks.forEach(block -> {
                    BlockPos position = new BlockPos(pos.m_123341_() + block.position.m_123343_(), pos.m_123342_() + block.position.m_123342_(), pos.m_123343_() + model.width - block.position.m_123341_() - 1);
                    if (boundsIn.m_71051_((Vec3i)position)) {
                        BlockState state = block.type.blockFactory.get((DungeonModelBlock)block, Rotation.COUNTERCLOCKWISE_90, world, position, theme, secondaryTheme, world.m_5822_(), this.variation, this.stage);
                        this.buildModelBlock(world, position, state, (DungeonModelBlock)block, theme, secondaryTheme, lootLevel, worldGen, fillAir, expandDownwards);
                    }
                });
                break;
            }
            case CLOCKWISE_180: {
                model.blocks.forEach(block -> {
                    BlockPos position = new BlockPos(pos.m_123341_() + model.width - block.position.m_123341_() - 1, pos.m_123342_() + block.position.m_123342_(), pos.m_123343_() + model.length - block.position.m_123343_() - 1);
                    if (boundsIn.m_71051_((Vec3i)position)) {
                        BlockState state = block.type.blockFactory.get((DungeonModelBlock)block, Rotation.CLOCKWISE_180, world, position, theme, secondaryTheme, world.m_5822_(), this.variation, this.stage);
                        this.buildModelBlock(world, position, state, (DungeonModelBlock)block, theme, secondaryTheme, lootLevel, worldGen, fillAir, expandDownwards);
                    }
                });
                break;
            }
            case NONE: {
                this.build(model, world, boundsIn, pos, theme, secondaryTheme, lootLevel, worldGen, fillAir, expandDownwards);
                break;
            }
            default: {
                DungeonCrawl.LOGGER.warn("Failed to build a rotated dungeon segment: Unsupported rotation " + rotation);
            }
        }
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Finished building {} with rotation {} at ({} | {} | {})", (Object)model.getKey(), (Object)rotation, (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
    }

    public void placeBlock(LevelAccessor world, BlockState state, BlockPos position, DungeonModelBlock block, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel, boolean fillAir, boolean worldGen) {
        this.setBlockState(world, state, position, block.type.placementBehavior, theme, secondaryTheme, lootLevel, worldGen, fillAir);
        if (block.hasProperties && worldGen) {
            world.m_46865_(position).m_8113_(position);
        }
    }

    protected void tryBuildFancyPillarPart(LevelAccessor world, DungeonModelBlock block, BlockPos blockPos) {
        BlockPos pos;
        if (world.m_8055_(blockPos).m_60815_() && !world.m_8055_(pos = blockPos.m_6625_(block.position.m_123342_() + 1)).m_60815_() && block.position.m_123342_() == 0) {
            this.buildPillar(world, pos);
        }
    }

    protected void buildPillar(LevelAccessor world, BlockPos pos) {
        while (pos.m_123342_() > 0) {
            if (world.m_8055_(pos).m_60815_()) {
                return;
            }
            world.m_7731_(pos, this.theme.solid.get(world, pos), 2);
            pos = pos.m_7495_();
        }
    }

    protected void buildFancyPillarPart(LevelAccessor world, BlockPos pos) {
        int x = pos.m_123341_() % 3;
        int z = pos.m_123343_() % 4;
        if (x == 0) {
            switch (z) {
                case 0: {
                    this.buildPillar(world, pos);
                    break;
                }
                case -2: 
                case 1: {
                    BlockState stair = DungeonBlocks.applyProperty(this.theme.solidStairs.get(world, pos), BlockStateProperties.f_61374_, Direction.NORTH);
                    stair = DungeonBlocks.applyProperty(stair, BlockStateProperties.f_61402_, Half.TOP);
                    world.m_7731_(pos, stair, 2);
                    break;
                }
                case -1: 
                case 2: {
                    BlockState stair = DungeonBlocks.applyProperty(this.theme.solidStairs.get(world, pos), BlockStateProperties.f_61374_, Direction.SOUTH);
                    stair = DungeonBlocks.applyProperty(stair, BlockStateProperties.f_61402_, Half.TOP);
                    world.m_7731_(pos, stair, 2);
                }
            }
        } else if (z == 0) {
            BlockState stair = x == 1 || x == -2 ? DungeonBlocks.applyProperty(this.theme.solidStairs.get(world, pos), BlockStateProperties.f_61374_, Direction.WEST) : DungeonBlocks.applyProperty(this.theme.solidStairs.get(world, pos), BlockStateProperties.f_61374_, Direction.EAST);
            stair = DungeonBlocks.applyProperty(stair, BlockStateProperties.f_61402_, Half.TOP);
            world.m_7731_(pos, stair, 2);
        }
    }

    protected void entrances(LevelAccessor world, BoundingBox bounds, DungeonModel model, boolean worldGen) {
        BlockState stair2;
        BlockPos pos2;
        BlockState stair1;
        BlockPos pos1;
        BlockStateProvider stateProvider;
        int pathStartX = (model.width - 3) / 2;
        int pathStartZ = (model.length - 3) / 2;
        Vec3i offset = model.getOffset(this.f_73379_);
        BlockPos pos = new BlockPos(this.x + offset.m_123341_(), this.y, this.z + offset.m_123343_());
        if (this.sides[0]) {
            for (int x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                this.replaceBlockState(world, f_73382_, pos.m_123341_() + x0, pos.m_123342_() + 1, pos.m_123343_(), bounds, worldGen);
                this.replaceBlockState(world, f_73382_, pos.m_123341_() + x0, pos.m_123342_() + 2, pos.m_123343_(), bounds, worldGen);
            }
            this.replaceBlockState(world, f_73382_, pos.m_123341_() + pathStartX + 1, pos.m_123342_() + 3, pos.m_123343_(), bounds, worldGen);
            stateProvider = model.getEntranceType() == 0 ? this.theme.stairs : this.secondaryTheme.stairs;
            pos1 = new BlockPos(pos.m_123341_() + pathStartX, pos.m_123342_() + 3, pos.m_123343_());
            stair1 = stateProvider.get(world, pos1);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.f_61374_, Direction.WEST);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.f_61402_, Half.TOP);
            this.replaceBlockState(world, stair1, pos1.m_123341_(), pos1.m_123342_(), pos1.m_123343_(), bounds, worldGen);
            pos2 = pos1.m_5484_(Direction.EAST, 2);
            stair2 = stateProvider.get(world, pos2);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.f_61374_, Direction.EAST);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.f_61402_, Half.TOP);
            this.replaceBlockState(world, stair2, pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_(), bounds, worldGen);
        }
        if (this.sides[1]) {
            for (int z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                this.replaceBlockState(world, f_73382_, pos.m_123341_() + model.width - 1, pos.m_123342_() + 1, pos.m_123343_() + z0, bounds, worldGen);
                this.replaceBlockState(world, f_73382_, pos.m_123341_() + model.width - 1, pos.m_123342_() + 2, pos.m_123343_() + z0, bounds, worldGen);
            }
            this.replaceBlockState(world, f_73382_, pos.m_123341_() + model.width - 1, pos.m_123342_() + 3, pos.m_123343_() + pathStartZ + 1, bounds, worldGen);
            stateProvider = model.getEntranceType() == 0 ? this.theme.stairs : this.secondaryTheme.stairs;
            pos1 = new BlockPos(pos.m_123341_() + model.width - 1, pos.m_123342_() + 3, pos.m_123343_() + pathStartZ);
            stair1 = stateProvider.get(world, pos1);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.f_61374_, Direction.NORTH);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.f_61402_, Half.TOP);
            this.replaceBlockState(world, stair1, pos1.m_123341_(), pos1.m_123342_(), pos1.m_123343_(), bounds, worldGen);
            pos2 = pos1.m_5484_(Direction.SOUTH, 2);
            stair2 = stateProvider.get(world, pos2);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.f_61374_, Direction.SOUTH);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.f_61402_, Half.TOP);
            this.replaceBlockState(world, stair2, pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_(), bounds, worldGen);
        }
        if (this.sides[2]) {
            for (int x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                this.replaceBlockState(world, f_73382_, pos.m_123341_() + x0, pos.m_123342_() + 1, pos.m_123343_() + model.length - 1, bounds, worldGen);
                this.replaceBlockState(world, f_73382_, pos.m_123341_() + x0, pos.m_123342_() + 2, pos.m_123343_() + model.length - 1, bounds, worldGen);
            }
            this.replaceBlockState(world, f_73382_, pos.m_123341_() + pathStartX + 1, pos.m_123342_() + 3, pos.m_123343_() + model.length - 1, bounds, worldGen);
            stateProvider = model.getEntranceType() == 0 ? this.theme.stairs : this.secondaryTheme.stairs;
            pos1 = new BlockPos(pos.m_123341_() + pathStartX, pos.m_123342_() + 3, pos.m_123343_() + model.length - 1);
            stair1 = stateProvider.get(world, pos1);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.f_61374_, Direction.WEST);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.f_61402_, Half.TOP);
            this.replaceBlockState(world, stair1, pos1.m_123341_(), pos1.m_123342_(), pos1.m_123343_(), bounds, worldGen);
            pos2 = pos1.m_5484_(Direction.EAST, 2);
            stair2 = stateProvider.get(world, pos2);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.f_61374_, Direction.EAST);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.f_61402_, Half.TOP);
            this.replaceBlockState(world, stair2, pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_(), bounds, worldGen);
        }
        if (this.sides[3]) {
            for (int z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                this.replaceBlockState(world, f_73382_, pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_() + z0, bounds, worldGen);
                this.replaceBlockState(world, f_73382_, pos.m_123341_(), pos.m_123342_() + 2, pos.m_123343_() + z0, bounds, worldGen);
            }
            this.replaceBlockState(world, f_73382_, pos.m_123341_(), pos.m_123342_() + 3, pos.m_123343_() + pathStartZ + 1, bounds, worldGen);
            BlockStateProvider stateProvider2 = model.getEntranceType() == 0 ? this.theme.stairs : this.secondaryTheme.stairs;
            pos1 = new BlockPos(pos.m_123341_(), pos.m_123342_() + 3, pos.m_123343_() + pathStartZ);
            stair1 = stateProvider2.get(world, pos1);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.f_61374_, Direction.NORTH);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.f_61402_, Half.TOP);
            this.replaceBlockState(world, stair1, pos1.m_123341_(), pos1.m_123342_(), pos1.m_123343_(), bounds, worldGen);
            pos2 = pos1.m_5484_(Direction.SOUTH, 2);
            stair2 = stateProvider2.get(world, pos2);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.f_61374_, Direction.SOUTH);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.f_61402_, Half.TOP);
            this.replaceBlockState(world, stair2, pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_(), bounds, worldGen);
        }
    }

    protected void decorate(LevelAccessor world, BlockPos pos, int width, int height, int length, Theme theme, BoundingBox worldGenBounds, BoundingBox structureBounds, DungeonModel model, boolean worldGen) {
        if (theme.hasDecorations()) {
            for (DungeonDecoration decoration : theme.getDecorations()) {
                if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
                    DungeonCrawl.LOGGER.debug("Running decoration {} for {} at ({} | {} | {})", (Object)decoration.toString(), (Object)model.getKey(), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
                }
                decoration.decorate(model, world, pos, width, height, length, worldGenBounds, structureBounds, this, this.stage, worldGen);
                if (!((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) continue;
                DungeonCrawl.LOGGER.debug("Finished decoration {} for {} at ({} | {} | {})", (Object)decoration.toString(), (Object)model.getKey(), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
            }
        }
    }

    protected void placeFeatures(LevelAccessor world, BoundingBox bounds, Theme theme, Theme.SecondaryTheme secondaryTheme, Random rand, int stage, boolean worldGen) {
        if (this.features != null) {
            for (DungeonModelFeature.Instance feature : this.features) {
                feature.place(world, bounds, rand, theme, secondaryTheme, stage, worldGen);
            }
        }
    }

    public static Direction getOneWayDirection(DungeonPiece piece) {
        if (piece.sides[0]) {
            return Direction.NORTH;
        }
        if (piece.sides[1]) {
            return Direction.EAST;
        }
        if (piece.sides[2]) {
            return Direction.SOUTH;
        }
        if (piece.sides[3]) {
            return Direction.WEST;
        }
        return Direction.NORTH;
    }

    public boolean canConnect(Direction side, int x, int z) {
        return true;
    }

    public static Direction getOpenSide(DungeonPiece piece, int n) {
        int c = 0;
        for (int i = 0; i < 4; ++i) {
            if (!piece.sides[i] || c++ != n) continue;
            return DungeonPiece.getDirectionFromInt(i);
        }
        throw new IllegalStateException(piece + " does not have " + n + "or more open sides.");
    }

    public static Direction getDirectionFromInt(int dir) {
        return switch (dir) {
            case 1 -> Direction.EAST;
            case 2 -> Direction.SOUTH;
            case 3 -> Direction.WEST;
            default -> Direction.NORTH;
        };
    }

    protected static DungeonModelFeature.Instance[] readAllFeatures(ListTag nbt) {
        DungeonModelFeature.Instance[] features = new DungeonModelFeature.Instance[nbt.size()];
        for (int i = 0; i < features.length; ++i) {
            features[i] = DungeonModelFeature.Instance.read(nbt.m_128728_(i));
        }
        return features;
    }

    protected static void writeAllFeatures(DungeonModelFeature.Instance[] positions, ListTag nbt) {
        for (DungeonModelFeature.Instance feature : positions) {
            CompoundTag position = new CompoundTag();
            feature.write(position);
            nbt.add((Object)position);
        }
    }
}

