/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece.room;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public class DungeonSpiderRoom
extends DungeonPiece {
    private BlockPos[] spawners;
    private BlockPos[] chests;

    public DungeonSpiderRoom(ServerLevel serverLevel, CompoundTag nbt) {
        super(StructurePieceTypes.SPIDER_ROOM, nbt);
        CompoundTag pos;
        int i;
        ListTag list;
        if (nbt.m_128441_("spawners")) {
            list = nbt.m_128437_("spawners", 10);
            this.spawners = new BlockPos[list.size()];
            for (i = 0; i < this.spawners.length; ++i) {
                pos = list.m_128728_(i);
                this.spawners[i] = new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z"));
            }
        }
        if (nbt.m_128441_("chests")) {
            list = nbt.m_128437_("chests", 10);
            this.chests = new BlockPos[list.size()];
            for (i = 0; i < this.chests.length; ++i) {
                pos = list.m_128728_(i);
                this.chests[i] = new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z"));
            }
        }
    }

    @Override
    public void customSetup(Random rand) {
        int floor = this.y + 1;
        int chests = 1 + rand.nextInt(2);
        int spawners = chests + rand.nextInt(2);
        this.chests = new BlockPos[chests];
        this.spawners = new BlockPos[spawners];
        int x = 0;
        int z = 0;
        for (int i = 0; i < spawners; ++i) {
            x = (x + 1 + rand.nextInt(3)) % 9;
            z = (z + 1 + rand.nextInt(3)) % 9;
            this.spawners[i] = new BlockPos(this.x + x, floor + rand.nextInt(2), this.z + z);
            if (i >= chests) continue;
            this.chests[i] = new BlockPos(this.spawners[i].m_123341_(), this.spawners[i].m_123342_() == floor ? floor + 1 : floor, this.spawners[i].m_123343_());
        }
    }

    public boolean m_7832_(WorldGenLevel p_230383_1_, StructureFeatureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, BoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        return true;
    }

    @Override
    public int getDungeonPieceType() {
        return 15;
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, Random rand) {
    }

    @Override
    public void createBoundingBox() {
        this.f_73383_ = new BoundingBox(this.x, this.y, this.z, this.x + 8, this.y + 8, this.z + 8);
    }

    @Override
    public void m_142347_(ServerLevel serverLevel, CompoundTag tagCompound) {
        CompoundTag compoundNBT;
        ListTag list;
        super.m_142347_(serverLevel, tagCompound);
        if (this.spawners != null) {
            list = new ListTag();
            for (BlockPos pos : this.spawners) {
                compoundNBT = new CompoundTag();
                compoundNBT.m_128405_("x", pos.m_123341_());
                compoundNBT.m_128405_("y", pos.m_123342_());
                compoundNBT.m_128405_("z", pos.m_123343_());
                list.add((Object)compoundNBT);
            }
            tagCompound.m_128365_("spawners", (Tag)list);
        }
        if (this.chests != null) {
            list = new ListTag();
            for (BlockPos pos : this.chests) {
                compoundNBT = new CompoundTag();
                compoundNBT.m_128405_("x", pos.m_123341_());
                compoundNBT.m_128405_("y", pos.m_123342_());
                compoundNBT.m_128405_("z", pos.m_123343_());
                list.add((Object)compoundNBT);
            }
            tagCompound.m_128365_("chests", (Tag)list);
        }
    }
}

