/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Blocks;
import org.jline.utils.InputStreamReader;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.theme.JsonTheming;
import xiroc.dungeoncrawl.util.IRandom;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class Theme {
    public static final Theme BUILTIN_DEFAULT_THEME = new Theme((world, pos, rotation) -> Blocks.f_50222_.m_49966_(), (world, pos, rotation) -> Blocks.f_50222_.m_49966_(), (world, pos, rotation) -> Blocks.f_50652_.m_49966_(), (world, pos, rotation) -> Blocks.f_49994_.m_49966_(), (world, pos, rotation) -> Blocks.f_50194_.m_49966_(), (world, pos, rotation) -> Blocks.f_50157_.m_49966_(), (world, pos, rotation) -> Blocks.f_50652_.m_49966_(), (world, pos, rotation) -> Blocks.f_50274_.m_49966_(), (world, pos, rotation) -> Blocks.f_50409_.m_49966_(), (world, pos, rotation) -> Blocks.f_50411_.m_49966_(), (world, pos, rotation) -> Blocks.f_50183_.m_49966_(), (world, pos, rotation) -> Blocks.f_49990_.m_49966_());
    public static final SecondaryTheme BUILTIN_DEFAULT_SECONDARY_THEME = new SecondaryTheme((world, pos, rotation) -> Blocks.f_49999_.m_49966_(), (world, pos, rotation) -> Blocks.f_50216_.m_49966_(), (world, pos, rotation) -> Blocks.f_50154_.m_49966_(), (world, pos, rotation) -> Blocks.f_50705_.m_49966_(), (world, pos, rotation) -> Blocks.f_50086_.m_49966_(), (world, pos, rotation) -> Blocks.f_50398_.m_49966_(), (world, pos, rotation) -> Blocks.f_50132_.m_49966_(), (world, pos, rotation) -> Blocks.f_50192_.m_49966_(), (world, pos, rotation) -> Blocks.f_50251_.m_49966_(), (world, pos, rotation) -> Blocks.f_50167_.m_49966_());
    protected static final Hashtable<String, IRandom<Theme>> BIOME_TO_THEME = new Hashtable();
    protected static final Hashtable<String, IRandom<SecondaryTheme>> BIOME_TO_SECONDARY_THEME = new Hashtable();
    public static final Hashtable<ResourceLocation, Theme> KEY_TO_THEME = new Hashtable();
    public static final Hashtable<ResourceLocation, SecondaryTheme> KEY_TO_SECONDARY_THEME = new Hashtable();
    private static WeightedRandom<Theme> DEFAULT_TOP_THEME = null;
    private static WeightedRandom<SecondaryTheme> DEFAULT_SECONDARY_TOP_THEME = null;
    private static IRandom<Theme> CATACOMBS_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<Theme> LOWER_CATACOMBS_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<Theme> HELL_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<SecondaryTheme> CATACOMBS_SECONDARY_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<SecondaryTheme> LOWER_CATACOMBS_SECONDARY_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<SecondaryTheme> HELL_SECONDARY_THEME = rand -> {
        throw new IllegalStateException();
    };
    public static final Hashtable<Integer, Theme> ID_TO_THEME = new Hashtable();
    public static final Hashtable<Integer, SecondaryTheme> ID_TO_SECONDARY_THEME = new Hashtable();
    private static final ResourceLocation PRIMARY_THEME_FALLBACK = DungeonCrawl.locate("vanilla/default");
    private static final ResourceLocation SECONDARY_THEME_FALLBACK = DungeonCrawl.locate("vanilla/oak");
    public static final ResourceLocation PRIMARY_HELL_MOSSY = DungeonCrawl.locate("vanilla/hell/mossy");
    private static final String PRIMARY_THEME_DIRECTORY = "theming/primary_themes";
    private static final String SECONDARY_THEME_DIRECTORY = "theming/secondary_themes";
    private static final String PRIMARY_THEME_MAPPINGS_DIRECTORY = "theming/mappings/primary";
    private static final String SECONDARY_THEME_MAPPINGS_DIRECTORY = "theming/mappings/secondary";
    private static final String UPPER_CATACOMBS_THEMES_DIRECTORY = "theming/lower_layers/upper_catacombs";
    private static final String CATACOMBS_THEMES_DIRECTORY = "theming/lower_layers/catacombs";
    private static final String HELL_THEMES_DIRECTORY = "theming/lower_layers/hell";
    private static ImmutableSet<ResourceLocation> THEME_KEYS;
    private static ImmutableSet<ResourceLocation> SECONDARY_THEME_KEYS;
    public final BlockStateProvider pillar;
    public final BlockStateProvider solid;
    public final BlockStateProvider generic;
    public final BlockStateProvider floor;
    public final BlockStateProvider solidStairs;
    public final BlockStateProvider stairs;
    public final BlockStateProvider material;
    public final BlockStateProvider wall;
    public final BlockStateProvider slab;
    public final BlockStateProvider solidSlab;
    public final BlockStateProvider fencing;
    public final BlockStateProvider fluid;
    public IRandom<SecondaryTheme> subTheme;
    private ResourceLocation key;
    private DungeonDecoration[] decorations;

    public Theme(BlockStateProvider pillar, BlockStateProvider solid, BlockStateProvider generic, BlockStateProvider floor, BlockStateProvider solidStairs, BlockStateProvider stairs, BlockStateProvider material, BlockStateProvider wall, BlockStateProvider slab, BlockStateProvider solidSlab, BlockStateProvider fencing, BlockStateProvider fluid) {
        this.solid = solid;
        this.material = material;
        this.generic = generic;
        this.pillar = pillar;
        this.floor = floor;
        this.stairs = stairs;
        this.solidStairs = solidStairs;
        this.slab = slab;
        this.solidSlab = solidSlab;
        this.wall = wall;
        this.fencing = fencing;
        this.fluid = fluid;
    }

    public void setDecorations(DungeonDecoration[] decorations) {
        this.decorations = decorations;
    }

    public boolean hasDecorations() {
        return this.decorations != null;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public DungeonDecoration[] getDecorations() {
        return this.decorations;
    }

    public BlockStateProvider getPillar() {
        return this.pillar;
    }

    public BlockStateProvider getSolid() {
        return this.solid;
    }

    public BlockStateProvider getGeneric() {
        return this.generic;
    }

    public BlockStateProvider getFencing() {
        return this.fencing;
    }

    public BlockStateProvider getFloor() {
        return this.floor;
    }

    public BlockStateProvider getFluid() {
        return this.fluid;
    }

    public BlockStateProvider getSolidStairs() {
        return this.solidStairs;
    }

    public BlockStateProvider getStairs() {
        return this.stairs;
    }

    public BlockStateProvider getMaterial() {
        return this.material;
    }

    public BlockStateProvider getWall() {
        return this.wall;
    }

    public BlockStateProvider getSlab() {
        return this.slab;
    }

    public BlockStateProvider getSolidSlab() {
        return this.solidSlab;
    }

    public static void loadJson(ResourceManager resourceManager) {
        JsonReader reader;
        Object theme;
        Object json;
        ResourceLocation key;
        JsonReader reader2;
        ID_TO_THEME.clear();
        ID_TO_SECONDARY_THEME.clear();
        KEY_TO_THEME.clear();
        KEY_TO_SECONDARY_THEME.clear();
        BIOME_TO_THEME.clear();
        BIOME_TO_SECONDARY_THEME.clear();
        ImmutableSet.Builder themeKeySetBuilder = new ImmutableSet.Builder();
        ImmutableSet.Builder secondaryThemeKeySetBuilder = new ImmutableSet.Builder();
        for (ResourceLocation resource : resourceManager.m_6540_(DungeonCrawl.locate(SECONDARY_THEME_DIRECTORY).m_135815_(), s -> s.endsWith(".json"))) {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)resource.toString());
            try {
                reader2 = new JsonReader((Reader)new InputStreamReader(resourceManager.m_142591_(resource).m_6679_()));
                key = DungeonCrawl.key(resource, SECONDARY_THEME_DIRECTORY, ".json");
                json = DungeonCrawl.JSON_PARSER.parse(reader2).getAsJsonObject();
                if (!JSONUtils.areRequirementsMet((JsonObject)json)) continue;
                theme = JsonTheming.deserializeSecondaryTheme((JsonObject)json, resource);
                ((SecondaryTheme)theme).key = key;
                secondaryThemeKeySetBuilder.add((Object)key);
                KEY_TO_SECONDARY_THEME.put(key, (SecondaryTheme)theme);
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource.toString());
                e.printStackTrace();
            }
        }
        for (ResourceLocation resource : resourceManager.m_6540_(DungeonCrawl.locate(PRIMARY_THEME_DIRECTORY).m_135815_(), s -> s.endsWith(".json"))) {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)resource.toString());
            try {
                reader2 = new JsonReader((Reader)new InputStreamReader(resourceManager.m_142591_(resource).m_6679_()));
                key = DungeonCrawl.key(resource, PRIMARY_THEME_DIRECTORY, ".json");
                json = DungeonCrawl.JSON_PARSER.parse(reader2).getAsJsonObject();
                if (!JSONUtils.areRequirementsMet((JsonObject)json)) continue;
                theme = JsonTheming.deserializeTheme((JsonObject)json, resource);
                ((Theme)theme).key = key;
                themeKeySetBuilder.add((Object)key);
                KEY_TO_THEME.put(key, (Theme)theme);
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource.toString());
                e.printStackTrace();
            }
        }
        Hashtable<String, WeightedRandom.Builder<Theme>> themeMappingBuilders = new Hashtable<String, WeightedRandom.Builder<Theme>>();
        Hashtable<String, WeightedRandom.Builder<SecondaryTheme>> secondaryThemeMappingBuilders = new Hashtable<String, WeightedRandom.Builder<SecondaryTheme>>();
        WeightedRandom.Builder<Theme> primaryDefaultBuilder = new WeightedRandom.Builder<Theme>();
        WeightedRandom.Builder<SecondaryTheme> secondaryDefaultBuilder = new WeightedRandom.Builder<SecondaryTheme>();
        for (ResourceLocation resource : resourceManager.m_6540_(PRIMARY_THEME_MAPPINGS_DIRECTORY, s -> s.endsWith(".json"))) {
            try {
                reader = new JsonReader((Reader)new InputStreamReader(resourceManager.m_142591_(resource).m_6679_()));
                JsonTheming.deserializeThemeMapping(DungeonCrawl.JSON_PARSER.parse(reader).getAsJsonObject(), themeMappingBuilders, primaryDefaultBuilder, resource);
            }
            catch (IOException e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource);
                e.printStackTrace();
            }
        }
        for (ResourceLocation resource : resourceManager.m_6540_(SECONDARY_THEME_MAPPINGS_DIRECTORY, s -> s.endsWith(".json"))) {
            try {
                reader = new JsonReader((Reader)new InputStreamReader(resourceManager.m_142591_(resource).m_6679_()));
                JsonTheming.deserializeSecondaryThemeMapping(DungeonCrawl.JSON_PARSER.parse(reader).getAsJsonObject(), secondaryThemeMappingBuilders, secondaryDefaultBuilder, resource);
            }
            catch (IOException e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource);
                e.printStackTrace();
            }
        }
        themeMappingBuilders.forEach((biome, builder) -> BIOME_TO_THEME.put((String)biome, builder.build()));
        secondaryThemeMappingBuilders.forEach((biome, builder) -> BIOME_TO_SECONDARY_THEME.put((String)biome, builder.build()));
        DEFAULT_TOP_THEME = primaryDefaultBuilder.build();
        DEFAULT_SECONDARY_TOP_THEME = secondaryDefaultBuilder.build();
        if (DEFAULT_TOP_THEME.isEmpty()) {
            throw new DatapackLoadException("No default primary themes are specified in the mappings.");
        }
        if (DEFAULT_SECONDARY_TOP_THEME.isEmpty()) {
            throw new DatapackLoadException("No default secondary themes are specified in the mappings.");
        }
        THEME_KEYS = themeKeySetBuilder.build();
        SECONDARY_THEME_KEYS = secondaryThemeKeySetBuilder.build();
        Tuple<WeightedRandom<Theme>, WeightedRandom<SecondaryTheme>> catacombs = Theme.loadRandomThemeFiles(UPPER_CATACOMBS_THEMES_DIRECTORY, resourceManager);
        Tuple<WeightedRandom<Theme>, WeightedRandom<SecondaryTheme>> lowerCatacombs = Theme.loadRandomThemeFiles(CATACOMBS_THEMES_DIRECTORY, resourceManager);
        Tuple<WeightedRandom<Theme>, WeightedRandom<SecondaryTheme>> hell = Theme.loadRandomThemeFiles(HELL_THEMES_DIRECTORY, resourceManager);
        CATACOMBS_THEME = (IRandom)catacombs.m_14418_();
        CATACOMBS_SECONDARY_THEME = (IRandom)catacombs.m_14419_();
        LOWER_CATACOMBS_THEME = (IRandom)lowerCatacombs.m_14418_();
        LOWER_CATACOMBS_SECONDARY_THEME = (IRandom)lowerCatacombs.m_14419_();
        HELL_THEME = (IRandom)hell.m_14418_();
        HELL_SECONDARY_THEME = (IRandom)hell.m_14419_();
    }

    private static Tuple<WeightedRandom<Theme>, WeightedRandom<SecondaryTheme>> loadRandomThemeFiles(String directory, ResourceManager resourceManager) {
        WeightedRandom.Builder<Theme> primary = new WeightedRandom.Builder<Theme>();
        WeightedRandom.Builder<SecondaryTheme> secondary = new WeightedRandom.Builder<SecondaryTheme>();
        for (ResourceLocation resource : resourceManager.m_6540_(directory, s -> s.endsWith(".json"))) {
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resourceManager.m_142591_(resource).m_6679_()));
                JsonTheming.deserializeRandomThemeFile(DungeonCrawl.JSON_PARSER.parse(reader).getAsJsonObject(), primary, secondary, resource);
            }
            catch (IOException e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource);
                e.printStackTrace();
            }
        }
        if (primary.entries.isEmpty()) {
            throw new DatapackLoadException("No primary themes were present after loading " + directory);
        }
        if (secondary.entries.isEmpty()) {
            throw new DatapackLoadException("No secondary themes were present after loading " + directory);
        }
        return new Tuple(primary.build(), secondary.build());
    }

    public static Theme getBuiltinDefaultTheme() {
        return KEY_TO_THEME.getOrDefault(PRIMARY_THEME_FALLBACK, BUILTIN_DEFAULT_THEME);
    }

    public static SecondaryTheme getBuiltinDefaultSecondaryTheme() {
        return KEY_TO_SECONDARY_THEME.getOrDefault(SECONDARY_THEME_FALLBACK, BUILTIN_DEFAULT_SECONDARY_THEME);
    }

    public static Theme randomTheme(String biome, Random rand) {
        return (Theme)((IRandom)BIOME_TO_THEME.getOrDefault(biome, DEFAULT_TOP_THEME)).roll(rand);
    }

    public static SecondaryTheme randomSecondaryTheme(String biome, Random rand) {
        return (SecondaryTheme)((IRandom)BIOME_TO_SECONDARY_THEME.getOrDefault(biome, DEFAULT_SECONDARY_TOP_THEME)).roll(rand);
    }

    public static Theme randomCatacombsTheme(Random rand) {
        return CATACOMBS_THEME.roll(rand);
    }

    public static SecondaryTheme randomCatacombsSecondaryTheme(Random rand) {
        return CATACOMBS_SECONDARY_THEME.roll(rand);
    }

    public static Theme randomLowerCatacombsTheme(Random rand) {
        return LOWER_CATACOMBS_THEME.roll(rand);
    }

    public static SecondaryTheme randomLowerCatacombsSecondaryTheme(Random rand) {
        return LOWER_CATACOMBS_SECONDARY_THEME.roll(rand);
    }

    public static Theme randomHellTheme(Random rand) {
        return HELL_THEME.roll(rand);
    }

    public static SecondaryTheme randomHellSecondaryTheme(Random rand) {
        return HELL_SECONDARY_THEME.roll(rand);
    }

    public static Theme getTheme(ResourceLocation key) {
        return KEY_TO_THEME.getOrDefault(key, KEY_TO_THEME.getOrDefault(PRIMARY_THEME_FALLBACK, BUILTIN_DEFAULT_THEME));
    }

    public static SecondaryTheme getSecondaryTheme(ResourceLocation key) {
        return KEY_TO_SECONDARY_THEME.getOrDefault(key, KEY_TO_SECONDARY_THEME.getOrDefault(SECONDARY_THEME_FALLBACK, BUILTIN_DEFAULT_SECONDARY_THEME));
    }

    public static Theme getThemeByID(int theme) {
        return ID_TO_THEME.getOrDefault(theme, ID_TO_THEME.getOrDefault(0, BUILTIN_DEFAULT_THEME));
    }

    public static SecondaryTheme getSubThemeByID(int id) {
        return ID_TO_SECONDARY_THEME.getOrDefault(id, ID_TO_SECONDARY_THEME.getOrDefault(0, BUILTIN_DEFAULT_SECONDARY_THEME));
    }

    public static ImmutableSet<ResourceLocation> getThemeKeys() {
        return THEME_KEYS;
    }

    public static ImmutableSet<ResourceLocation> getSecondaryThemeKeys() {
        return SECONDARY_THEME_KEYS;
    }

    static {
        Theme.BUILTIN_DEFAULT_THEME.key = new ResourceLocation("builtin:default");
        Theme.BUILTIN_DEFAULT_SECONDARY_THEME.key = new ResourceLocation("builtin:default");
        KEY_TO_THEME.put(Theme.BUILTIN_DEFAULT_THEME.key, BUILTIN_DEFAULT_THEME);
        KEY_TO_SECONDARY_THEME.put(Theme.BUILTIN_DEFAULT_SECONDARY_THEME.key, BUILTIN_DEFAULT_SECONDARY_THEME);
    }

    public static class SecondaryTheme {
        public final BlockStateProvider pillar;
        public final BlockStateProvider trapDoor;
        public final BlockStateProvider door;
        public final BlockStateProvider material;
        public final BlockStateProvider stairs;
        public final BlockStateProvider slab;
        public final BlockStateProvider fence;
        public final BlockStateProvider fenceGate;
        public final BlockStateProvider button;
        public final BlockStateProvider pressurePlate;
        private ResourceLocation key;

        public SecondaryTheme(BlockStateProvider pillar, BlockStateProvider trapDoor, BlockStateProvider door, BlockStateProvider material, BlockStateProvider stairs, BlockStateProvider slab, BlockStateProvider fence, BlockStateProvider fenceGate, BlockStateProvider button, BlockStateProvider pressurePlate) {
            this.pillar = pillar;
            this.trapDoor = trapDoor;
            this.door = door;
            this.material = material;
            this.stairs = stairs;
            this.slab = slab;
            this.fence = fence;
            this.fenceGate = fenceGate;
            this.button = button;
            this.pressurePlate = pressurePlate;
        }

        public ResourceLocation getKey() {
            return this.key;
        }

        public BlockStateProvider getPillar() {
            return this.pillar;
        }

        public BlockStateProvider getTrapDoor() {
            return this.trapDoor;
        }

        public BlockStateProvider getDoor() {
            return this.door;
        }

        public BlockStateProvider getMaterial() {
            return this.material;
        }

        public BlockStateProvider getStairs() {
            return this.stairs;
        }

        public BlockStateProvider getSlab() {
            return this.slab;
        }

        public BlockStateProvider getFence() {
            return this.fence;
        }

        public BlockStateProvider getFenceGate() {
            return this.fenceGate;
        }

        public BlockStateProvider getButton() {
            return this.button;
        }

        public BlockStateProvider getPressurePlate() {
            return this.pressurePlate;
        }
    }
}

