/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import java.util.Random;
import net.minecraft.util.Rotation;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonNodeRoom;

public class Node {
    public static final Node DEAD_END = new Node(false, false, false, true);
    public static final Node STRAIGHT = new Node(false, true, false, true);
    public static final Node TURN = new Node(false, false, true, true);
    public static final Node FORK = new Node(false, true, true, true);
    public static final Node FULL = new Node(true, true, true, true);
    private final boolean[] sides;

    public Node(boolean north, boolean east, boolean south, boolean west) {
        this.sides = new boolean[]{north, east, south, west};
    }

    public Node rotate(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return new Node(this.sides[3], this.sides[0], this.sides[1], this.sides[2]);
            }
            case COUNTERCLOCKWISE_90: {
                return new Node(this.sides[1], this.sides[2], this.sides[3], this.sides[0]);
            }
            case CLOCKWISE_180: {
                return new Node(this.sides[2], this.sides[3], this.sides[0], this.sides[1]);
            }
        }
        return this;
    }

    public Rotation compare(Node node, Random rand) {
        return Node.compare(node, this, Rotation.NONE, rand.nextBoolean() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90, 0);
    }

    private static Rotation compare(Node node, Node rotatedNode, Rotation currentRotation, Rotation step, int depth) {
        if (depth > 3) {
            return null;
        }
        for (int i = 0; i < node.sides.length; ++i) {
            if (!node.sides[i] || rotatedNode.sides[i]) continue;
            return Node.compare(node, rotatedNode.rotate(step), currentRotation.func_185830_a(step), step, ++depth);
        }
        return currentRotation;
    }

    public static Node getForNodeRoom(DungeonNodeRoom nodeRoom) {
        switch (nodeRoom.connectedSides) {
            case 1: {
                return DEAD_END;
            }
            case 2: {
                if (nodeRoom.sides[0] && nodeRoom.sides[2] || nodeRoom.sides[1] && nodeRoom.sides[3]) {
                    return STRAIGHT;
                }
                return TURN;
            }
            case 3: {
                return FORK;
            }
        }
        return FULL;
    }
}

