/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.generator.layer;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.Tile;
import xiroc.dungeoncrawl.dungeon.generator.layer.LayerGenerator;
import xiroc.dungeoncrawl.dungeon.generator.layer.LayerGeneratorSettings;
import xiroc.dungeoncrawl.dungeon.piece.DungeonCorridor;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.piece.DungeonStairs;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonRoom;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.Position2D;

public class DefaultLayerGenerator
extends LayerGenerator {
    public static final DefaultLayerGenerator INSTANCE = new DefaultLayerGenerator();
    private int nodesLeft;
    private int roomsLeft;
    private boolean secretRoom;
    @Nullable
    private DungeonPiece farthestRoom;
    private final List<DungeonCorridor> corridors = new ArrayList<DungeonCorridor>();

    @Override
    public void initializeLayer(LayerGeneratorSettings settings, DungeonBuilder dungeonBuilder, Random rand, int layer, boolean isLastLayer) {
        super.initializeLayer(settings, dungeonBuilder, rand, layer, isLastLayer);
        this.nodesLeft = settings.nodes.func_186511_a(rand);
        this.roomsLeft = settings.rooms.func_186511_a(rand);
        this.secretRoom = false;
        this.farthestRoom = null;
        this.corridors.clear();
    }

    @Override
    public void generateLayer(DungeonBuilder dungeonBuilder, DungeonLayer dungeonLayer, int layer, Random rand, Position2D start) {
        int i;
        DungeonStairs startPiece = new DungeonStairs(null, DungeonPiece.DEFAULT_NBT).bottom();
        startPiece.setGridPosition(start.x, start.z);
        dungeonLayer.grid[startPiece.gridPosition.x][startPiece.gridPosition.z] = new Tile(startPiece).addFlag(Tile.Flag.FIXED_ROTATION);
        dungeonLayer.stairsPlaced = false;
        dungeonLayer.start = start;
        Direction direction = Orientation.RANDOM_HORIZONTAL_FACING.roll(rand);
        DungeonCrawl.LOGGER.info("Initial generation of layer {}", (Object)layer);
        for (i = rand.nextInt(2); i < 4; ++i) {
            this.findPositionAndContinue(dungeonLayer, start, direction, rand, this.settings.minDistance, this.settings.maxDistance, layer, 1);
            direction = direction.func_176746_e();
        }
        if (!dungeonLayer.stairsPlaced) {
            if (this.farthestRoom != null) {
                DungeonStairs stairs = new DungeonStairs().top();
                stairs.takeOverProperties(this.farthestRoom);
                stairs.setGridPosition(this.farthestRoom.gridPosition);
                dungeonLayer.grid[stairs.gridPosition.x][stairs.gridPosition.z] = new Tile(stairs);
                dungeonLayer.end = stairs.gridPosition;
            } else {
                dungeonLayer.end = start;
            }
        }
        if (layer == 0) {
            DefaultLayerGenerator.createStarterRoom(dungeonLayer, rand, layer);
        }
        if (this.secretRoom && !this.corridors.isEmpty()) {
            DungeonCorridor corridor;
            for (i = 0; !(i >= 8 || (corridor = this.corridors.get(rand.nextInt(this.corridors.size()))).isStraight() && corridor.connectedSides == 2 && dungeonLayer.placeSecretRoom(corridor, corridor.gridPosition, rand)); ++i) {
                this.corridors.remove((Object)corridor);
            }
        }
    }

    @Override
    public void enableSecretRoom() {
        this.secretRoom = true;
    }

    private void layerGenerationStep(DungeonLayer dungeonLayer, Position2D currentPosition, Position2D lastPosition, Random rand, int layer, int depth) {
        Position2D center;
        if (depth > this.settings.maxDepth || this.nodesLeft == 0 && this.roomsLeft == 0) {
            return;
        }
        if (depth >= this.settings.minStairsDepth && !dungeonLayer.stairsPlaced) {
            Direction toLast = currentPosition.directionTo(lastPosition);
            dungeonLayer.end = currentPosition;
            DungeonStairs stairs = new DungeonStairs(null, DungeonPiece.DEFAULT_NBT).top();
            stairs.openSide(toLast);
            stairs.setGridPosition(dungeonLayer.end.x, dungeonLayer.end.z);
            dungeonLayer.grid[stairs.gridPosition.x][stairs.gridPosition.z] = new Tile(stairs).addFlag(Tile.Flag.FIXED_ROTATION);
            dungeonLayer.stairsPlaced = true;
            this.connectStraight(dungeonLayer, lastPosition, currentPosition, rand, layer);
            Direction[] directions = Orientation.getHorizontalFacingsWithout(toLast);
            int maxDirections = depth < 3 ? 1 + rand.nextInt(3) : rand.nextInt(3);
            int counter = 0;
            int start = rand.nextInt(3);
            for (int i = 0; i < 3; ++i) {
                Direction direction;
                if (counter >= maxDirections || !this.findPositionAndContinue(dungeonLayer, currentPosition, direction = directions[(i + start) % 3], rand, this.settings.minDistance, this.settings.maxDistance, layer, ++depth)) continue;
                ++counter;
            }
            return;
        }
        if ((double)rand.nextFloat() < 0.5 && depth <= this.settings.maxNodeDepth && depth >= this.settings.minNodeDepth && this.nodesLeft > 0 && dungeonLayer.canPlaceNode(center = currentPosition.shift(lastPosition.directionTo(currentPosition), 1))) {
            DefaultLayerGenerator.createNodeRoom(center, dungeonLayer);
            --this.nodesLeft;
            if (depth > 1) {
                dungeonLayer.distantNodes.add(center);
            }
            this.connectStraight(dungeonLayer, lastPosition, currentPosition, rand, layer);
            Direction[] directions = Orientation.getHorizontalFacingsWithout(currentPosition.directionTo(lastPosition));
            int maxDirections = depth < 5 ? 2 + rand.nextInt(2) : rand.nextInt(3);
            int start = rand.nextInt(3);
            for (int i = 0; i < maxDirections; ++i) {
                Direction direction = directions[(i + start) % 3];
                this.findPositionAndContinue(dungeonLayer, center.shift(direction, 1), direction, rand, this.settings.minDistance, this.settings.maxDistance, layer, ++depth);
            }
            return;
        }
        if (depth <= this.settings.maxRoomDepth && depth >= this.settings.minRoomDepth && this.roomsLeft > 0) {
            DungeonRoom room = new DungeonRoom(null, DungeonPiece.DEFAULT_NBT);
            room.setGridPosition(currentPosition);
            dungeonLayer.grid[currentPosition.x][currentPosition.z] = new Tile(room);
            --this.roomsLeft;
            if (this.farthestRoom == null || dungeonLayer.distance(currentPosition, dungeonLayer.start) > dungeonLayer.distance(this.farthestRoom.gridPosition, dungeonLayer.start)) {
                this.farthestRoom = room;
            }
            this.connectStraight(dungeonLayer, lastPosition, currentPosition, rand, layer);
            Direction[] directions = Orientation.getHorizontalFacingsWithout(currentPosition.directionTo(lastPosition));
            int maxDirections = depth < 5 ? 2 + rand.nextInt(2) : rand.nextInt(3);
            int start = rand.nextInt(3);
            for (int i = 0; i < maxDirections; ++i) {
                Direction direction = directions[(i + start) % 3];
                this.findPositionAndContinue(dungeonLayer, currentPosition, direction, rand, this.settings.minDistance, this.settings.maxDistance, layer, ++depth);
            }
        }
    }

    private boolean findPositionAndContinue(DungeonLayer dungeonLayer, Position2D origin, Direction direction, Random rand, int min, int max, int layer, int depth) {
        switch (direction) {
            case NORTH: {
                if (origin.z > min) {
                    Position2D pos = origin.shift(direction, min + rand.nextInt(Math.min(max, origin.z) - min + 1));
                    if (dungeonLayer.grid[pos.x][pos.z] == null && dungeonLayer.map.isPositionFree(pos.x, pos.z)) {
                        this.layerGenerationStep(dungeonLayer, pos, origin, rand, layer, depth);
                        return true;
                    }
                }
                return false;
            }
            case EAST: {
                int east = 15 - origin.x - 1;
                if (east > min) {
                    Position2D pos = origin.shift(direction, min + rand.nextInt(Math.min(max, east) - min + 1));
                    if (dungeonLayer.grid[pos.x][pos.z] == null && dungeonLayer.map.isPositionFree(pos.x, pos.z)) {
                        this.layerGenerationStep(dungeonLayer, pos, origin, rand, layer, depth);
                        return true;
                    }
                }
                return false;
            }
            case SOUTH: {
                int south = 15 - origin.z - 1;
                if (south > min) {
                    Position2D pos = origin.shift(direction, min + rand.nextInt(Math.min(max, south) - min + 1));
                    if (dungeonLayer.grid[pos.x][pos.z] == null && dungeonLayer.map.isPositionFree(pos.x, pos.z)) {
                        this.layerGenerationStep(dungeonLayer, pos, origin, rand, layer, depth);
                        return true;
                    }
                }
                return false;
            }
            case WEST: {
                if (origin.x > min) {
                    Position2D pos = origin.shift(direction, min + rand.nextInt(Math.min(max, origin.x) - min + 1));
                    if (dungeonLayer.grid[pos.x][pos.z] == null && dungeonLayer.map.isPositionFree(pos.x, pos.z)) {
                        this.layerGenerationStep(dungeonLayer, pos, origin, rand, layer, depth);
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectStraight(DungeonLayer dungeonLayer, Position2D start, Position2D end, Random rand, int layer) {
        if (start.x == end.x && start.z == end.z) throw new IllegalArgumentException("The start and end positions of a straight connection must not be the same.");
        if (start.x == end.x) {
            if (start.z > end.z) {
                dungeonLayer.openSideIfPresent(start, Direction.NORTH);
                dungeonLayer.openSideIfPresent(end, Direction.SOUTH);
                for (int z = start.z - 1; z > end.z; --z) {
                    if (dungeonLayer.grid[start.x][z] != null) {
                        DungeonPiece piece = dungeonLayer.grid[start.x][z].piece;
                        if (!piece.canConnect(Direction.NORTH, start.x, z) || !piece.canConnect(Direction.SOUTH, start.x, z)) continue;
                        piece.openSide(Direction.NORTH);
                        piece.openSide(Direction.SOUTH);
                        continue;
                    }
                    DungeonCorridor corridor = new DungeonCorridor();
                    corridor.setGridPosition(start.x, z);
                    corridor.openSide(Direction.NORTH);
                    corridor.openSide(Direction.SOUTH);
                    corridor.setRotation(Orientation.getRotationFromFacing(Direction.NORTH));
                    dungeonLayer.grid[corridor.gridPosition.x][corridor.gridPosition.z] = new Tile(corridor);
                    this.corridors.add(corridor);
                    this.rollForAdditionalNode(dungeonLayer, corridor.gridPosition.x, corridor.gridPosition.z, Direction.EAST, rand, layer);
                    this.rollForAdditionalNode(dungeonLayer, corridor.gridPosition.x, corridor.gridPosition.z, Direction.WEST, rand, layer);
                }
                return;
            } else {
                dungeonLayer.openSideIfPresent(start, Direction.SOUTH);
                dungeonLayer.openSideIfPresent(end, Direction.NORTH);
                for (int z = start.z + 1; z < end.z; ++z) {
                    if (dungeonLayer.grid[start.x][z] != null) {
                        DungeonPiece piece = dungeonLayer.grid[start.x][z].piece;
                        if (!piece.canConnect(Direction.SOUTH, start.x, z) || !piece.canConnect(Direction.NORTH, start.x, z)) continue;
                        piece.openSide(Direction.SOUTH);
                        piece.openSide(Direction.NORTH);
                        continue;
                    }
                    DungeonCorridor corridor = new DungeonCorridor();
                    corridor.setGridPosition(start.x, z);
                    corridor.openSide(Direction.SOUTH);
                    corridor.openSide(Direction.NORTH);
                    corridor.setRotation(Orientation.getRotationFromFacing(Direction.SOUTH));
                    dungeonLayer.grid[corridor.gridPosition.x][corridor.gridPosition.z] = new Tile(corridor);
                    this.corridors.add(corridor);
                    this.rollForAdditionalNode(dungeonLayer, corridor.gridPosition.x, corridor.gridPosition.z, Direction.WEST, rand, layer);
                    this.rollForAdditionalNode(dungeonLayer, corridor.gridPosition.x, corridor.gridPosition.z, Direction.EAST, rand, layer);
                }
            }
            return;
        } else {
            if (start.z != end.z) throw new IllegalArgumentException("The start and end positions of a straight connection must have either the same x-coordinate or the same z-coordinate");
            if (start.x > end.x) {
                dungeonLayer.openSideIfPresent(start, Direction.WEST);
                dungeonLayer.openSideIfPresent(end, Direction.EAST);
                for (int x = start.x - 1; x > end.x; --x) {
                    if (dungeonLayer.grid[x][start.z] != null) {
                        DungeonPiece piece = dungeonLayer.grid[x][start.z].piece;
                        if (!piece.canConnect(Direction.WEST, x, start.z) || !piece.canConnect(Direction.EAST, x, start.z)) continue;
                        piece.openSide(Direction.WEST);
                        piece.openSide(Direction.EAST);
                        continue;
                    }
                    DungeonCorridor corridor = new DungeonCorridor();
                    corridor.setGridPosition(x, start.z);
                    corridor.openSide(Direction.WEST);
                    corridor.openSide(Direction.EAST);
                    corridor.setRotation(Orientation.getRotationFromFacing(Direction.WEST));
                    dungeonLayer.grid[corridor.gridPosition.x][corridor.gridPosition.z] = new Tile(corridor);
                    this.corridors.add(corridor);
                    this.rollForAdditionalNode(dungeonLayer, corridor.gridPosition.x, corridor.gridPosition.z, Direction.NORTH, rand, layer);
                    this.rollForAdditionalNode(dungeonLayer, corridor.gridPosition.x, corridor.gridPosition.z, Direction.SOUTH, rand, layer);
                }
                return;
            } else {
                dungeonLayer.openSideIfPresent(start, Direction.EAST);
                dungeonLayer.openSideIfPresent(end, Direction.WEST);
                for (int x = start.x + 1; x < end.x; ++x) {
                    if (dungeonLayer.grid[x][start.z] != null) {
                        DungeonPiece piece = dungeonLayer.grid[x][start.z].piece;
                        if (!piece.canConnect(Direction.EAST, x, start.z) || !piece.canConnect(Direction.WEST, x, start.z)) continue;
                        piece.openSide(Direction.EAST);
                        piece.openSide(Direction.WEST);
                        continue;
                    }
                    DungeonCorridor corridor = new DungeonCorridor();
                    corridor.setGridPosition(x, start.z);
                    corridor.openSide(Direction.EAST);
                    corridor.openSide(Direction.WEST);
                    corridor.setRotation(Orientation.getRotationFromFacing(Direction.EAST));
                    dungeonLayer.grid[corridor.gridPosition.x][corridor.gridPosition.z] = new Tile(corridor);
                    this.corridors.add(corridor);
                    this.rollForAdditionalNode(dungeonLayer, corridor.gridPosition.x, corridor.gridPosition.z, Direction.SOUTH, rand, layer);
                    this.rollForAdditionalNode(dungeonLayer, corridor.gridPosition.x, corridor.gridPosition.z, Direction.NORTH, rand, layer);
                }
            }
        }
    }

    private void rollForAdditionalNode(DungeonLayer dungeonLayer, int corridorX, int corridorZ, Direction direction, Random rand, int layer) {
        Position2D corridor;
        Position2D center;
        if (this.nodesLeft > 0 && (double)rand.nextFloat() < 0.2 && (center = (corridor = new Position2D(corridorX, corridorZ)).shift(direction, 3)).isValid(dungeonLayer.width, dungeonLayer.length) && dungeonLayer.canPlaceNode(center)) {
            DefaultLayerGenerator.createNodeRoom(center, dungeonLayer);
            --this.nodesLeft;
            this.connectStraight(dungeonLayer, center.shift(direction.func_176734_d(), 1), corridor, rand, layer);
            Direction[] directions = Orientation.getHorizontalFacingsWithout(center.directionTo(corridor));
            int count = rand.nextInt(3);
            int start = rand.nextInt(3);
            for (int i = 0; i < 3 && count > 0; ++i) {
                Direction dir = directions[(i + start) % 3];
                if (!this.findPositionAndContinue(dungeonLayer, center.shift(dir, 1), dir, rand, this.settings.minDistance, this.settings.maxDistance, layer, 1)) continue;
                --count;
            }
        }
    }
}

