/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.util.IRandom;

public class WeightedRandomEntity
implements IRandom<EntityType<?>> {
    public static final WeightedRandomEntity EMPTY = new WeightedRandomEntity(new Builder.Entry[0]);
    private final WeightedEntry[] entries;

    private WeightedRandomEntity(Tuple<String, Integer>[] entries) {
        int weight = 0;
        for (Tuple<String, Integer> entry : entries) {
            weight += ((Integer)entry.func_76340_b()).intValue();
        }
        this.entries = new WeightedEntry[entries.length];
        this.assign(entries, weight);
    }

    private void assign(Tuple<String, Integer>[] entries, int totalWeight) {
        float f = 0.0f;
        int i = 0;
        for (Tuple<String, Integer> entry : entries) {
            float weight = (float)((Integer)entry.func_76340_b()).intValue() / (float)totalWeight;
            this.entries[i] = new WeightedEntry((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation((String)entry.func_76341_a())), Float.valueOf(weight + f));
            f += weight;
            ++i;
        }
    }

    @Override
    public EntityType<?> roll(Random rand) {
        float f = rand.nextFloat();
        for (WeightedEntry entry : this.entries) {
            if (!(((Float)entry.func_76340_b()).floatValue() >= f)) continue;
            return (EntityType)entry.func_76341_a();
        }
        return null;
    }

    public static WeightedRandomEntity fromJson(JsonArray array) {
        if (array.size() == 0) {
            return EMPTY;
        }
        Builder builder = new Builder();
        array.forEach(element -> {
            JsonObject object = element.getAsJsonObject();
            int weight = object.has("weight") ? object.get("weight").getAsInt() : 1;
            builder.add(object.get("entity").getAsString(), weight);
        });
        return builder.build();
    }

    public static class Builder {
        private final ArrayList<Entry> list = new ArrayList();

        public Builder add(String item, int weight) {
            this.list.add(new Entry(item, weight));
            return this;
        }

        public WeightedRandomEntity build() {
            if (this.list.isEmpty()) {
                return EMPTY;
            }
            return new WeightedRandomEntity(this.list.toArray(new Entry[0]));
        }

        private static class Entry
        extends Tuple<String, Integer> {
            public Entry(String aIn, Integer bIn) {
                super((Object)aIn, (Object)bIn);
            }
        }
    }

    private static class WeightedEntry
    extends Tuple<EntityType<?>, Float> {
        public WeightedEntry(EntityType<?> aIn, Float bIn) {
            super(aIn, (Object)bIn);
        }
    }
}

