/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonType;
import xiroc.dungeoncrawl.dungeon.PlacementContext;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.decoration.IDungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelFeature;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.model.MultipartModelData;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.IBlockStateProvider;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.Position2D;

public abstract class DungeonPiece
extends StructurePiece {
    public static final CompoundNBT DEFAULT_NBT = new CompoundNBT();
    public Rotation field_186169_c;
    public int connectedSides;
    public int x;
    public int y;
    public int z;
    public int stage;
    public boolean[] sides = new boolean[4];
    @Nullable
    public DungeonModelFeature.Instance[] features;
    public byte[] variation;
    public DungeonModel model;
    public Theme theme;
    public Theme.SecondaryTheme secondaryTheme;
    public Position2D gridPosition;
    public final PlacementContext context;

    public DungeonPiece(IStructurePieceType p_i51343_1_) {
        super(p_i51343_1_, DEFAULT_NBT);
        this.field_186169_c = Rotation.NONE;
        this.context = new PlacementContext();
        this.gridPosition = new Position2D(0, 0);
    }

    public DungeonPiece(IStructurePieceType p_i51343_1_, CompoundNBT p_i51343_2_) {
        super(p_i51343_1_, p_i51343_2_);
        this.sides[0] = p_i51343_2_.func_74767_n("north");
        this.sides[1] = p_i51343_2_.func_74767_n("east");
        this.sides[2] = p_i51343_2_.func_74767_n("south");
        this.sides[3] = p_i51343_2_.func_74767_n("west");
        this.connectedSides = p_i51343_2_.func_74762_e("connectedSides");
        this.gridPosition = new Position2D(p_i51343_2_.func_74762_e("posX"), p_i51343_2_.func_74762_e("posZ"));
        this.x = p_i51343_2_.func_74762_e("x");
        this.y = p_i51343_2_.func_74762_e("y");
        this.z = p_i51343_2_.func_74762_e("z");
        this.stage = p_i51343_2_.func_74762_e("stage");
        this.field_186169_c = Orientation.getRotation(p_i51343_2_.func_74762_e("rotation"));
        this.theme = p_i51343_2_.func_150297_b("theme", 99) ? Theme.getThemeByID(p_i51343_2_.func_74762_e("theme")) : Theme.getTheme(new ResourceLocation(p_i51343_2_.func_74779_i("theme")));
        this.secondaryTheme = p_i51343_2_.func_150297_b("subTheme", 99) ? Theme.getSubThemeByID(p_i51343_2_.func_74762_e("subTheme")) : Theme.getSecondaryTheme(new ResourceLocation(p_i51343_2_.func_74779_i("secondaryTheme")));
        this.model = p_i51343_2_.func_150297_b("model", 99) ? DungeonModels.ID_TO_MODEL.get(p_i51343_2_.func_74762_e("model")) : DungeonModels.KEY_TO_MODEL.get(new ResourceLocation(p_i51343_2_.func_74779_i("model")));
        if (p_i51343_2_.func_150297_b("features", 9)) {
            this.features = DungeonPiece.readAllFeatures(p_i51343_2_.func_150295_c("features", 10));
        }
        if (p_i51343_2_.func_74764_b("variation")) {
            this.variation = p_i51343_2_.func_74770_j("variation");
        }
        this.context = new PlacementContext();
        this.setupBoundingBox();
    }

    public void func_143011_b(CompoundNBT tagCompound) {
        tagCompound.func_74757_a("north", this.sides[0]);
        tagCompound.func_74757_a("east", this.sides[1]);
        tagCompound.func_74757_a("south", this.sides[2]);
        tagCompound.func_74757_a("west", this.sides[3]);
        tagCompound.func_74768_a("connectedSides", this.connectedSides);
        tagCompound.func_74768_a("posX", this.gridPosition.x);
        tagCompound.func_74768_a("posZ", this.gridPosition.z);
        tagCompound.func_74768_a("x", this.x);
        tagCompound.func_74768_a("y", this.y);
        tagCompound.func_74768_a("z", this.z);
        tagCompound.func_74768_a("stage", this.stage);
        tagCompound.func_74768_a("rotation", Orientation.rotationAsInt(this.field_186169_c));
        if (this.model != null) {
            tagCompound.func_74778_a("model", this.model.getKey().toString());
        }
        if (this.theme != null) {
            tagCompound.func_74778_a("theme", this.theme.getKey().toString());
        }
        if (this.secondaryTheme != null) {
            tagCompound.func_74778_a("secondaryTheme", this.secondaryTheme.getKey().toString());
        }
        if (this.features != null) {
            ListNBT list = new ListNBT();
            DungeonPiece.writeAllFeatures(this.features, list);
            tagCompound.func_218657_a("features", (INBT)list);
        }
        if (this.variation != null) {
            tagCompound.func_74773_a("variation", this.variation);
        }
    }

    public abstract int getDungeonPieceType();

    public abstract void setupModel(DungeonBuilder var1, ModelSelector var2, List<DungeonPiece> var3, Random var4);

    public abstract void setupBoundingBox();

    public void openSide(Direction side) {
        switch (side) {
            case NORTH: {
                if (this.sides[0]) {
                    return;
                }
                this.sides[0] = true;
                ++this.connectedSides;
                return;
            }
            case EAST: {
                if (this.sides[1]) {
                    return;
                }
                this.sides[1] = true;
                ++this.connectedSides;
                return;
            }
            case SOUTH: {
                if (this.sides[2]) {
                    return;
                }
                this.sides[2] = true;
                ++this.connectedSides;
                return;
            }
            case WEST: {
                if (this.sides[3]) {
                    return;
                }
                this.sides[3] = true;
                ++this.connectedSides;
            }
        }
    }

    public void setRotation(Rotation rotation) {
        this.field_186169_c = rotation;
    }

    public Rotation func_214809_Y_() {
        return this.field_186169_c;
    }

    public void setGridPosition(int x, int z) {
        this.gridPosition = new Position2D(x, z);
    }

    public void setGridPosition(Position2D position) {
        this.gridPosition = position;
    }

    public void setWorldPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void customSetup(Random rand) {
        if (this.model == null) {
            return;
        }
        if (this.model.hasFeatures()) {
            Vector3i offset = this.model.getOffset(this.field_186169_c);
            ArrayList<DungeonModelFeature.Instance> features = new ArrayList<DungeonModelFeature.Instance>();
            for (DungeonModelFeature feature : this.model.getFeatures()) {
                feature.setup(this.model, this.x + offset.func_177958_n(), this.y + offset.func_177956_o(), this.z + offset.func_177952_p(), this.field_186169_c, features, rand);
            }
            this.features = features.toArray(new DungeonModelFeature.Instance[0]);
        }
        if (this.model.isVariationEnabled()) {
            this.variation = new byte[8];
            for (int i = 0; i < this.variation.length; ++i) {
                this.variation[i] = (byte)rand.nextInt(64);
            }
        }
    }

    public void takeOverProperties(DungeonPiece piece) {
        this.sides = piece.sides;
        this.connectedSides = piece.connectedSides;
        this.field_186169_c = piece.field_186169_c;
    }

    public boolean hasChildPieces() {
        return this.model != null && this.model.hasMultipart();
    }

    public void addChildPieces(List<DungeonPiece> pieces, DungeonBuilder builder, DungeonType type, ModelSelector modelSelector, int layer, Random rand) {
        if (this.model != null && (this.model.hasMultipart() || type.getLayer(layer).hasMultipartOverride(this.model))) {
            BlockPos pos = new BlockPos(this.x, this.y, this.z).func_177971_a(this.model.getOffset(this.field_186169_c));
            for (MultipartModelData data : type.getLayer(layer).getMultipartData(this.model)) {
                if (data.checkConditions(this)) {
                    pieces.add(data.models.roll(rand).createMultipartPiece(this, this.model, this.field_186169_c, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), rand));
                    continue;
                }
                if (data.alternatives == null) continue;
                pieces.add(data.alternatives.roll(rand).createMultipartPiece(this, this.model, this.field_186169_c, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), rand));
            }
        }
    }

    public void setBlockState(BlockState state, IWorld world, BlockPos pos, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel, DungeonModelBlock block, DungeonModelBlockType type, PlacementContext context) {
        FluidState fluidState;
        if (state == null) {
            return;
        }
        if (DungeonBuilder.isBlockProtected(world, pos, context) || world.func_175623_d(pos) && !type.isSolid(world, pos, DungeonBlocks.RANDOM, 0, 0, 0)) {
            return;
        }
        Random rand = world.func_201674_k();
        IBlockPlacementHandler.getHandler(state.func_177230_c()).place(world, state, pos, rand, context, theme, secondaryTheme, lootLevel);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof LockableLootTileEntity) {
            if (this.model.hasLootTable()) {
                Loot.setLoot((LockableLootTileEntity)tile, this.model.getLootTable(), theme, secondaryTheme, rand);
            } else {
                Loot.setLoot((LockableLootTileEntity)tile, Loot.getLootTable(this.stage, rand), theme, secondaryTheme, rand);
            }
        }
        if (!(fluidState = world.func_204610_c(pos)).func_206888_e()) {
            world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), 0);
        }
    }

    public void replaceBlockState(IWorld worldIn, BlockState blockState, int x, int y, int z, MutableBoundingBox bounds, PlacementContext context) {
        BlockPos blockPos = new BlockPos(x, y, z);
        if (bounds.func_175898_b((Vector3i)blockPos)) {
            FluidState fluidstate;
            if (DungeonBuilder.isBlockProtected(worldIn, blockPos, context) || worldIn.func_175623_d(blockPos)) {
                return;
            }
            worldIn.func_180501_a(blockPos, blockState, 2);
            if (context.postProcessing) {
                worldIn.func_217349_x(blockPos).func_201594_d(blockPos);
            }
            if (!(fluidstate = worldIn.func_204610_c(blockPos)).func_206888_e()) {
                worldIn.func_205219_F_().func_205360_a(blockPos, (Object)fluidstate.func_206886_c(), 0);
            }
        }
    }

    public void build(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel, PlacementContext context, boolean fillAir) {
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Building {} at ({} | {} | {})", (Object)model.getKey(), (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
        model.blocks.forEach(block -> {
            BlockPos position = pos.func_177971_a(block.position);
            if (boundsIn.func_175898_b((Vector3i)position)) {
                BlockState state = block.type.blockFactory.get((DungeonModelBlock)block, Rotation.NONE, world, position, theme, secondaryTheme, world.func_201674_k(), this.variation, this.stage);
                if (state == null) {
                    return;
                }
                this.placeBlock((DungeonModelBlock)block, world, context, theme, secondaryTheme, lootLevel, fillAir, position, state);
                this.tryBuildFancyPillarPart(world, (DungeonModelBlock)block, position);
            }
        });
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Finished building {} at ({} | {} | {})", (Object)model.getKey(), (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
    }

    public void buildRotated(DungeonModel model, IWorld world, MutableBoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel, Rotation rotation, PlacementContext context, boolean fillAir) {
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Building {} with rotation {} at ({} | {} | {})", (Object)model.getKey(), (Object)rotation, (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                model.blocks.forEach(block -> {
                    BlockPos position = new BlockPos(pos.func_177958_n() + model.length - block.position.func_177952_p() - 1, pos.func_177956_o() + block.position.func_177956_o(), pos.func_177952_p() + block.position.func_177958_n());
                    if (boundsIn.func_175898_b((Vector3i)position)) {
                        BlockState state = block.type.blockFactory.get((DungeonModelBlock)block, Rotation.CLOCKWISE_90, world, position, theme, secondaryTheme, world.func_201674_k(), this.variation, this.stage);
                        if (state == null) {
                            return;
                        }
                        this.placeBlock((DungeonModelBlock)block, world, context, theme, secondaryTheme, lootLevel, fillAir, position, state);
                        this.tryBuildFancyPillarPart(world, (DungeonModelBlock)block, position);
                    }
                });
                break;
            }
            case COUNTERCLOCKWISE_90: {
                model.blocks.forEach(block -> {
                    BlockPos position = new BlockPos(pos.func_177958_n() + block.position.func_177952_p(), pos.func_177956_o() + block.position.func_177956_o(), pos.func_177952_p() + model.width - block.position.func_177958_n() - 1);
                    if (boundsIn.func_175898_b((Vector3i)position)) {
                        BlockState state = block.type.blockFactory.get((DungeonModelBlock)block, Rotation.COUNTERCLOCKWISE_90, world, position, theme, secondaryTheme, world.func_201674_k(), this.variation, this.stage);
                        if (state == null) {
                            return;
                        }
                        this.placeBlock((DungeonModelBlock)block, world, context, theme, secondaryTheme, lootLevel, fillAir, position, state);
                        this.tryBuildFancyPillarPart(world, (DungeonModelBlock)block, position);
                    }
                });
                break;
            }
            case CLOCKWISE_180: {
                model.blocks.forEach(block -> {
                    BlockPos position = new BlockPos(pos.func_177958_n() + model.width - block.position.func_177958_n() - 1, pos.func_177956_o() + block.position.func_177956_o(), pos.func_177952_p() + model.length - block.position.func_177952_p() - 1);
                    if (boundsIn.func_175898_b((Vector3i)position)) {
                        BlockState state = block.type.blockFactory.get((DungeonModelBlock)block, Rotation.CLOCKWISE_180, world, position, theme, secondaryTheme, world.func_201674_k(), this.variation, this.stage);
                        if (state == null) {
                            return;
                        }
                        this.placeBlock((DungeonModelBlock)block, world, context, theme, secondaryTheme, lootLevel, fillAir, position, state);
                        this.tryBuildFancyPillarPart(world, (DungeonModelBlock)block, position);
                    }
                });
                break;
            }
            case NONE: {
                this.build(model, world, boundsIn, pos, theme, secondaryTheme, lootLevel, context, fillAir);
                break;
            }
            default: {
                DungeonCrawl.LOGGER.warn("Failed to build a rotated dungeon segment: Unsupported rotation " + rotation);
            }
        }
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Finished building {} with rotation {} at ({} | {} | {})", (Object)model.getKey(), (Object)rotation, (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
    }

    public void placeBlock(DungeonModelBlock block, IWorld world, PlacementContext context, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel, boolean fillAir, BlockPos position, BlockState state) {
        this.setBlockState(state, world, position, theme, secondaryTheme, lootLevel, block, fillAir ? DungeonModelBlockType.SOLID : block.type, context);
        if (block.hasProperties && context.postProcessing) {
            world.func_217349_x(position).func_201594_d(position);
        }
    }

    protected void tryBuildFancyPillarPart(IWorld world, DungeonModelBlock block, BlockPos blockPos) {
        if (world.func_180495_p(blockPos).func_200132_m()) {
            BlockPos pos = blockPos.func_177979_c(block.position.func_177956_o() + 1);
            if (world.func_180495_p(pos).func_200132_m()) {
                return;
            }
            if (block.type.isPillar() && block.position.func_177956_o() < 2) {
                this.buildPillar(world, pos);
            } else if (block.type == DungeonModelBlockType.FLOOR) {
                this.buildFancyPillarPart(world, pos);
            }
        }
    }

    protected void buildPillar(IWorld world, BlockPos pos) {
        while (pos.func_177956_o() > 0) {
            if (world.func_180495_p(pos).func_200132_m()) {
                return;
            }
            world.func_180501_a(pos, this.theme.solid.get(world, pos), 2);
            pos = pos.func_177977_b();
        }
    }

    protected void buildFancyPillarPart(IWorld world, BlockPos pos) {
        int x = pos.func_177958_n() % 3;
        int z = pos.func_177952_p() % 4;
        if (x == 0) {
            switch (z) {
                case 0: {
                    this.buildPillar(world, pos);
                    return;
                }
                case -2: 
                case 1: {
                    BlockState stair = DungeonBlocks.applyProperty(this.theme.solidStairs.get(world, pos), BlockStateProperties.field_208157_J, Direction.NORTH);
                    stair = DungeonBlocks.applyProperty(stair, BlockStateProperties.field_208164_Q, Half.TOP);
                    world.func_180501_a(pos, stair, 2);
                    return;
                }
                case -1: 
                case 2: {
                    BlockState stair = DungeonBlocks.applyProperty(this.theme.solidStairs.get(world, pos), BlockStateProperties.field_208157_J, Direction.SOUTH);
                    stair = DungeonBlocks.applyProperty(stair, BlockStateProperties.field_208164_Q, Half.TOP);
                    world.func_180501_a(pos, stair, 2);
                }
            }
        } else if (z == 0) {
            BlockState stair = x == 1 || x == -2 ? DungeonBlocks.applyProperty(this.theme.solidStairs.get(world, pos), BlockStateProperties.field_208157_J, Direction.WEST) : DungeonBlocks.applyProperty(this.theme.solidStairs.get(world, pos), BlockStateProperties.field_208157_J, Direction.EAST);
            stair = DungeonBlocks.applyProperty(stair, BlockStateProperties.field_208164_Q, Half.TOP);
            world.func_180501_a(pos, stair, 2);
        }
    }

    protected void entrances(IWorld world, MutableBoundingBox bounds, DungeonModel model) {
        BlockState stair2;
        BlockPos pos2;
        BlockState stair1;
        BlockPos pos1;
        IBlockStateProvider stateProvider;
        int pathStartX = (model.width - 3) / 2;
        int pathStartZ = (model.length - 3) / 2;
        Vector3i offset = model.getOffset(this.field_186169_c);
        BlockPos pos = new BlockPos(this.x + offset.func_177958_n(), this.y, this.z + offset.func_177952_p());
        if (this.sides[0]) {
            for (int x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                this.replaceBlockState(world, field_202556_l, pos.func_177958_n() + x0, pos.func_177956_o() + 1, pos.func_177952_p(), bounds, this.context);
                this.replaceBlockState(world, field_202556_l, pos.func_177958_n() + x0, pos.func_177956_o() + 2, pos.func_177952_p(), bounds, this.context);
            }
            this.replaceBlockState(world, field_202556_l, pos.func_177958_n() + pathStartX + 1, pos.func_177956_o() + 3, pos.func_177952_p(), bounds, this.context);
            stateProvider = model.getEntranceType() == 0 ? this.theme.stairs : this.secondaryTheme.stairs;
            pos1 = new BlockPos(pos.func_177958_n() + pathStartX, pos.func_177956_o() + 3, pos.func_177952_p());
            stair1 = stateProvider.get(world, pos1);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.field_208157_J, Direction.WEST);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.field_208164_Q, Half.TOP);
            this.replaceBlockState(world, stair1, pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), bounds, this.context);
            pos2 = pos1.func_177967_a(Direction.EAST, 2);
            stair2 = stateProvider.get(world, pos2);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.field_208157_J, Direction.EAST);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.field_208164_Q, Half.TOP);
            this.replaceBlockState(world, stair2, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p(), bounds, this.context);
        }
        if (this.sides[1]) {
            for (int z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                this.replaceBlockState(world, field_202556_l, pos.func_177958_n() + model.width - 1, pos.func_177956_o() + 1, pos.func_177952_p() + z0, bounds, this.context);
                this.replaceBlockState(world, field_202556_l, pos.func_177958_n() + model.width - 1, pos.func_177956_o() + 2, pos.func_177952_p() + z0, bounds, this.context);
            }
            this.replaceBlockState(world, field_202556_l, pos.func_177958_n() + model.width - 1, pos.func_177956_o() + 3, pos.func_177952_p() + pathStartZ + 1, bounds, this.context);
            stateProvider = model.getEntranceType() == 0 ? this.theme.stairs : this.secondaryTheme.stairs;
            pos1 = new BlockPos(pos.func_177958_n() + model.width - 1, pos.func_177956_o() + 3, pos.func_177952_p() + pathStartZ);
            stair1 = stateProvider.get(world, pos1);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.field_208157_J, Direction.NORTH);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.field_208164_Q, Half.TOP);
            this.replaceBlockState(world, stair1, pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), bounds, this.context);
            pos2 = pos1.func_177967_a(Direction.SOUTH, 2);
            stair2 = stateProvider.get(world, pos2);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.field_208157_J, Direction.SOUTH);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.field_208164_Q, Half.TOP);
            this.replaceBlockState(world, stair2, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p(), bounds, this.context);
        }
        if (this.sides[2]) {
            for (int x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                this.replaceBlockState(world, field_202556_l, pos.func_177958_n() + x0, pos.func_177956_o() + 1, pos.func_177952_p() + model.length - 1, bounds, this.context);
                this.replaceBlockState(world, field_202556_l, pos.func_177958_n() + x0, pos.func_177956_o() + 2, pos.func_177952_p() + model.length - 1, bounds, this.context);
            }
            this.replaceBlockState(world, field_202556_l, pos.func_177958_n() + pathStartX + 1, pos.func_177956_o() + 3, pos.func_177952_p() + model.length - 1, bounds, this.context);
            stateProvider = model.getEntranceType() == 0 ? this.theme.stairs : this.secondaryTheme.stairs;
            pos1 = new BlockPos(pos.func_177958_n() + pathStartX, pos.func_177956_o() + 3, pos.func_177952_p() + model.length - 1);
            stair1 = stateProvider.get(world, pos1);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.field_208157_J, Direction.WEST);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.field_208164_Q, Half.TOP);
            this.replaceBlockState(world, stair1, pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), bounds, this.context);
            pos2 = pos1.func_177967_a(Direction.EAST, 2);
            stair2 = stateProvider.get(world, pos2);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.field_208157_J, Direction.EAST);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.field_208164_Q, Half.TOP);
            this.replaceBlockState(world, stair2, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p(), bounds, this.context);
        }
        if (this.sides[3]) {
            for (int z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                this.replaceBlockState(world, field_202556_l, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p() + z0, bounds, this.context);
                this.replaceBlockState(world, field_202556_l, pos.func_177958_n(), pos.func_177956_o() + 2, pos.func_177952_p() + z0, bounds, this.context);
            }
            this.replaceBlockState(world, field_202556_l, pos.func_177958_n(), pos.func_177956_o() + 3, pos.func_177952_p() + pathStartZ + 1, bounds, this.context);
            IBlockStateProvider stateProvider2 = model.getEntranceType() == 0 ? this.theme.stairs : this.secondaryTheme.stairs;
            pos1 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 3, pos.func_177952_p() + pathStartZ);
            stair1 = stateProvider2.get(world, pos1);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.field_208157_J, Direction.NORTH);
            stair1 = DungeonBlocks.applyProperty(stair1, BlockStateProperties.field_208164_Q, Half.TOP);
            this.replaceBlockState(world, stair1, pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), bounds, this.context);
            pos2 = pos1.func_177967_a(Direction.SOUTH, 2);
            stair2 = stateProvider2.get(world, pos2);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.field_208157_J, Direction.SOUTH);
            stair2 = DungeonBlocks.applyProperty(stair2, BlockStateProperties.field_208164_Q, Half.TOP);
            this.replaceBlockState(world, stair2, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p(), bounds, this.context);
        }
    }

    protected void decorate(IWorld world, BlockPos pos, PlacementContext context, int width, int height, int length, Theme theme, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds, DungeonModel model) {
        if (theme.hasDecorations()) {
            for (IDungeonDecoration decoration : theme.getDecorations()) {
                if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
                    DungeonCrawl.LOGGER.debug("Running decoration {} for {} at ({} | {} | {})", (Object)decoration.toString(), (Object)model.getKey(), (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
                }
                decoration.decorate(model, world, pos, context, width, height, length, worldGenBounds, structureBounds, this, this.stage);
                if (!((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) continue;
                DungeonCrawl.LOGGER.debug("Finished decoration {} for {} at ({} | {} | {})", (Object)decoration.toString(), (Object)model.getKey(), (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
            }
        }
    }

    protected void placeFeatures(IWorld world, PlacementContext context, MutableBoundingBox bounds, Theme theme, Theme.SecondaryTheme secondaryTheme, Random rand, int stage) {
        if (this.features != null) {
            for (DungeonModelFeature.Instance feature : this.features) {
                feature.place(world, context, bounds, rand, theme, secondaryTheme, stage);
            }
        }
    }

    public static void buildBoundingBox(IWorld world, MutableBoundingBox box, Block block) {
        BlockState state = block.func_176223_P();
        for (int x0 = box.field_78897_a; x0 < box.field_78893_d; ++x0) {
            world.func_180501_a(new BlockPos(x0, box.field_78895_b, box.field_78896_c), state, 2);
            world.func_180501_a(new BlockPos(x0, box.field_78895_b, box.field_78892_f), state, 2);
            world.func_180501_a(new BlockPos(x0, box.field_78894_e, box.field_78896_c), state, 2);
            world.func_180501_a(new BlockPos(x0, box.field_78894_e, box.field_78892_f), state, 2);
        }
        for (int y0 = box.field_78895_b; y0 < box.field_78894_e; ++y0) {
            world.func_180501_a(new BlockPos(box.field_78897_a, y0, box.field_78896_c), state, 2);
            world.func_180501_a(new BlockPos(box.field_78897_a, y0, box.field_78892_f), state, 2);
            world.func_180501_a(new BlockPos(box.field_78893_d, y0, box.field_78896_c), state, 2);
            world.func_180501_a(new BlockPos(box.field_78893_d, y0, box.field_78892_f), state, 2);
        }
        for (int z0 = box.field_78896_c; z0 < box.field_78892_f; ++z0) {
            world.func_180501_a(new BlockPos(box.field_78897_a, box.field_78895_b, z0), state, 2);
            world.func_180501_a(new BlockPos(box.field_78897_a, box.field_78894_e, z0), state, 2);
            world.func_180501_a(new BlockPos(box.field_78893_d, box.field_78895_b, z0), state, 2);
            world.func_180501_a(new BlockPos(box.field_78893_d, box.field_78894_e, z0), state, 2);
        }
        world.func_180501_a(new BlockPos(box.field_78893_d, box.field_78894_e, box.field_78892_f), state, 2);
    }

    public static Direction getOneWayDirection(DungeonPiece piece) {
        if (piece.sides[0]) {
            return Direction.NORTH;
        }
        if (piece.sides[1]) {
            return Direction.EAST;
        }
        if (piece.sides[2]) {
            return Direction.SOUTH;
        }
        if (piece.sides[3]) {
            return Direction.WEST;
        }
        return Direction.NORTH;
    }

    public boolean canConnect(Direction side, int x, int z) {
        return true;
    }

    public static Direction getOpenSide(DungeonPiece piece, int n) {
        int c = 0;
        for (int i = 0; i < 4; ++i) {
            if (!piece.sides[i] || c++ != n) continue;
            return DungeonPiece.getDirectionFromInt(i);
        }
        throw new IllegalStateException((Object)((Object)piece) + " does not have " + n + "or more open sides.");
    }

    public static Direction getDirectionFromInt(int dir) {
        switch (dir) {
            case 1: {
                return Direction.EAST;
            }
            case 2: {
                return Direction.SOUTH;
            }
            case 3: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }

    protected static DungeonModelFeature.Instance[] readAllFeatures(ListNBT nbt) {
        DungeonModelFeature.Instance[] features = new DungeonModelFeature.Instance[nbt.size()];
        for (int i = 0; i < features.length; ++i) {
            features[i] = DungeonModelFeature.Instance.read(nbt.func_150305_b(i));
        }
        return features;
    }

    protected static void writeAllFeatures(DungeonModelFeature.Instance[] positions, ListNBT nbt) {
        for (DungeonModelFeature.Instance feature : positions) {
            CompoundNBT position = new CompoundNBT();
            feature.write(position);
            nbt.add((Object)position);
        }
    }

    static {
        DEFAULT_NBT.func_74757_a("north", false);
        DEFAULT_NBT.func_74757_a("east", false);
        DEFAULT_NBT.func_74757_a("south", false);
        DEFAULT_NBT.func_74757_a("west", false);
        DEFAULT_NBT.func_74768_a("connectedSides", 0);
        DEFAULT_NBT.func_74768_a("posX", -1);
        DEFAULT_NBT.func_74768_a("posZ", -1);
        DEFAULT_NBT.func_74768_a("theme", 0);
        DEFAULT_NBT.func_74768_a("stage", -1);
        DEFAULT_NBT.func_74768_a("rotation", 0);
    }
}

