/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.init;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.init.ModStructureFeatures;

public class ModStructures {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"dungeoncrawl");
    public static final RegistryObject<Structure<NoFeatureConfig>> DUNGEON = STRUCTURES.register("dungeon", Dungeon::new);

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        STRUCTURES.register(modEventBus);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(ModStructures::onWorldLoad);
        forgeEventBus.addListener(EventPriority.HIGH, ModStructures::onBiomeLoad);
    }

    public static void register() {
        if ((Integer)Config.SPACING.get() <= (Integer)Config.SEPARATION.get() || (Integer)Config.SEPARATION.get() < 0) {
            throw new RuntimeException("Invalid dungeon spacing/separation settings in the config.");
        }
        StructureSeparationSettings dungeonSeparationSettings = new StructureSeparationSettings(((Integer)Config.SPACING.get()).intValue(), ((Integer)Config.SEPARATION.get()).intValue(), 10387313);
        ModStructures.registerStructure(DUNGEON, ModStructureFeatures.CONFIGURED_DUNGEON, dungeonSeparationSettings);
    }

    private static <FC extends IFeatureConfig> void registerStructure(RegistryObject<Structure<FC>> structure, StructureFeature<FC, ? extends Structure<FC>> configuredFeature, StructureSeparationSettings separationSettings) {
        ResourceLocation registryName = structure.getId();
        Structure.field_236365_a_.put((Object)registryName.toString(), (Object)structure.get());
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put((Object)structure.get(), (Object)separationSettings).build();
        Registry registry = WorldGenRegistries.field_243654_f;
        Registry.func_218322_a((Registry)registry, (ResourceLocation)registryName, configuredFeature);
        FlatGenerationSettings.field_202247_j.put(structure.get(), configuredFeature);
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureConfig = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureConfig instanceof ImmutableMap) {
                HashMap<IForgeRegistryEntry, StructureSeparationSettings> tempMap = new HashMap<IForgeRegistryEntry, StructureSeparationSettings>(structureConfig);
                tempMap.put(structure.get(), separationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureConfig.put(structure.get(), separationSettings);
            }
        });
    }

    private static void onBiomeLoad(BiomeLoadingEvent event) {
        if (!(!Dungeon.biomeCategories.contains(event.getCategory()) && event.getName() != null && !Dungeon.whitelistedBiomes.contains((Object)event.getName().toString()) || event.getName() != null && Dungeon.blacklistedBiomes.contains((Object)event.getName().toString()))) {
            DungeonCrawl.LOGGER.debug("Generating in biome {}", (Object)event.getName());
            event.getGeneration().func_242516_a(ModStructureFeatures.CONFIGURED_DUNGEON);
        } else {
            DungeonCrawl.LOGGER.debug("Ignoring biome {} with category {}", (Object)event.getName(), (Object)event.getCategory().func_222352_a());
        }
    }

    private static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            if (!Dungeon.whitelistedDimensions.contains((Object)serverWorld.func_234923_W_().func_240901_a_().toString())) {
                return;
            }
            if (serverWorld.func_72863_F().field_186029_c.func_205470_d() < 32) {
                DungeonCrawl.LOGGER.info("Ignoring dimension {} because it's spawn height is too low.", (Object)serverWorld.func_234923_W_().func_240901_a_());
                return;
            }
            DungeonCrawl.LOGGER.debug("Generating in dimension: {}", (Object)serverWorld.func_234923_W_().func_240901_a_());
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(DUNGEON.get(), DimensionStructuresSettings.field_236191_b_.get((Object)DUNGEON.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

